/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.GetJobChunksReadyForClientProcessingSpectraS3Response;
import com.spectralogic.ds3client.exceptions.RetryAfterExpectedException;
import com.spectralogic.ds3client.models.MasterObjectList;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import com.spectralogic.ds3client.utils.Guard;
import java.io.IOException;
import java.io.InputStream;

public class GetJobChunksReadyForClientProcessingSpectraS3ResponseParser
extends AbstractResponseParser<GetJobChunksReadyForClientProcessingSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{200};

    @Override
    public GetJobChunksReadyForClientProcessingSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 200: {
                    try (InputStream inputStream = response.getResponseStream();){
                        MasterObjectList result = XmlOutput.fromXml(inputStream, MasterObjectList.class);
                        if (Guard.isNullOrEmpty(result.getObjects())) {
                            GetJobChunksReadyForClientProcessingSpectraS3Response getJobChunksReadyForClientProcessingSpectraS3Response = new GetJobChunksReadyForClientProcessingSpectraS3Response(result, GetJobChunksReadyForClientProcessingSpectraS3ResponseParser.parseRetryAfter(response), GetJobChunksReadyForClientProcessingSpectraS3Response.Status.RETRYLATER, this.getChecksum(), this.getChecksumType());
                            return getJobChunksReadyForClientProcessingSpectraS3Response;
                        }
                        GetJobChunksReadyForClientProcessingSpectraS3Response getJobChunksReadyForClientProcessingSpectraS3Response = new GetJobChunksReadyForClientProcessingSpectraS3Response(result, 0, GetJobChunksReadyForClientProcessingSpectraS3Response.Status.AVAILABLE, this.getChecksum(), this.getChecksumType());
                        return getJobChunksReadyForClientProcessingSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }

    private static int parseRetryAfter(WebResponse webResponse) {
        String retryAfter = (String)webResponse.getHeaders().get("Retry-After").get(0);
        if (retryAfter == null) {
            throw new RetryAfterExpectedException();
        }
        return Integer.parseInt(retryAfter);
    }
}

