/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.OriginGroup;
import com.amazonaws.services.cloudfront.model.transform.OriginGroupFailoverCriteriaStaxUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.OriginGroupMembersStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class OriginGroupStaxUnmarshaller
implements Unmarshaller<OriginGroup, StaxUnmarshallerContext> {
    private static OriginGroupStaxUnmarshaller instance;

    public OriginGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        OriginGroup originGroup = new OriginGroup();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return originGroup;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Id", targetDepth)) {
                    originGroup.setId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("FailoverCriteria", targetDepth)) {
                    originGroup.setFailoverCriteria(OriginGroupFailoverCriteriaStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Members", targetDepth)) continue;
                originGroup.setMembers(OriginGroupMembersStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return originGroup;
    }

    public static OriginGroupStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new OriginGroupStaxUnmarshaller();
        }
        return instance;
    }
}

