/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="System defaults")
public class SystemDefaults {
    @JsonProperty(value="languageDefault")
    private String languageDefault = null;
    @JsonProperty(value="downloadShareDefaultExpirationPeriod")
    private Integer downloadShareDefaultExpirationPeriod = null;
    @JsonProperty(value="uploadShareDefaultExpirationPeriod")
    private Integer uploadShareDefaultExpirationPeriod = null;
    @JsonProperty(value="fileDefaultExpirationPeriod")
    private Integer fileDefaultExpirationPeriod = null;
    @JsonProperty(value="nonmemberViewerDefault")
    private Boolean nonmemberViewerDefault = null;
    @JsonProperty(value="hideLoginInputFields")
    private Boolean hideLoginInputFields = null;

    public SystemDefaults languageDefault(String languageDefault) {
        this.languageDefault = languageDefault;
        return this;
    }

    @Schema(description="Define which language should be default.")
    public String getLanguageDefault() {
        return this.languageDefault;
    }

    public void setLanguageDefault(String languageDefault) {
        this.languageDefault = languageDefault;
    }

    public SystemDefaults downloadShareDefaultExpirationPeriod(Integer downloadShareDefaultExpirationPeriod) {
        this.downloadShareDefaultExpirationPeriod = downloadShareDefaultExpirationPeriod;
        return this;
    }

    @Schema(description="Default expiration period for Download Shares in days.")
    public Integer getDownloadShareDefaultExpirationPeriod() {
        return this.downloadShareDefaultExpirationPeriod;
    }

    public void setDownloadShareDefaultExpirationPeriod(Integer downloadShareDefaultExpirationPeriod) {
        this.downloadShareDefaultExpirationPeriod = downloadShareDefaultExpirationPeriod;
    }

    public SystemDefaults uploadShareDefaultExpirationPeriod(Integer uploadShareDefaultExpirationPeriod) {
        this.uploadShareDefaultExpirationPeriod = uploadShareDefaultExpirationPeriod;
        return this;
    }

    @Schema(description="Default expiration period for Upload Shares in days.")
    public Integer getUploadShareDefaultExpirationPeriod() {
        return this.uploadShareDefaultExpirationPeriod;
    }

    public void setUploadShareDefaultExpirationPeriod(Integer uploadShareDefaultExpirationPeriod) {
        this.uploadShareDefaultExpirationPeriod = uploadShareDefaultExpirationPeriod;
    }

    public SystemDefaults fileDefaultExpirationPeriod(Integer fileDefaultExpirationPeriod) {
        this.fileDefaultExpirationPeriod = fileDefaultExpirationPeriod;
        return this;
    }

    @Schema(description="Default expiration period for all uploaded files in days.")
    public Integer getFileDefaultExpirationPeriod() {
        return this.fileDefaultExpirationPeriod;
    }

    public void setFileDefaultExpirationPeriod(Integer fileDefaultExpirationPeriod) {
        this.fileDefaultExpirationPeriod = fileDefaultExpirationPeriod;
    }

    public SystemDefaults nonmemberViewerDefault(Boolean nonmemberViewerDefault) {
        this.nonmemberViewerDefault = nonmemberViewerDefault;
        return this;
    }

    @Schema(description="&#128640; Since v4.12.0  Defines if new users get the role Non Member Viewer by default")
    public Boolean isNonmemberViewerDefault() {
        return this.nonmemberViewerDefault;
    }

    public void setNonmemberViewerDefault(Boolean nonmemberViewerDefault) {
        this.nonmemberViewerDefault = nonmemberViewerDefault;
    }

    public SystemDefaults hideLoginInputFields(Boolean hideLoginInputFields) {
        this.hideLoginInputFields = hideLoginInputFields;
        return this;
    }

    @Schema(description="&#128640; Since v4.13.0  Defines if login fields should be hidden")
    public Boolean isHideLoginInputFields() {
        return this.hideLoginInputFields;
    }

    public void setHideLoginInputFields(Boolean hideLoginInputFields) {
        this.hideLoginInputFields = hideLoginInputFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SystemDefaults systemDefaults = (SystemDefaults)o;
        return Objects.equals(this.languageDefault, systemDefaults.languageDefault) && Objects.equals(this.downloadShareDefaultExpirationPeriod, systemDefaults.downloadShareDefaultExpirationPeriod) && Objects.equals(this.uploadShareDefaultExpirationPeriod, systemDefaults.uploadShareDefaultExpirationPeriod) && Objects.equals(this.fileDefaultExpirationPeriod, systemDefaults.fileDefaultExpirationPeriod) && Objects.equals(this.nonmemberViewerDefault, systemDefaults.nonmemberViewerDefault) && Objects.equals(this.hideLoginInputFields, systemDefaults.hideLoginInputFields);
    }

    public int hashCode() {
        return Objects.hash(this.languageDefault, this.downloadShareDefaultExpirationPeriod, this.uploadShareDefaultExpirationPeriod, this.fileDefaultExpirationPeriod, this.nonmemberViewerDefault, this.hideLoginInputFields);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SystemDefaults {\n");
        sb.append("    languageDefault: ").append(this.toIndentedString(this.languageDefault)).append("\n");
        sb.append("    downloadShareDefaultExpirationPeriod: ").append(this.toIndentedString(this.downloadShareDefaultExpirationPeriod)).append("\n");
        sb.append("    uploadShareDefaultExpirationPeriod: ").append(this.toIndentedString(this.uploadShareDefaultExpirationPeriod)).append("\n");
        sb.append("    fileDefaultExpirationPeriod: ").append(this.toIndentedString(this.fileDefaultExpirationPeriod)).append("\n");
        sb.append("    nonmemberViewerDefault: ").append(this.toIndentedString(this.nonmemberViewerDefault)).append("\n");
        sb.append("    hideLoginInputFields: ").append(this.toIndentedString(this.hideLoginInputFields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

