/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.input.NullInputStream;
import org.nuxeo.onedrive.client.CopyOperation;
import org.nuxeo.onedrive.client.JsonObjectIterator;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveJsonRequest;
import org.nuxeo.onedrive.client.OneDriveJsonResponse;
import org.nuxeo.onedrive.client.OneDriveLongRunningAction;
import org.nuxeo.onedrive.client.OneDriveRequest;
import org.nuxeo.onedrive.client.OneDriveResponse;
import org.nuxeo.onedrive.client.OneDriveSharingLink;
import org.nuxeo.onedrive.client.PatchOperation;
import org.nuxeo.onedrive.client.QueryStringBuilder;
import org.nuxeo.onedrive.client.URLTemplate;
import org.nuxeo.onedrive.client.UploadSession;
import org.nuxeo.onedrive.client.types.DriveItem;
import org.nuxeo.onedrive.client.types.DriveItemVersion;
import org.nuxeo.onedrive.client.types.Permission;
import org.nuxeo.onedrive.client.types.User;

public final class Files {
    private static URL getChildrenUrl(DriveItem item) {
        return new URLTemplate(item.getAction("/children")).build(item.getApi().getBaseURL());
    }

    private static URL getChildrenUrl(DriveItem item, int limit) {
        QueryStringBuilder builder = new QueryStringBuilder().set("top", limit);
        return new URLTemplate(item.getAction("/children")).build(item.getApi().getBaseURL(), builder, new Object[0]);
    }

    private static URL getContentUrl(DriveItem item) {
        return new URLTemplate(item.getAction("/content")).build(item.getApi().getBaseURL());
    }

    private static URL getVersionsUrl(DriveItem item) {
        return new URLTemplate(item.getAction("/versions")).build(item.getApi().getBaseURL());
    }

    private static URL getUploadSessionUrl(DriveItem item) {
        return new URLTemplate(item.getAction("/createUploadSession")).build(item.getApi().getBaseURL());
    }

    private static URL getCheckInUrl(DriveItem item) {
        return new URLTemplate(item.getAction("/checkin")).build(item.getApi().getBaseURL());
    }

    private static URL getCheckOutUrl(DriveItem item) {
        return new URLTemplate(item.getAction("/checkout")).build(item.getApi().getBaseURL());
    }

    public static DriveItem.Metadata createFile(DriveItem parent, String filename, String mimeType) throws IOException {
        DriveItem item = new DriveItem(parent, filename);
        URL url = Files.getContentUrl(item);
        OneDriveRequest request = new OneDriveRequest(url, "PUT");
        request.addHeader("Content-Type", mimeType);
        OneDriveResponse response = (OneDriveResponse)request.sendRequest(parent.getApi().getExecutor(), (InputStream)new NullInputStream(0L));
        OneDriveJsonResponse jsonResponse = new OneDriveJsonResponse(response.getResponseCode(), response.getResponseMessage(), response.getLocation(), response.getContent());
        JsonObject jsonObject = jsonResponse.getContent();
        response.close();
        return DriveItem.parseJson(parent.getApi(), jsonObject);
    }

    public static DriveItem.Metadata createFolder(DriveItem parent, String foldername) throws IOException {
        URL url = Files.getChildrenUrl(parent);
        JsonObject rootObject = new JsonObject();
        rootObject.add("name", foldername);
        rootObject.add("folder", (JsonValue)new JsonObject());
        OneDriveJsonRequest request = new OneDriveJsonRequest(url, "POST", rootObject);
        OneDriveJsonResponse response = request.sendRequest(parent.getApi().getExecutor());
        JsonObject responseObject = response.getContent();
        response.close();
        return DriveItem.parseJson(parent.getApi(), responseObject);
    }

    public static List<DriveItemVersion> versions(DriveItem item) throws IOException {
        URL url = Files.getVersionsUrl(item);
        OneDriveJsonRequest request = new OneDriveJsonRequest(url, "GET");
        OneDriveJsonResponse response = request.sendRequest(item.getApi().getExecutor());
        ArrayList<DriveItemVersion> versions = new ArrayList<DriveItemVersion>();
        JsonObject body = response.getContent();
        JsonArray value = body.get("value").asArray();
        for (JsonValue version : value) {
            versions.add((DriveItemVersion)new DriveItemVersion().fromJson(version.asObject()));
        }
        return versions;
    }

    public static InputStream download(DriveItem item) throws IOException {
        URL url = Files.getContentUrl(item);
        OneDriveRequest request = new OneDriveRequest(url, "GET");
        OneDriveResponse response = (OneDriveResponse)request.sendRequest(item.getApi().getExecutor());
        return response.getContent();
    }

    public static InputStream download(DriveItem item, String range) throws IOException {
        URL url = Files.getContentUrl(item);
        OneDriveRequest request = new OneDriveRequest(url, "GET");
        request.addHeader("Range", String.format("bytes=%s", range));
        request.addHeader("Accept-Encoding", "identity");
        OneDriveResponse response = (OneDriveResponse)request.sendRequest(item.getApi().getExecutor());
        return response.getContent();
    }

    public static UploadSession createUploadSession(DriveItem item) throws IOException {
        URL url = Files.getUploadSessionUrl(item);
        OneDriveJsonRequest request = new OneDriveJsonRequest(url, "POST");
        try (OneDriveJsonResponse jsonResponse = (OneDriveJsonResponse)request.sendRequest(item.getApi().getExecutor(), (InputStream)new NullInputStream(0L));){
            UploadSession uploadSession = new UploadSession(item.getApi(), jsonResponse.getContent());
            return uploadSession;
        }
    }

    public static void delete(DriveItem item) throws IOException {
        ((OneDriveResponse)new OneDriveRequest(new URLTemplate(item.getPath()).build(item.getApi().getBaseURL()), "DELETE").sendRequest(item.getApi().getExecutor())).close();
    }

    public static void patch(DriveItem item, PatchOperation patch) throws IOException {
        new OneDriveJsonRequest(new URLTemplate(item.getPath()).build(item.getApi().getBaseURL()), "PATCH", patch.build()).sendRequest(item.getApi().getExecutor()).close();
    }

    public static void checkout(DriveItem item) throws IOException {
        ((OneDriveResponse)new OneDriveRequest(Files.getCheckOutUrl(item), "POST").sendRequest(item.getApi().getExecutor(), (InputStream)new NullInputStream(0L))).close();
    }

    public static void checkin(DriveItem item, String comment) throws IOException {
        if ((comment = Objects.requireNonNull(comment).trim()).isEmpty()) {
            throw new OneDriveAPIException("Comment must not be empty.");
        }
        JsonObject root = new JsonObject();
        root.add("comment", comment);
        new OneDriveJsonRequest(Files.getCheckInUrl(item), "POST", root).sendRequest(item.getApi().getExecutor()).close();
    }

    public static OneDriveLongRunningAction copy(DriveItem item, CopyOperation copy) throws IOException {
        OneDriveAPI api = item.getApi();
        URL url = new URLTemplate(item.getAction("/copy")).build(api.getBaseURL());
        OneDriveJsonResponse jsonResponse = new OneDriveJsonRequest(url, "POST", copy.build()).sendRequest(api.getExecutor());
        URL locationUrl = new URL(jsonResponse.getLocation());
        return new OneDriveLongRunningAction(locationUrl, api);
    }

    public static Iterator<DriveItem.Metadata> getFiles(DriveItem folder) {
        return new ItemIterator(folder.getApi(), Files.getChildrenUrl(folder));
    }

    public static Iterator<DriveItem.Metadata> getFiles(DriveItem folder, int limit) {
        return new ItemIterator(folder.getApi(), Files.getChildrenUrl(folder, limit));
    }

    public static Iterator<DriveItem.Metadata> search(DriveItem item, String search) {
        URL url = new URLTemplate(item.getAction("/search(q='%s')")).build(item.getApi().getBaseURL(), search);
        return new ItemIterator(item.getApi(), url);
    }

    public static Permission createSharedLink(DriveItem item, OneDriveSharingLink.Type type) throws IOException {
        URL url = new URLTemplate(item.getAction("/createLink")).build(item.getApi().getBaseURL());
        OneDriveJsonRequest request = new OneDriveJsonRequest(url, "POST", new JsonObject().add("type", type.getType()));
        OneDriveJsonResponse response = request.sendRequest(item.getApi().getExecutor());
        JsonObject json = response.getContent();
        return (Permission)new Permission().fromJson(json);
    }

    public static Iterator<DriveItem.Metadata> getSharedWithMe(User user) {
        return new ItemIterator(user.getApi(), new URLTemplate(user.getOperationPath("/drive/sharedWithMe")).build(user.getApi().getBaseURL()));
    }

    private static final class ItemIterator
    implements Iterator<DriveItem.Metadata> {
        private final OneDriveAPI api;
        private final JsonObjectIterator iterator;

        public ItemIterator(OneDriveAPI api, URL url) {
            this.api = api;
            this.iterator = new JsonObjectIterator(api, url);
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public DriveItem.Metadata next() {
            return DriveItem.parseJson(this.api, this.iterator.next());
        }
    }
}

