/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator;

import ch.cyberduck.core.cryptomator.CryptoAuthenticationException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.io.MemorySegementingOutputStream;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.random.NonceGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.io.output.ProxyOutputStream;
import org.cryptomator.cryptolib.api.CryptoException;
import org.cryptomator.cryptolib.api.FileContentCryptor;
import org.cryptomator.cryptolib.api.FileHeader;

public class CryptoOutputStream<Reply>
extends StatusOutputStream<Reply> {
    private final StatusOutputStream<Reply> proxy;

    public CryptoOutputStream(StatusOutputStream<Reply> proxy, FileContentCryptor cryptor, FileHeader header, NonceGenerator nonces, long chunkIndexOffset) {
        super((OutputStream)new MemorySegementingOutputStream((OutputStream)((Object)new EncryptingOutputStream((OutputStream)proxy, cryptor, header, nonces, chunkIndexOffset)), Integer.valueOf(cryptor.cleartextChunkSize())));
        this.proxy = proxy;
    }

    public void write(int b) throws IOException {
        throw new IOException(new UnsupportedOperationException());
    }

    public Reply getStatus() throws BackgroundException {
        return (Reply)this.proxy.getStatus();
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    private static final class EncryptingOutputStream
    extends ProxyOutputStream {
        private final FileContentCryptor cryptor;
        private final FileHeader header;
        private final int chunksize;
        private final NonceGenerator nonces;
        private long chunkIndexOffset;

        public EncryptingOutputStream(OutputStream proxy, FileContentCryptor cryptor, FileHeader header, NonceGenerator nonces, long chunkIndexOffset) {
            super(proxy);
            this.cryptor = cryptor;
            this.header = header;
            this.chunksize = cryptor.cleartextChunkSize();
            this.nonces = nonces;
            this.chunkIndexOffset = chunkIndexOffset;
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            try {
                for (int chunkOffset = off; chunkOffset < len; chunkOffset += this.chunksize) {
                    int chunkLen = Math.min(this.chunksize, len - chunkOffset);
                    ByteBuffer encryptedChunk = this.cryptor.encryptChunk(ByteBuffer.wrap(Arrays.copyOfRange(b, chunkOffset, chunkOffset + chunkLen)), this.chunkIndexOffset++, this.header, this.nonces.next());
                    super.write(encryptedChunk.array());
                }
            }
            catch (CryptoException e) {
                throw new IOException(e.getMessage(), (Throwable)((Object)new CryptoAuthenticationException(e.getMessage(), e)));
            }
        }
    }
}

