/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.local;

import ch.cyberduck.binding.application.NSWorkspace;
import ch.cyberduck.binding.foundation.NSDate;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSFileManager;
import ch.cyberduck.binding.foundation.NSNumber;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.binding.foundation.NSURL;
import ch.cyberduck.core.LocalAttributes;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.exception.LocalNotfoundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.local.FinderLocal;
import org.apache.log4j.Logger;
import org.rococoa.ObjCObject;
import org.rococoa.ObjCObjectByReference;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSError;

public class FinderLocalAttributes
extends LocalAttributes {
    private static final Logger log = Logger.getLogger(FinderLocalAttributes.class);
    private final FinderLocal local;

    public FinderLocalAttributes(FinderLocal local) {
        super(local.getAbsolute());
        this.local = local;
    }

    private NSDictionary getNativeAttributes() throws AccessDeniedException, NotfoundException {
        if (!this.local.exists()) {
            throw new LocalNotfoundException(this.local.getAbsolute());
        }
        ObjCObjectByReference error = new ObjCObjectByReference();
        NSDictionary dict = NSFileManager.defaultManager().attributesOfItemAtPath_error(this.local.getAbsolute(), error);
        if (null == dict) {
            NSError f = (NSError)error.getValueAs(NSError.class);
            if (null == f) {
                throw new LocalAccessDeniedException(this.local.getAbsolute());
            }
            throw new LocalAccessDeniedException(String.format("%s", f.localizedDescription()));
        }
        return dict;
    }

    private NSObject getNativeAttribute(String name) throws AccessDeniedException, NotfoundException {
        NSDictionary dict = this.getNativeAttributes();
        return dict.objectForKey(name);
    }

    public long getCreationDate() {
        try {
            NSObject object = this.getNativeAttribute("NSFileCreationDate");
            if (object.isKindOfClass(Rococoa.createClass((String)"NSDate", NSDate._Class.class))) {
                return (long)(((NSDate)Rococoa.cast((ObjCObject)object, NSDate.class)).timeIntervalSince1970() * 1000.0);
            }
            return -1L;
        }
        catch (AccessDeniedException | NotfoundException e) {
            return -1L;
        }
    }

    public String getOwner() {
        try {
            NSObject object = this.getNativeAttribute("NSFileOwnerAccountName");
            return object.toString();
        }
        catch (AccessDeniedException | NotfoundException e) {
            return null;
        }
    }

    public String getGroup() {
        try {
            NSObject object = this.getNativeAttribute("NSFileGroupOwnerAccountName");
            return object.toString();
        }
        catch (AccessDeniedException | NotfoundException e) {
            return null;
        }
    }

    public Permission getPermission() {
        return new FinderLocalPermission(super.getPermission().getMode());
    }

    public Long getInode() {
        try {
            NSObject object = this.getNativeAttribute("NSFileSystemFileNumber");
            if (object.isKindOfClass(Rococoa.createClass((String)"NSNumber", NSNumber._Class.class))) {
                NSNumber number = (NSNumber)Rococoa.cast((ObjCObject)object, NSNumber.class);
                return number.longValue();
            }
            return null;
        }
        catch (AccessDeniedException | NotfoundException e) {
            return null;
        }
    }

    public boolean isBundle() {
        return NSWorkspace.sharedWorkspace().isFilePackageAtPath(this.local.getAbsolute());
    }

    private final class FinderLocalPermission
    extends LocalAttributes.LocalPermission {
        private FinderLocalPermission() {
            super((LocalAttributes)FinderLocalAttributes.this);
        }

        private FinderLocalPermission(String mode) {
            super((LocalAttributes)FinderLocalAttributes.this, mode);
        }

        private FinderLocalPermission(int mode) {
            super((LocalAttributes)FinderLocalAttributes.this, mode);
        }

        public boolean isExecutable() {
            NSURL resolved;
            try {
                resolved = FinderLocalAttributes.this.local.lock(false);
                if (null == resolved) {
                    return super.isExecutable();
                }
            }
            catch (AccessDeniedException e) {
                return super.isExecutable();
            }
            try {
                boolean bl = NSFileManager.defaultManager().isExecutableFileAtPath(resolved.path());
                return bl;
            }
            finally {
                FinderLocalAttributes.this.local.release(resolved);
            }
        }

        public boolean isReadable() {
            NSURL resolved;
            try {
                resolved = FinderLocalAttributes.this.local.lock(false);
                if (null == resolved) {
                    return super.isReadable();
                }
            }
            catch (AccessDeniedException e) {
                return super.isReadable();
            }
            try {
                boolean bl = NSFileManager.defaultManager().isReadableFileAtPath(resolved.path());
                return bl;
            }
            finally {
                FinderLocalAttributes.this.local.release(resolved);
            }
        }

        public boolean isWritable() {
            NSURL resolved;
            try {
                resolved = FinderLocalAttributes.this.local.lock(false);
                if (null == resolved) {
                    return super.isWritable();
                }
            }
            catch (AccessDeniedException e) {
                return super.isWritable();
            }
            try {
                boolean bl = NSFileManager.defaultManager().isWritableFileAtPath(resolved.path());
                return bl;
            }
            finally {
                FinderLocalAttributes.this.local.release(resolved);
            }
        }
    }
}

