/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.binding;

import ch.cyberduck.binding.BundleController;
import ch.cyberduck.binding.application.NSColor;
import ch.cyberduck.binding.application.NSFont;
import ch.cyberduck.binding.foundation.NSAttributedString;
import ch.cyberduck.binding.foundation.NSMutableAttributedString;
import ch.cyberduck.binding.foundation.NSNumber;
import ch.cyberduck.binding.foundation.NSRange;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.Local;
import org.rococoa.cocoa.foundation.NSUInteger;

public final class HyperlinkAttributedStringFactory {
    private HyperlinkAttributedStringFactory() {
    }

    public static NSAttributedString create(DescriptiveUrl url) {
        if (url.equals((Object)DescriptiveUrl.EMPTY)) {
            return NSAttributedString.attributedString("");
        }
        return HyperlinkAttributedStringFactory.create(url.getUrl());
    }

    public static NSAttributedString create(String url) {
        if (null == url) {
            return NSAttributedString.attributedString("");
        }
        return HyperlinkAttributedStringFactory.create(url, url);
    }

    public static NSAttributedString create(String title, Local file) {
        if (null == file) {
            return NSAttributedString.attributedString(title);
        }
        return HyperlinkAttributedStringFactory.create(NSMutableAttributedString.create(title, BundleController.TRUNCATE_MIDDLE_ATTRIBUTES), String.format("file://%s", file.getAbsolute()));
    }

    public static NSAttributedString create(String title, String url) {
        if (null == url) {
            return NSAttributedString.attributedString(title);
        }
        return HyperlinkAttributedStringFactory.create(NSMutableAttributedString.create(title, BundleController.TRUNCATE_MIDDLE_ATTRIBUTES), url);
    }

    private static NSAttributedString create(NSMutableAttributedString value, String hyperlink) {
        NSRange range = NSRange.NSMakeRange(new NSUInteger(0L), value.length());
        value.beginEditing();
        value.addAttributeInRange("NSLink", hyperlink, range);
        value.addAttributeInRange("NSColor", NSColor.blueColor(), range);
        value.addAttributeInRange("NSFont", NSFont.systemFontOfSize(NSFont.smallSystemFontSize()), range);
        value.addAttributeInRange("NSUnderline", NSNumber.numberWithInt(1), range);
        value.endEditing();
        return value;
    }
}

