/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.spectra;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.spectra.SpectraClientBuilder;
import ch.cyberduck.core.spectra.SpectraExceptionMappingService;
import ch.cyberduck.core.spectra.SpectraSession;
import com.spectralogic.ds3client.Ds3Client;
import com.spectralogic.ds3client.commands.HeadBucketRequest;
import com.spectralogic.ds3client.commands.HeadBucketResponse;
import com.spectralogic.ds3client.commands.HeadObjectRequest;
import com.spectralogic.ds3client.commands.HeadObjectResponse;
import com.spectralogic.ds3client.networking.FailedRequestException;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.jets3t.service.impl.rest.httpclient.RestStorageService;

public class SpectraFindFeature
implements Find {
    private static final Logger log = Logger.getLogger(SpectraFindFeature.class);
    private final SpectraSession session;
    private final PathContainerService containerService = new S3PathContainerService();

    public SpectraFindFeature(SpectraSession session) {
        this.session = session;
    }

    public boolean find(Path file) throws BackgroundException {
        if (file.isRoot()) {
            return true;
        }
        try {
            Ds3Client client = new SpectraClientBuilder().wrap((RestStorageService)this.session.getClient(), this.session.getHost());
            if (this.containerService.isContainer(file)) {
                HeadBucketResponse response = client.headBucket(new HeadBucketRequest(this.containerService.getContainer(file).getName()));
                switch (response.getStatus()) {
                    case DOESNTEXIST: {
                        return false;
                    }
                }
                return true;
            }
            HeadObjectResponse response = client.headObject(new HeadObjectRequest(this.containerService.getContainer(file).getName(), this.containerService.getKey(file)));
            switch (response.getStatus()) {
                case DOESNTEXIST: {
                    return false;
                }
            }
            return true;
        }
        catch (FailedRequestException e) {
            throw new SpectraExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Failure to read attributes of {0}", (Throwable)e, file);
        }
    }
}

