/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.io;

import ch.cyberduck.core.io.BandwidthThrottle;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ProxyOutputStream;

public class ThrottledOutputStream
extends ProxyOutputStream {
    private final OutputStream delegate;
    private final BandwidthThrottle throttle;

    public ThrottledOutputStream(OutputStream delegate, BandwidthThrottle throttle) {
        super(delegate);
        this.delegate = delegate;
        this.throttle = throttle;
    }

    public void write(int b) throws IOException {
        this.throttle.request(1);
        this.delegate.write(b);
    }

    public void write(byte[] data, int offset, int totalLength) throws IOException {
        while (totalLength > 0) {
            int length = this.throttle.request(totalLength);
            this.delegate.write(data, offset, length);
            totalLength -= length;
            offset += length;
        }
    }
}

