/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.hubic;

import ch.iterate.openstack.swift.AuthenticationResponse;
import ch.iterate.openstack.swift.Response;
import ch.iterate.openstack.swift.exception.AuthorizationException;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.model.Region;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.entity.ContentType;
import org.apache.http.protocol.HTTP;

public class HubicAuthenticationResponseHandler
implements ResponseHandler<AuthenticationResponse> {
    public AuthenticationResponse handleResponse(HttpResponse response) throws IOException {
        if (response.getStatusLine().getStatusCode() == 200) {
            Charset charset = HTTP.DEF_CONTENT_CHARSET;
            ContentType contentType = ContentType.get((HttpEntity)response.getEntity());
            if (contentType != null && contentType.getCharset() != null) {
                charset = contentType.getCharset();
            }
            try {
                JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(response.getEntity().getContent(), charset)).getAsJsonObject();
                String token = json.getAsJsonPrimitive("token").getAsString();
                String endpoint = json.getAsJsonPrimitive("endpoint").getAsString();
                return new AuthenticationResponse(response, token, Collections.singleton(new Region(null, URI.create(endpoint), null, true)));
            }
            catch (JsonParseException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        if (response.getStatusLine().getStatusCode() == 401 || response.getStatusLine().getStatusCode() == 403) {
            throw new AuthorizationException(new Response(response));
        }
        throw new GenericException(new Response(response));
    }
}

