/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.dropbox.DropboxDeleteFeature;
import ch.cyberduck.core.dropbox.DropboxExceptionMappingService;
import ch.cyberduck.core.dropbox.DropboxPathContainerService;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.transfer.TransferStatus;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.files.DbxUserFilesRequests;
import java.util.Collections;

public class DropboxCopyFeature
implements Copy {
    private final DropboxSession session;
    private final PathContainerService containerService = new DropboxPathContainerService();

    public DropboxCopyFeature(DropboxSession session) {
        this.session = session;
    }

    public Path copy(Path source, Path target, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            if (status.isExists()) {
                new DropboxDeleteFeature(this.session).delete(Collections.singletonMap(target, status), (PasswordCallback)callback, (Delete.Callback)new Delete.DisabledCallback());
            }
            new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient(source)).copyV2(this.containerService.getKey(source), this.containerService.getKey(target));
            return target;
        }
        catch (DbxException e) {
            throw new DropboxExceptionMappingService().map("Cannot copy {0}", e, source);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }
}

