/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.s3.S3AttributesFinderFeature;
import ch.cyberduck.core.s3.S3Session;
import org.apache.commons.lang3.StringUtils;

public class S3VersionIdProvider
implements IdProvider {
    private final S3Session session;

    public S3VersionIdProvider(S3Session session) {
        this.session = session;
    }

    public String getFileid(Path file, ListProgressListener listener) throws BackgroundException {
        if (StringUtils.isNotBlank((CharSequence)file.attributes().getVersionId())) {
            return file.attributes().getVersionId();
        }
        if (file.isRoot()) {
            return null;
        }
        return new S3AttributesFinderFeature(this.session).find(file).getVersionId();
    }

    public IdProvider withCache(Cache<Path> cache) {
        return this;
    }
}

