/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate.io.swagger.client.model;

import ch.cyberduck.core.storegate.io.swagger.client.model.MediaItem;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.joda.time.DateTime;

@ApiModel(description="A media folder (or album).")
public class MediaFolder {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="isShared")
    private Boolean isShared = null;
    @JsonProperty(value="created")
    private DateTime created = null;
    @JsonProperty(value="modified")
    private DateTime modified = null;
    @JsonProperty(value="mediaItem")
    private MediaItem mediaItem = null;

    public MediaFolder id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The folder id.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public MediaFolder name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The folder name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MediaFolder description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The folder description.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public MediaFolder isShared(Boolean isShared) {
        this.isShared = isShared;
        return this;
    }

    @ApiModelProperty(value="Indicates if the folder is shared.")
    public Boolean isIsShared() {
        return this.isShared;
    }

    public void setIsShared(Boolean isShared) {
        this.isShared = isShared;
    }

    public MediaFolder created(DateTime created) {
        this.created = created;
        return this;
    }

    @ApiModelProperty(value="When the media folder was created.")
    public DateTime getCreated() {
        return this.created;
    }

    public void setCreated(DateTime created) {
        this.created = created;
    }

    public MediaFolder modified(DateTime modified) {
        this.modified = modified;
        return this;
    }

    @ApiModelProperty(value="When the media folder last was modified.")
    public DateTime getModified() {
        return this.modified;
    }

    public void setModified(DateTime modified) {
        this.modified = modified;
    }

    public MediaFolder mediaItem(MediaItem mediaItem) {
        this.mediaItem = mediaItem;
        return this;
    }

    @ApiModelProperty(value="One image to represent the album")
    public MediaItem getMediaItem() {
        return this.mediaItem;
    }

    public void setMediaItem(MediaItem mediaItem) {
        this.mediaItem = mediaItem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaFolder mediaFolder = (MediaFolder)o;
        return Objects.equals(this.id, mediaFolder.id) && Objects.equals(this.name, mediaFolder.name) && Objects.equals(this.description, mediaFolder.description) && Objects.equals(this.isShared, mediaFolder.isShared) && Objects.equals(this.created, mediaFolder.created) && Objects.equals(this.modified, mediaFolder.modified) && Objects.equals(this.mediaItem, mediaFolder.mediaItem);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.isShared, this.created, this.modified, this.mediaItem);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MediaFolder {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isShared: ").append(this.toIndentedString(this.isShared)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    modified: ").append(this.toIndentedString(this.modified)).append("\n");
        sb.append("    mediaItem: ").append(this.toIndentedString(this.mediaItem)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

