/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.transfer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.irods.jargon.core.connection.ConnectionProgressStatus;
import org.irods.jargon.core.connection.ConnectionProgressStatusListener;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.NoResourceDefinedException;
import org.irods.jargon.core.packinstr.DataObjInp;
import org.irods.jargon.core.pub.DefaultIntraFileProgressCallbackListener;
import org.irods.jargon.core.pub.IRODSAccessObjectFactory;
import org.irods.jargon.core.pub.io.FileIOOperations;
import org.irods.jargon.core.pub.io.IRODSRandomAccessFile;
import org.irods.jargon.core.transfer.AbstractRestartManager;
import org.irods.jargon.core.transfer.AbstractTransferRestartProcessor;
import org.irods.jargon.core.transfer.FileRestartDataSegment;
import org.irods.jargon.core.transfer.FileRestartInfo;
import org.irods.jargon.core.transfer.FileRestartManagementException;
import org.irods.jargon.core.transfer.RestartFailedException;
import org.irods.jargon.core.transfer.TransferControlBlock;
import org.irods.jargon.core.transfer.TransferStatus;
import org.irods.jargon.core.transfer.TransferStatusCallbackListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutTransferRestartProcessor
extends AbstractTransferRestartProcessor {
    private static Logger log = LoggerFactory.getLogger(PutTransferRestartProcessor.class);

    public PutTransferRestartProcessor(IRODSAccessObjectFactory irodsAccessObjectFactory, IRODSAccount irodsAccount, AbstractRestartManager restartManager, TransferStatusCallbackListener transferStatusCallbackListener, TransferControlBlock transferControlBlock) {
        super(irodsAccessObjectFactory, irodsAccount, restartManager, transferStatusCallbackListener, transferControlBlock);
    }

    @Override
    public void restartIfNecessary(String irodsAbsolutePath) throws RestartFailedException, FileRestartManagementException, JargonException {
        log.info("restartIfNecessary()");
        FileRestartInfo fileRestartInfo = this.retrieveRestartIfConfiguredOrNull(irodsAbsolutePath, FileRestartInfo.RestartType.PUT);
        if (fileRestartInfo == null) {
            log.info("no restart");
            return;
        }
        this.processRestart(irodsAbsolutePath, fileRestartInfo);
    }

    private void processRestart(String irodsAbsolutePath, FileRestartInfo fileRestartInfo) throws RestartFailedException, FileRestartManagementException, JargonException {
        IRODSRandomAccessFile irodsRandomAccessFile;
        try {
            irodsRandomAccessFile = this.getIrodsAccessObjectFactory().getIRODSFileFactory(this.getIrodsAccount()).instanceIRODSRandomAccessFile(irodsAbsolutePath, DataObjInp.OpenFlags.READ_WRITE_CREATE_IF_NOT_EXISTS);
            irodsRandomAccessFile.seek(0L, FileIOOperations.SeekWhenceType.SEEK_START);
        }
        catch (NoResourceDefinedException e1) {
            log.error("no resource defined", (Throwable)e1);
            throw new RestartFailedException("cannot get irodsRandomAccessFile", e1);
        }
        catch (JargonException e1) {
            log.error("general jargon error getting irods random file", (Throwable)e1);
            throw e1;
        }
        catch (IOException e) {
            log.error("io exception getting irods random file", (Throwable)e);
            throw new JargonException("cannot get irodsRandomAccessFile", e);
        }
        RandomAccessFile localFile = null;
        try {
            long gap;
            int i;
            localFile = this.localFileAsFileAndCheckExists(fileRestartInfo, AbstractTransferRestartProcessor.OpenType.READ);
            ConnectionProgressStatusListener intraFileStatusListener = null;
            if (this.getTransferStatusCallbackListener() != null && this.getTransferControlBlock().getTransferOptions().isIntraFileStatusCallbacks()) {
                intraFileStatusListener = DefaultIntraFileProgressCallbackListener.instanceSettingTransferOptions(TransferStatus.TransferType.PUT, localFile.length(), this.getTransferControlBlock(), this.getTransferStatusCallbackListener(), this.getTransferControlBlock().getTransferOptions());
            }
            byte[] buffer = new byte[this.getIrodsAccessObjectFactory().getJargonProperties().getPutBufferSize()];
            long currentOffset = 0L;
            FileRestartDataSegment segment = null;
            for (i = 0; i < fileRestartInfo.getFileRestartDataSegments().size() && !this.getTransferControlBlock().isCancelled(); ++i) {
                segment = fileRestartInfo.getFileRestartDataSegments().get(i);
                log.info("process segment:{}", (Object)segment);
                gap = segment.getOffset() - currentOffset;
                log.debug("gap:{}", (Object)gap);
                if (gap < 0L) {
                    log.warn("my segment has a gap < 0..continuing:{}", (Object)segment);
                } else if (gap > 0L) {
                    this.putSegment(gap, localFile, buffer, fileRestartInfo, i - 1, irodsRandomAccessFile, intraFileStatusListener);
                    currentOffset += gap;
                }
                if (segment.getLength() <= 0L) continue;
                log.info("currentOffset after putSegment:{}", (Object)(currentOffset += segment.getLength()));
                localFile.seek(currentOffset);
                irodsRandomAccessFile.seek(currentOffset, FileIOOperations.SeekWhenceType.SEEK_START);
            }
            log.info("computing gap for last segment");
            log.info("local file length:{}", (Object)localFile.length());
            log.info("current offset:{}", (Object)currentOffset);
            gap = localFile.length() - currentOffset;
            log.info("last segment gap:{}", (Object)gap);
            if (gap > 0L) {
                log.info("writing last segment based on file length");
                i = fileRestartInfo.getFileRestartDataSegments().size() - 1;
                this.putSegment(gap, localFile, buffer, fileRestartInfo, i, irodsRandomAccessFile, intraFileStatusListener);
            }
            log.info("restart completed..remove from the cache");
            this.getRestartManager().deleteRestart(fileRestartInfo.identifierFromThisInfo());
            log.info("removed restart");
        }
        catch (FileNotFoundException e) {
            log.error("file not found exception with localFile:{}", (Object)localFile, (Object)e);
            throw new RestartFailedException(e);
        }
        catch (JargonException e) {
            log.error("general jargon error getting irods random file", (Throwable)e);
            throw new RestartFailedException("cannot get local file", e);
        }
        catch (IOException e) {
            log.error("end of file exception with localFile:{}", (Object)localFile, (Object)e);
            throw new RestartFailedException(e);
        }
        finally {
            try {
                irodsRandomAccessFile.close();
            }
            catch (IOException e) {
                log.error("error closing irods random access file during restart", (Throwable)e);
                throw new RestartFailedException("exception closing irods restart file", e);
            }
            try {
                if (localFile != null) {
                    localFile.close();
                }
            }
            catch (IOException e) {
                log.warn("error closing local file, logged and ignored", (Throwable)e);
            }
        }
    }

    private void putSegment(long gap, RandomAccessFile localFile, byte[] buffer, FileRestartInfo fileRestartInfo, int indexOfSegmentToUpdateLength, IRODSRandomAccessFile irodsRandomAccessFile, ConnectionProgressStatusListener intraFileStatusListener) throws RestartFailedException, FileRestartManagementException {
        long myGap = gap;
        long writtenSinceUpdated = 0L;
        int toRead = 0;
        long totalWrittenOverall = 0L;
        while (myGap > 0L) {
            if (this.getTransferControlBlock().isCancelled()) {
                return;
            }
            toRead = myGap > (long)buffer.length ? buffer.length : (int)myGap;
            log.debug("toRead:{}", (Object)toRead);
            log.info("reading buffer from input file...");
            try {
                int amountRead = localFile.read(buffer, 0, toRead);
                log.debug("amountRead:{}", (Object)amountRead);
                if (amountRead <= 0) {
                    log.error("read 0 or less from localFile:{}", (Object)amountRead);
                    throw new RestartFailedException("restart failed in read of local file");
                }
                irodsRandomAccessFile.write(buffer, 0, amountRead);
                myGap -= (long)amountRead;
                totalWrittenOverall += (long)amountRead;
                if ((writtenSinceUpdated += (long)amountRead) < 0x2000000L) continue;
                log.info("need to update restart");
                this.getRestartManager().updateLengthForSegment(fileRestartInfo.identifierFromThisInfo(), indexOfSegmentToUpdateLength, writtenSinceUpdated);
                writtenSinceUpdated = 0L;
            }
            catch (IOException e) {
                log.error("IOException reading local file", (Throwable)e);
                throw new RestartFailedException("IO Exception reading local file", e);
            }
        }
        if (myGap != 0L) {
            log.error("final gap should be exactly zero, something is out of balance!");
            throw new RestartFailedException("control balance error in putSeq, myGap should be zero at end");
        }
        if (totalWrittenOverall != gap) {
            log.error("total written does not equal the gap I originally had, something is out of balance!");
            throw new RestartFailedException("control balance error in putSeq, total written does not equal gap");
        }
        if (log.isDebugEnabled()) {
            log.debug("verifying pointers at end");
            try {
                long irodsPointer = irodsRandomAccessFile.getFilePointer();
                long localPointer = localFile.getFilePointer();
                if (irodsPointer != localPointer) {
                    log.error("pointers out of synch!");
                    log.error("local:{}", (Object)localPointer);
                    log.error("irods:{}", (Object)irodsPointer);
                    throw new RestartFailedException("pointers do not match after putseg!");
                }
                log.debug("pointers verified at:{} after putSeg", (Object)localPointer);
            }
            catch (IOException e) {
                log.error("exception obtaining current pointers for local and iRODS");
                throw new RestartFailedException("unable to obtain current pointers for local and iRODS", e);
            }
        }
        if (intraFileStatusListener != null) {
            ConnectionProgressStatus connectionProgressStatus = ConnectionProgressStatus.instanceForSend(fileRestartInfo.estimateLengthSoFar());
            intraFileStatusListener.connectionProgressStatusCallback(connectionProgressStatus);
        }
        if (writtenSinceUpdated > 0L) {
            log.info("need to update restart");
            this.getRestartManager().updateLengthForSegment(fileRestartInfo.identifierFromThisInfo(), indexOfSegmentToUpdateLength, writtenSinceUpdated);
            writtenSinceUpdated = 0L;
        }
    }
}

