/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.query;

import java.util.Date;
import java.util.List;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.utils.IRODSDataConversionUtil;

public class IRODSQueryResultRow {
    private final List<String> queryResultColumns;
    private final int recordCount;
    private final boolean lastResult;
    private final List<String> columnNames;

    public static IRODSQueryResultRow instance(List<String> queryResultColumns, List<String> columnNames) throws JargonException {
        return new IRODSQueryResultRow(queryResultColumns, columnNames, 0, false);
    }

    public static IRODSQueryResultRow instance(List<String> queryResultColumns, List<String> columnNames, int recordCount, boolean lastResult) throws JargonException {
        return new IRODSQueryResultRow(queryResultColumns, columnNames, recordCount, lastResult);
    }

    public static IRODSQueryResultRow instance(List<String> queryResultColumns, List<String> columnNames, int recordCount, boolean lastResult, int totalRecords) throws JargonException {
        return new IRODSQueryResultRow(queryResultColumns, columnNames, recordCount, lastResult);
    }

    private IRODSQueryResultRow(List<String> queryResultColumns, List<String> columnNames, int recordCount, boolean lastResult) throws JargonException {
        if (queryResultColumns == null) {
            throw new JargonException("queryResultColumns is null");
        }
        if (columnNames == null) {
            throw new JargonException("columnNames is null");
        }
        this.queryResultColumns = queryResultColumns;
        this.lastResult = lastResult;
        this.recordCount = recordCount;
        this.columnNames = columnNames;
    }

    public String getColumn(int columnNumber) throws JargonException {
        if (columnNumber < 0 || columnNumber >= this.queryResultColumns.size()) {
            throw new JargonException("column out of range");
        }
        return this.queryResultColumns.get(columnNumber);
    }

    public String getColumn(String columnName) throws JargonException {
        if (columnName == null || columnName.length() == 0) {
            throw new JargonException("columnName is null or empty");
        }
        int idx = this.getColumnNamePosition(columnName);
        if (idx == -1) {
            throw new JargonException("column name not found in result set:" + columnName);
        }
        return this.queryResultColumns.get(idx);
    }

    public Date getColumnAsDateOrNull(int column) throws JargonException {
        return IRODSDataConversionUtil.getDateFromIRODSValue(this.getColumn(column));
    }

    public Date getColumnAsDateOrNull(String columnName) throws JargonException {
        return IRODSDataConversionUtil.getDateFromIRODSValue(this.getColumn(this.getColumnNamePosition(columnName)));
    }

    public int getColumnAsIntOrZero(int column) throws JargonException {
        return IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(this.getColumn(column));
    }

    public int getColumnAsIntOrZero(String columnName) throws JargonException {
        return IRODSDataConversionUtil.getIntOrZeroFromIRODSValue(this.getColumn(this.getColumnNamePosition(columnName)));
    }

    public long getColumnAsLongOrZero(int column) throws JargonException {
        return IRODSDataConversionUtil.getLongOrZeroFromIRODSValue(this.getColumn(column));
    }

    public long getColumnAsLongOrZero(String columnName) throws JargonException {
        return IRODSDataConversionUtil.getLongOrZeroFromIRODSValue(this.getColumn(this.getColumnNamePosition(columnName)));
    }

    protected int getColumnNamePosition(String columnName) {
        int colPos = -1;
        int i = 0;
        for (String colNameInList : this.columnNames) {
            if (columnName.equals(colNameInList)) {
                colPos = i;
                break;
            }
            ++i;
        }
        return colPos;
    }

    public List<String> getColumnsAsList() {
        return this.queryResultColumns;
    }

    public List<String> getQueryResultColumns() {
        return this.queryResultColumns;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public boolean isLastResult() {
        return this.lastResult;
    }

    public String toString() {
        int maxLen = 100;
        StringBuilder builder = new StringBuilder();
        builder.append("IRODSQueryResultRow [");
        if (this.queryResultColumns != null) {
            builder.append("queryResultColumns=").append(this.queryResultColumns.subList(0, Math.min(this.queryResultColumns.size(), 100))).append(", ");
        }
        builder.append("recordCount=").append(this.recordCount).append(", lastResult=").append(this.lastResult).append(", ");
        if (this.columnNames != null) {
            builder.append("columnNames=").append(this.columnNames.subList(0, Math.min(this.columnNames.size(), 100)));
        }
        builder.append("]");
        return builder.toString();
    }
}

