/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.irods.jargon.core.connection.AbstractIRODSMidLevelProtocol;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSBasicTCPConnection;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.JargonRuntimeException;
import org.irods.jargon.core.packinstr.SSLStartInp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SslConnectionUtilities {
    private final IRODSSession irodsSession;
    private Logger log = LoggerFactory.getLogger(SslConnectionUtilities.class);

    SslConnectionUtilities(IRODSSession irodsSession) {
        this.irodsSession = irodsSession;
    }

    SSLSocket createSslSocketForProtocol(IRODSAccount irodsAccount, AbstractIRODSMidLevelProtocol irodsCommands, boolean doSslStartupSequence) throws JargonException, AssertionError {
        SSLContext ctx;
        if (doSslStartupSequence) {
            this.log.info("startSSL for PAM auth");
            SSLStartInp sslStartInp = SSLStartInp.instance();
            irodsCommands.irodsFunction(sslStartInp);
        }
        try {
            ctx = SSLContext.getInstance("TLSv1.2", "SunJSSE");
        }
        catch (NoSuchAlgorithmException e) {
            try {
                ctx = SSLContext.getInstance("TLSv1", "SunJSSE");
            }
            catch (NoSuchAlgorithmException e1) {
                throw new AssertionError((Object)e1);
            }
            catch (NoSuchProviderException e1) {
                throw new AssertionError((Object)e1);
            }
        }
        catch (NoSuchProviderException e) {
            throw new AssertionError((Object)e);
        }
        TrustManager[] trustManagers = null;
        if (irodsCommands.getIrodsSession().getX509TrustManager() != null) {
            trustManagers = new TrustManager[]{irodsCommands.getIrodsSession().getX509TrustManager()};
        }
        try {
            ctx.init(null, trustManagers, null);
        }
        catch (KeyManagementException e1) {
            this.log.error("error initializing ssl context:{}", (Throwable)e1);
            throw new JargonRuntimeException("ssl context init exception", e1);
        }
        this.log.debug("getting ssl socket factory");
        SSLSocketFactory sslSocketFactory = ctx.getSocketFactory();
        this.log.debug("supported cyphers:{}", (Object[])sslSocketFactory.getSupportedCipherSuites());
        SSLSocket sslSocket = null;
        try {
            sslSocket = (SSLSocket)sslSocketFactory.createSocket(irodsCommands.getIrodsConnection().getConnection(), irodsAccount.getHost(), irodsAccount.getPort(), false);
            this.log.debug("ssl socket created for credential exchage..now connect");
            SSLParameters params = ctx.getDefaultSSLParameters();
            ArrayList<String> protocols = new ArrayList<String>(Arrays.asList(params.getProtocols()));
            protocols.remove("SSLv2Hello");
            params.setProtocols(protocols.toArray(new String[protocols.size()]));
            ArrayList<String> ciphers = new ArrayList<String>(Arrays.asList(params.getCipherSuites()));
            ciphers.retainAll(Arrays.asList("TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_RC4_128_SHA1", "SSL_RSA_WITH_RC4_128_MD5", "TLS_EMPTY_RENEGOTIATION_INFO_SCSV"));
            params.setCipherSuites(ciphers.toArray(new String[ciphers.size()]));
            this.log.debug("supported protocols:{}", (Object[])sslSocket.getSupportedProtocols());
        }
        catch (IOException e) {
            this.log.error("ioException creating socket", (Throwable)e);
            throw new JargonException("unable to create the underlying ssl socket", e);
        }
        if (this.log.isDebugEnabled()) {
            sslSocket.addHandshakeCompletedListener(new HandshakeCompletedListener(){

                @Override
                public void handshakeCompleted(HandshakeCompletedEvent event) {
                    SslConnectionUtilities.this.log.debug("Handshake finished!");
                    SslConnectionUtilities.this.log.debug("\t CipherSuite:{}", (Object)event.getCipherSuite());
                    SslConnectionUtilities.this.log.debug("\t SessionId {}", (Object)event.getSession());
                    SslConnectionUtilities.this.log.debug("\t PeerHost {}", (Object)event.getSession().getPeerHost());
                }
            });
        }
        this.log.debug("starting SSL handshake");
        try {
            sslSocket.setUseClientMode(true);
            sslSocket.startHandshake();
        }
        catch (IOException e) {
            this.log.error("ssl exception in handshake", (Throwable)e);
            throw new JargonException("unable to start SSL socket", e);
        }
        this.log.debug("ssl handshake successful");
        return sslSocket;
    }

    void createSslSocketForProtocolAndIntegrateIntoProtocol(IRODSAccount irodsAccount, AbstractIRODSMidLevelProtocol irodsCommands, boolean doSslStartupSequence) throws JargonException, AssertionError {
        this.log.info("createSslSocketForProtocolAndIntegrateIntoProtocol()");
        SSLSocket sslSocket = this.createSslSocketForProtocol(irodsAccount, irodsCommands, doSslStartupSequence);
        this.log.info("have SSL socket, introduce as the iRODS connection in the provided protocol");
        irodsCommands.setIrodsConnection(new IRODSBasicTCPConnection(irodsCommands.getIrodsAccount(), irodsCommands.getPipelineConfiguration(), irodsCommands.getIrodsProtocolManager(), sslSocket, irodsCommands.getIrodsSession()));
    }
}

