/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify;

import cc.mallet.classify.MaxEnt;
import cc.mallet.classify.MaxEntTrainer;
import cc.mallet.optimize.Optimizer;
import cc.mallet.optimize.OrthantWiseLimitedMemoryBFGS;
import cc.mallet.types.InstanceList;

public class MaxEntL1Trainer
extends MaxEntTrainer {
    private static final long serialVersionUID = 1L;
    double l1Weight = 1.0;

    public MaxEntL1Trainer() {
        super(Double.MAX_VALUE);
    }

    public MaxEntL1Trainer(double l1wt) {
        super(Double.MAX_VALUE);
        this.l1Weight = l1wt;
    }

    public MaxEntL1Trainer(MaxEnt initClassifier) {
        super(initClassifier);
        this.gaussianPriorVariance = Double.MAX_VALUE;
    }

    public Optimizer getOptimizer() {
        if (this.optimizer == null && this.optimizable != null) {
            this.optimizer = new OrthantWiseLimitedMemoryBFGS(this.optimizable, this.l1Weight);
        }
        return this.optimizer;
    }

    public Optimizer getOptimizer(InstanceList trainingSet) {
        if (trainingSet != this.trainingSet || this.optimizable == null) {
            this.getOptimizable(trainingSet);
            this.optimizer = null;
        }
        if (this.optimizer == null) {
            this.optimizer = new OrthantWiseLimitedMemoryBFGS(this.optimizable, this.l1Weight);
        }
        return this.optimizer;
    }
}

