/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.create.synonym;

import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.schema.Synonym;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;

public class CreateSynonym
implements Statement {
    public Synonym synonym;
    private boolean orReplace;
    private boolean publicSynonym;
    private List<String> forList = new ArrayList<String>();

    public Synonym getSynonym() {
        return this.synonym;
    }

    public void setSynonym(Synonym synonym) {
        this.synonym = synonym;
    }

    public boolean isOrReplace() {
        return this.orReplace;
    }

    public void setOrReplace(boolean orReplace) {
        this.orReplace = orReplace;
    }

    public boolean isPublicSynonym() {
        return this.publicSynonym;
    }

    public void setPublicSynonym(boolean publicSynonym) {
        this.publicSynonym = publicSynonym;
    }

    public List<String> getForList() {
        return this.forList;
    }

    public void setForList(List<String> forList) {
        this.forList = forList;
    }

    public String getFor() {
        StringBuilder b = new StringBuilder();
        for (String name : this.forList) {
            if (b.length() > 0) {
                b.append(".");
            }
            b.append(name);
        }
        return b.toString();
    }

    @Override
    public <T, S> T accept(StatementVisitor<T> statementVisitor, S context) {
        return statementVisitor.visit(this, context);
    }

    public String toString() {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("CREATE ");
        if (this.orReplace) {
            sqlBuilder.append("OR REPLACE ");
        }
        if (this.publicSynonym) {
            sqlBuilder.append("PUBLIC ");
        }
        sqlBuilder.append("SYNONYM " + this.synonym);
        sqlBuilder.append(' ');
        sqlBuilder.append("FOR " + this.getFor());
        return sqlBuilder.toString();
    }

    public CreateSynonym withSynonym(Synonym synonym) {
        this.setSynonym(synonym);
        return this;
    }
}

