/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.plan;

import java.io.InputStream;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.plan.PostgrePlanNodeExternal;
import org.jkiss.dbeaver.ext.postgresql.model.plan.PostgrePlanNodeText;
import org.jkiss.dbeaver.ext.postgresql.model.plan.PostgrePlanNodeXML;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerConfiguration;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlan;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLException;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PostgreExecutionPlan
extends AbstractExecutionPlan {
    private static final Log log = Log.getLog(PostgreExecutionPlan.class);
    private static final String NODE_PREFIX = "->  ";
    private static final String PROP_PREFIX = "  ";
    private boolean oldQuery;
    private boolean verbose;
    private String query;
    private DBCQueryPlannerConfiguration configuration;
    private List<DBCPlanNode> rootNodes;

    public PostgreExecutionPlan(boolean oldQuery, boolean verbose, String query, DBCQueryPlannerConfiguration configuration) {
        this.oldQuery = oldQuery;
        this.verbose = verbose;
        this.query = query;
        this.configuration = configuration;
    }

    public PostgreExecutionPlan(String query, List<PostgrePlanNodeExternal> nodes) {
        this.query = query;
        this.rootNodes = new ArrayList<DBCPlanNode>();
        this.rootNodes.addAll(nodes);
        this.configuration = new DBCQueryPlannerConfiguration();
    }

    public Object getPlanFeature(String feature) {
        if ("plan.cost".equals(feature) || "plan.duration".equals(feature) || "plan.rows".equals(feature)) {
            return true;
        }
        return super.getPlanFeature(feature);
    }

    public String getQueryString() {
        return this.query;
    }

    public String getPlanQueryString() {
        if (this.oldQuery) {
            return "EXPLAIN " + (this.verbose ? "VERBOSE " : "") + this.query;
        }
        Map parameters = this.configuration.getParameters();
        StringBuilder explainStat = new StringBuilder(64);
        explainStat.append("EXPLAIN (FORMAT XML");
        for (Map.Entry entry : CommonUtils.safeCollection(parameters.entrySet())) {
            String key = (String)entry.getKey();
            if ("TIMING".equals(key) && !CommonUtils.toBoolean(parameters.get("ANALYZE"))) continue;
            if ("COSTS".equals(key) || "TIMING".equals(key)) {
                if (CommonUtils.toBoolean(entry.getValue())) continue;
                explainStat.append(",").append(key).append(" FALSE");
                continue;
            }
            if (!CommonUtils.toBoolean(entry.getValue())) continue;
            explainStat.append(",").append(key);
        }
        explainStat.append(") ").append(this.query);
        return explainStat.toString();
    }

    public List<? extends DBCPlanNode> getPlanNodes(Map<String, Object> options) {
        return this.rootNodes;
    }

    public void explain(DBCSession session) throws DBCException {
        JDBCSession connection = (JDBCSession)session;
        boolean oldAutoCommit = false;
        try {
            try {
                oldAutoCommit = connection.getAutoCommit();
                if (oldAutoCommit) {
                    connection.setAutoCommit(false);
                }
                Throwable throwable = null;
                Object var5_7 = null;
                try (JDBCStatement dbStat = connection.createStatement();){
                    try {
                        Throwable throwable2 = null;
                        Object var8_13 = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery(this.getPlanQueryString());){
                            if (this.oldQuery) {
                                ArrayList<String> planLines = new ArrayList<String>();
                                while (dbResult.next()) {
                                    String planLine = dbResult.getString(1);
                                    if (CommonUtils.isEmpty((String)planLine)) continue;
                                    planLines.add(planLine);
                                }
                                this.parsePlanText(session, planLines);
                            } else if (dbResult.next()) {
                                SQLXML planXML = dbResult.getSQLXML(1);
                                this.parsePlanXML(session, planXML);
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (XMLException e) {
                        throw new DBCException("Can't parse plan XML", (Throwable)e);
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, session.getExecutionContext());
            }
        }
        finally {
            try {
                connection.rollback();
                if (oldAutoCommit) {
                    connection.setAutoCommit(true);
                }
            }
            catch (SQLException e) {
                log.error((Object)"Error closing plan analyser", (Throwable)e);
            }
        }
    }

    private void parsePlanXML(DBCSession session, SQLXML planXML) throws SQLException, XMLException {
        this.rootNodes = new ArrayList<DBCPlanNode>();
        Document planDocument = XMLUtils.parseDocument((InputStream)planXML.getBinaryStream());
        Element queryElement = XMLUtils.getChildElement((Element)planDocument.getDocumentElement(), (String)"Query");
        for (Element planElement : XMLUtils.getChildElementList((Element)queryElement, (String)"Plan")) {
            this.rootNodes.add((DBCPlanNode)new PostgrePlanNodeXML(session.getDataSource(), null, planElement));
        }
    }

    private void parsePlanText(DBCSession session, List<String> lines) {
        DBPDataSource dataSource = session.getDataSource();
        ArrayList<PostgrePlanNodeText> nodes = new ArrayList<PostgrePlanNodeText>(lines.size());
        PostgrePlanNodeText rootNode = null;
        PostgrePlanNodeText curNode = null;
        PostgrePlanNodeText curParentNode = null;
        int curIndent = 0;
        for (String line : lines) {
            int lineIndent;
            int i = lineIndent = 0;
            while (i < line.length()) {
                if (line.charAt(i) != ' ') break;
                ++lineIndent;
                ++i;
            }
            if (curIndent == 0 && lineIndent == 0) {
                curNode = rootNode = new PostgrePlanNodeText(dataSource, null, line, lineIndent);
                curParentNode = rootNode;
                nodes.add(rootNode);
                continue;
            }
            if (lineIndent >= curIndent) {
                if (line.substring(lineIndent).startsWith(NODE_PREFIX)) {
                    if (lineIndent > curNode.getIndent()) {
                        curParentNode = curNode;
                    }
                } else {
                    if (lineIndent == curIndent || lineIndent == curIndent) {
                        curNode.addProp(line);
                        continue;
                    }
                    if (curNode != null) {
                        curNode.addProp(line);
                        continue;
                    }
                    log.debug((Object)("Unexpected node line: " + line));
                    continue;
                }
                curNode = new PostgrePlanNodeText(dataSource, curParentNode, line, lineIndent += NODE_PREFIX.length());
                nodes.add(0, curNode);
                curIndent = lineIndent;
                continue;
            }
            if (lineIndent >= curIndent) continue;
            if (lineIndent != 0) {
                if (lineIndent + NODE_PREFIX.length() < curNode.getIndent()) {
                    curParentNode = rootNode;
                    i = 0;
                    while (i < nodes.size()) {
                        if (((PostgrePlanNodeText)((Object)nodes.get(i))).getIndent() == lineIndent - 2) {
                            curParentNode = (PostgrePlanNodeText)((Object)nodes.get(i));
                            break;
                        }
                        ++i;
                    }
                }
                if (!line.substring(lineIndent).startsWith(NODE_PREFIX)) {
                    curNode.addProp(line);
                } else {
                    curNode = new PostgrePlanNodeText(dataSource, curParentNode, line, lineIndent += NODE_PREFIX.length());
                    nodes.add(0, curNode);
                }
            }
            curIndent = lineIndent;
        }
        this.rootNodes = new ArrayList<DBCPlanNode>();
        this.rootNodes.add((DBCPlanNode)rootNode);
    }
}

