/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model.fed;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.DB2Messages;
import org.jkiss.dbeaver.ext.db2.editors.DB2SourceObject;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2TableBase;
import org.jkiss.dbeaver.ext.db2.model.DB2TableColumn;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TableAccessMode;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TablePartitionMode;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TableStatus;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2YesNo;
import org.jkiss.dbeaver.ext.db2.model.fed.DB2NicknameRemoteType;
import org.jkiss.dbeaver.ext.db2.model.fed.DB2RemoteServer;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructLookupCache;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.utils.CommonUtils;

public class DB2Nickname
extends DB2TableBase
implements DBPNamedObject2,
DBPRefreshableObject,
DB2SourceObject {
    private DB2TableStatus status;
    private String dataCapture;
    private String constChecked;
    private DB2TablePartitionMode partitionMode;
    private DB2TableAccessMode accessMode;
    private Timestamp statsTime;
    private Long card;
    private Long nPages;
    private Long fPages;
    private Long overFLow;
    private String remoteTableName;
    private String remoteSchemaName;
    private DB2RemoteServer db2RemoteServer;
    private DB2NicknameRemoteType remoteType;
    private Boolean cachingAllowed;

    public DB2Nickname(DBRProgressMonitor monitor, DB2Schema db2Schema, ResultSet dbResult) throws DBException {
        super(monitor, db2Schema, dbResult);
        this.status = (DB2TableStatus)CommonUtils.valueOf(DB2TableStatus.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"STATUS"));
        this.statsTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"STATS_TIME");
        this.dataCapture = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DATACAPTURE");
        this.constChecked = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONST_CHECKED");
        this.partitionMode = (DB2TablePartitionMode)CommonUtils.valueOf(DB2TablePartitionMode.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PARTITION_MODE"));
        this.accessMode = (DB2TableAccessMode)CommonUtils.valueOf(DB2TableAccessMode.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ACCESS_MODE"));
        this.card = JDBCUtils.safeGetLongNullable((ResultSet)dbResult, (String)"CARD");
        this.nPages = JDBCUtils.safeGetLongNullable((ResultSet)dbResult, (String)"NPAGES");
        this.fPages = JDBCUtils.safeGetLongNullable((ResultSet)dbResult, (String)"FPAGES");
        this.overFLow = JDBCUtils.safeGetLongNullable((ResultSet)dbResult, (String)"OVERFLOW");
        this.remoteTableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REMOTE_TABLE");
        this.remoteSchemaName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"REMOTE_SCHEMA");
        this.remoteType = (DB2NicknameRemoteType)CommonUtils.valueOf(DB2NicknameRemoteType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REMOTE_TYPE"));
        this.cachingAllowed = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"CACHINGALLOWED", (String)DB2YesNo.Y.name());
        String serverName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SERVERNAME");
        if (serverName != null) {
            this.db2RemoteServer = ((DB2DataSource)this.getDataSource()).getRemoteServer(monitor, serverName);
        }
    }

    public boolean isView() {
        return false;
    }

    public JDBCStructLookupCache<DB2Schema, DB2Nickname, DB2TableColumn> getCache() {
        return ((DB2Schema)this.getContainer()).getNicknameCache();
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        ((DB2Schema)this.getContainer()).getNicknameCache().clearChildrenCache(this);
        super.refreshObject(monitor);
        return ((DB2Schema)this.getContainer()).getNicknameCache().refreshObject(monitor, (DB2Schema)this.getContainer(), this);
    }

    @Override
    public DB2TableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return (DB2TableColumn)((DB2Schema)this.getContainer()).getNicknameCache().getChild(monitor, (DB2Schema)this.getContainer(), this, attributeName);
    }

    public List<DB2TableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((DB2Schema)this.getContainer()).getNicknameCache().getChildren(monitor, (DB2Schema)this.getContainer(), this);
    }

    @NotNull
    public DBSObjectState getObjectState() {
        return this.status.getState();
    }

    @Override
    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return DB2Messages.no_ddl_for_nicknames;
    }

    @Override
    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Property(viewable=true, editable=false, order=4)
    public DB2TableStatus getStatus() {
        return this.status;
    }

    @Property(viewable=false, editable=false, order=100)
    public DB2TableAccessMode getAccessMode() {
        return this.accessMode;
    }

    @Property(viewable=true, editable=false, order=101)
    public Boolean getCachingAllowed() {
        return this.cachingAllowed;
    }

    @Property(viewable=false, editable=false, category="Statistics")
    public Long getCard() {
        return this.card;
    }

    @Property(viewable=false, editable=false, category="Statistics")
    public Timestamp getStatsTime() {
        return this.statsTime;
    }

    @Property(viewable=false, editable=false, category="Statistics")
    public Long getnPages() {
        return this.nPages;
    }

    @Property(viewable=false, editable=false, category="Statistics")
    public Long getfPages() {
        return this.fPages;
    }

    @Property(viewable=false, editable=false, category="Statistics")
    public Long getOverFLow() {
        return this.overFLow;
    }

    @Property(viewable=false, editable=false, order=109)
    public String getDataCapture() {
        return this.dataCapture;
    }

    @Property(viewable=false, editable=false, order=111)
    public DB2TablePartitionMode getPartitionMode() {
        return this.partitionMode;
    }

    @Property(viewable=false, editable=false, order=111)
    public String getConstChecked() {
        return this.constChecked;
    }

    @Property(viewable=true, editable=false, order=10, category="Remote")
    public DB2RemoteServer getDb2RemoteServer() {
        return this.db2RemoteServer;
    }

    @Property(viewable=true, editable=false, order=11, category="Remote")
    public DB2NicknameRemoteType getRemoteType() {
        return this.remoteType;
    }

    @Property(viewable=true, editable=false, order=12, category="Remote")
    public String getRemoteSchemaName() {
        return this.remoteSchemaName;
    }

    @Property(viewable=true, editable=false, order=13, category="Remote")
    public String getRemoteTableName() {
        return this.remoteTableName;
    }

    @Override
    @Property(viewable=false, hidden=true)
    public Integer getTableId() {
        return super.getTableId();
    }
}

