/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTriggerBase;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.utils.CommonUtils;

public class PostgreEventTrigger
extends PostgreTriggerBase {
    private long objectId;
    private long routineId;
    private TriggerEventTypes eventType;
    private String enabledState;
    private String description;
    private String body;

    PostgreEventTrigger(@NotNull PostgreDatabase database, @NotNull String name, @NotNull JDBCResultSet dbResult) {
        super(database, name, true);
        this.objectId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
        this.routineId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"evtfoid");
        String eventTypeName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"evtevent");
        this.eventType = (TriggerEventTypes)CommonUtils.valueOf(TriggerEventTypes.class, (String)eventTypeName);
        this.enabledState = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"evtenabled");
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"description");
    }

    public PostgreEventTrigger(@NotNull PostgreDatabase database, String name) {
        super(database, name, false);
    }

    @Property(viewable=true, order=2)
    public long getObjectId() {
        return this.objectId;
    }

    @Property(viewable=true, order=3)
    public TriggerEventTypes getEventType() {
        return this.eventType;
    }

    public void setEventType(TriggerEventTypes eventType) {
        this.eventType = eventType;
    }

    @Override
    @Property(viewable=true, order=4)
    public PostgreProcedure getFunction(DBRProgressMonitor monitor) throws DBException {
        if (this.routineId == 0L) {
            return null;
        }
        return this.getDatabase().getProcedure(monitor, this.routineId);
    }

    public void setFunction(PostgreProcedure function) {
        this.routineId = function != null ? function.getObjectId() : 0L;
    }

    @Override
    @Property(viewable=true, order=5)
    public String getEnabledState() {
        return this.enabledState;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getQuotedIdentifier((DBSObject)this);
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        StringBuilder ddl = new StringBuilder();
        PostgreProcedure function = this.getFunction(monitor);
        if (function == null) {
            return "-- Event trigger definition is not available - can't read trigger function";
        }
        if (CommonUtils.isEmpty((String)this.body)) {
            this.body = "CREATE EVENT TRIGGER " + this.getFullyQualifiedName(DBPEvaluationContext.DDL) + " ON " + String.valueOf((Object)this.eventType) + "\n\tEXECUTE " + function.getProcedureTypeName() + " " + function.getFullQualifiedSignature();
        }
        ddl.append(this.body);
        if (!CommonUtils.isEmpty((String)this.getDescription()) && CommonUtils.getOption(options, (String)"ddl.includeComments")) {
            ddl.append(";\n\nCOMMENT ON EVENT TRIGGER ").append(DBUtils.getQuotedIdentifier((DBSObject)this)).append(" IS ").append(SQLUtils.quoteString((DBSObject)this, (String)this.getDescription())).append(";");
        }
        return ddl.toString();
    }

    @Override
    public void setObjectDefinitionText(String sourceText) {
        this.body = sourceText;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getDatabase().getEventTriggersCache().refreshObject(monitor, this.getDatabase(), this);
    }

    @NotNull
    public DBSObjectState getObjectState() {
        if ("D".equals(this.enabledState)) {
            return DBSObjectState.INVALID;
        }
        return DBSObjectState.NORMAL;
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Refresh triggers state");){
            try {
                this.enabledState = JDBCUtils.queryString((Connection)session, (String)"SELECT evtenabled FROM pg_catalog.pg_event_trigger WHERE oid=?", (Object[])new Object[]{this.getObjectId()});
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @NotNull
    public DBSObject getParentObject() {
        return this.getDatabase();
    }

    public DBSTable getTable() {
        return null;
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static enum TriggerEventTypes {
        ddl_command_start,
        ddl_command_end,
        table_rewrite,
        sql_drop;

    }
}

