/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreViewManager;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreMaterializedView;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablespace;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreViewBase;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.ArrayUtils;

public class PostgreMViewManager
extends PostgreViewManager {
    @Override
    protected PostgreMaterializedView createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) {
        PostgreSchema schema = (PostgreSchema)container;
        PostgreMaterializedView newMV = new PostgreMaterializedView(schema);
        newMV.setName("new_mview");
        this.setNewObjectName(monitor, schema, newMV);
        return newMV;
    }

    @Override
    protected String getBaseObjectName() {
        return "NewMView";
    }

    @Override
    protected void createOrReplaceViewQuery(DBRProgressMonitor monitor, List<DBEPersistAction> actions, PostgreViewBase view, Map<String, Object> options) throws DBException {
        super.createOrReplaceViewQuery(monitor, actions, view, options);
    }

    @Override
    public void appendViewDeclarationPrefix(DBRProgressMonitor monitor, StringBuilder sqlBuf, PostgreViewBase view) throws DBException {
        PostgreTablespace tablespace;
        PostgreMaterializedView mview = (PostgreMaterializedView)view;
        Object[] relOptions = mview.getRelOptions();
        if (!ArrayUtils.isEmpty((Object[])relOptions)) {
            sqlBuf.append("\nWITH(").append(String.join((CharSequence)",", (CharSequence[])relOptions)).append(")");
        }
        if ((tablespace = mview.getTablespace(monitor)) != null) {
            sqlBuf.append("\nTABLESPACE ").append(DBUtils.getQuotedIdentifier((DBSObject)tablespace));
        }
    }

    @Override
    public void appendViewDeclarationPostfix(DBRProgressMonitor monitor, StringBuilder sqlBuf, PostgreViewBase view) {
        PostgreMaterializedView mview = (PostgreMaterializedView)view;
        boolean withData = mview.isWithData();
        sqlBuf.append("\n").append(withData ? "WITH DATA" : "WITH NO DATA");
    }

    @Override
    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) throws DBException {
        PostgreMaterializedView mView = (PostgreMaterializedView)command.getObject();
        if (!command.hasProperty((Object)"description") || command.getProperties().size() > 1) {
            super.addObjectDeleteActions(monitor, executionContext, actionList, new SQLObjectEditor.ObjectDeleteCommand((SQLObjectEditor)this, (DBSObject)mView, "Drop view"), options);
            super.addObjectModifyActions(monitor, executionContext, actionList, command, options);
        }
        if (command.hasProperty((Object)"tablespace")) {
            String alterPrefix = "ALTER " + mView.getTableTypeName() + " " + ((PostgreTableBase)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " ";
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(alterPrefix + "SET TABLESPACE " + mView.getTablespace(monitor).getName()));
        }
    }
}

