/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.jdom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.jdom.JDOMAttributePointer;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;

public class JDOMAttributeIterator
implements NodeIterator {
    private NodePointer parent;
    private List attributes;
    private int position = 0;

    public JDOMAttributeIterator(NodePointer parent, QName name) {
        this.parent = parent;
        if (parent.getNode() instanceof Element) {
            Element element = (Element)parent.getNode();
            String prefix = name.getPrefix();
            Namespace ns = null;
            if (prefix != null) {
                if (prefix.equals("xml")) {
                    ns = Namespace.XML_NAMESPACE;
                } else {
                    String uri = parent.getNamespaceResolver().getNamespaceURI(prefix);
                    if (uri != null) {
                        ns = Namespace.getNamespace((String)prefix, (String)uri);
                    }
                    if (ns == null) {
                        this.attributes = Collections.EMPTY_LIST;
                        return;
                    }
                }
            } else {
                ns = Namespace.NO_NAMESPACE;
            }
            String lname = name.getName();
            if (!lname.equals("*")) {
                this.attributes = new ArrayList();
                Attribute attr = element.getAttribute(lname, ns);
                if (attr != null) {
                    this.attributes.add(attr);
                }
            } else {
                this.attributes = new ArrayList();
                List allAttributes = element.getAttributes();
                for (int i = 0; i < allAttributes.size(); ++i) {
                    Attribute attr = (Attribute)allAttributes.get(i);
                    if (ns != Namespace.NO_NAMESPACE && !attr.getNamespace().equals((Object)ns)) continue;
                    this.attributes.add(attr);
                }
            }
        }
    }

    @Override
    public NodePointer getNodePointer() {
        int index;
        if (this.position == 0) {
            if (!this.setPosition(1)) {
                return null;
            }
            this.position = 0;
        }
        if ((index = this.position - 1) < 0) {
            index = 0;
        }
        return new JDOMAttributePointer(this.parent, (Attribute)this.attributes.get(index));
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public boolean setPosition(int position) {
        if (this.attributes == null) {
            return false;
        }
        this.position = position;
        return position >= 1 && position <= this.attributes.size();
    }
}

