/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.ExasolMessages;
import org.jkiss.dbeaver.ext.exasol.ExasolSysTablePrefix;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableBase;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableColumn;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableForeignKey;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableIndex;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTablePartitionColumn;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableUniqueKey;
import org.jkiss.dbeaver.ext.exasol.model.cache.ExasolTableForeignKeyCache;
import org.jkiss.dbeaver.ext.exasol.model.cache.ExasolTableIndexCache;
import org.jkiss.dbeaver.ext.exasol.model.cache.ExasolTablePartitionColumnCache;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPReferentialIntegrityController;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.IPropertyCacheValidator;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyGroup;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstrainable;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintInfo;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;
import org.jkiss.utils.ByteNumberFormat;
import org.jkiss.utils.CommonUtils;

public class ExasolTable
extends ExasolTableBase
implements DBPScriptObject,
DBPReferentialIntegrityController,
DBSEntityConstrainable {
    private static final CharSequence TABLE_NAME_PLACEHOLDER = "%table_name%";
    private static final CharSequence FOREIGN_KEY_NAME_PLACEHOLDER = "%foreign_key_name%";
    private static final String DISABLE_REFERENTIAL_INTEGRITY_STATEMENT = "ALTER TABLE " + String.valueOf(TABLE_NAME_PLACEHOLDER) + " MODIFY CONSTRAINT " + String.valueOf(FOREIGN_KEY_NAME_PLACEHOLDER) + " DISABLE";
    private static final String ENABLE_REFERENTIAL_INTEGRITY_STATEMENT = "ALTER TABLE " + String.valueOf(TABLE_NAME_PLACEHOLDER) + " MODIFY CONSTRAINT " + String.valueOf(FOREIGN_KEY_NAME_PLACEHOLDER) + " ENABLE";
    private long sizeRaw;
    private long sizeCompressed;
    private final String tablePrefix;
    private final ExasolTablePartitionColumnCache tablePartitionColumnCache = new ExasolTablePartitionColumnCache();
    private final AdditionalInfo additionalInfo = new AdditionalInfo();
    private static String readAdditionalTableInfo = "/*snapshot execution*/ SELECT    * FROM    (    SELECT        table_schema,        table_name,        table_owner,        table_has_distribution_key,        %s        table_comment,        table_row_count,        delete_percentage,        o.created,        o.last_commit,        o.object_type    FROM        %s_OBJECTS o    INNER JOIN %s_TABLES T ON        o.object_id = t.table_object_id    WHERE        o.object_id = ?        AND t.table_object_id = ? UNION ALL    SELECT        schema_name AS table_schema,        object_name AS table_name,        'SYS' AS table_owner,        FALSE AS table_has_distribution_key,        FALSE AS table_has_partition_key,        object_comment AS table_comment,        -1 AS table_row_count,        -1 AS delete_percentage,        CAST( NULL AS TIMESTAMP) AS CREATED,        CAST( NULL AS TIMESTAMP) AS last_commit,        object_type    FROM        SYS.EXA_SYSCAT    WHERE        object_type = 'TABLE'        AND schema_name = ?        AND object_name = ? ) AS o ORDER BY     table_schema,    o.table_name";
    private static String readTableSize = "/*snapshot execution*/ SELECT     * FROM     (     SELECT         root_name,         object_name,         raw_object_size,         mem_object_size     FROM         %s_OBJECT_SIZES      WHERE         object_id = ? UNION ALL     SELECT         schema_name AS root_name,         object_name,         -1 AS raw_object_size,         -1 AS mem_object_size     FROM         SYS.EXA_SYSCAT     WHERE         object_type = 'TABLE'         AND schema_name = ?         AND object_name = ? ) AS o ORDER BY     root_name,     object_name";

    private ExasolTable getObject() {
        return this;
    }

    public ExasolTable(DBRProgressMonitor monitor, ExasolSchema schema, ResultSet dbResult) throws DBException {
        super(monitor, schema, dbResult);
        this.tablePrefix = schema.getDataSource().getTablePrefix(ExasolSysTablePrefix.ALL);
    }

    public ExasolTable(ExasolSchema schema, String name) {
        super(schema, name, false);
        this.tablePrefix = schema.getDataSource().getTablePrefix(ExasolSysTablePrefix.ALL);
    }

    private void read(DBRProgressMonitor monitor) throws DBCException {
        Throwable throwable;
        Throwable throwable2;
        if (!this.isPersisted()) {
            this.additionalInfo.loaded = true;
            return;
        }
        JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)ExasolMessages.read_table_details);
        String sqlTableInfo = String.format(readAdditionalTableInfo, ((ExasolDataSource)this.getDataSource()).ishasPriorityGroups() ? "table_has_partition_key," : "false as table_has_partition_key,", this.tablePrefix, this.tablePrefix);
        try {
            Throwable throwable3 = null;
            throwable2 = null;
            try (JDBCPreparedStatement stmt = session.prepareStatement(sqlTableInfo);){
                stmt.setBigDecimal(1, this.getObjectId());
                stmt.setBigDecimal(2, this.getObjectId());
                stmt.setString(3, this.getSchema().getName());
                stmt.setString(4, this.getName());
                Throwable throwable4 = null;
                throwable = null;
                try (JDBCResultSet dbResult = stmt.executeQuery();){
                    dbResult.next();
                    this.additionalInfo.hasDistKey = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"TABLE_HAS_DISTRIBUTION_KEY");
                    this.additionalInfo.hasPartitionKey = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"TABLE_HAS_PARTITION_KEY");
                    if (this.additionalInfo.hasPartitionKey == null) {
                        this.additionalInfo.hasPartitionKey = false;
                    }
                    this.additionalInfo.lastCommit = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_COMMIT");
                    this.additionalInfo.deletePercentage = JDBCUtils.safeGetFloat((ResultSet)dbResult, (String)"DELETE_PERCENTAGE");
                    this.additionalInfo.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATED");
                    this.additionalInfo.tablecount = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"TABLE_ROW_COUNT");
                }
                catch (Throwable throwable5) {
                    if (throwable4 == null) {
                        throwable4 = throwable5;
                    } else if (throwable4 != throwable5) {
                        throwable4.addSuppressed(throwable5);
                    }
                    throw throwable4;
                }
            }
            catch (Throwable throwable6) {
                if (throwable3 == null) {
                    throwable3 = throwable6;
                } else if (throwable3 != throwable6) {
                    throwable3.addSuppressed(throwable6);
                }
                throw throwable3;
            }
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
        }
        String sqlTableSize = String.format(readTableSize, this.tablePrefix);
        try {
            throwable2 = null;
            Object var6_11 = null;
            try (JDBCPreparedStatement stmt = session.prepareStatement(sqlTableSize);){
                stmt.setBigDecimal(1, this.getObjectId());
                stmt.setString(2, this.getSchema().getName());
                stmt.setString(3, this.getName());
                throwable = null;
                Object var9_18 = null;
                try (JDBCResultSet dbResult = stmt.executeQuery();){
                    dbResult.next();
                    this.sizeRaw = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"RAW_OBJECT_SIZE");
                    this.sizeCompressed = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"MEM_OBJECT_SIZE");
                }
                catch (Throwable throwable7) {
                    if (throwable == null) {
                        throwable = throwable7;
                    } else if (throwable != throwable7) {
                        throwable.addSuppressed(throwable7);
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable8) {
                if (throwable2 == null) {
                    throwable2 = throwable8;
                } else if (throwable2 != throwable8) {
                    throwable2.addSuppressed(throwable8);
                }
                throw throwable2;
            }
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
        }
        this.additionalInfo.loaded = true;
    }

    @Override
    public void refreshObjectState(DBRProgressMonitor monitor) throws DBCException {
        this.read(monitor);
        this.tablePartitionColumnCache.clearCache();
        this.getSchema().getIndexCache().clearObjectCache(this);
        super.refreshObjectState(monitor);
    }

    public TableAdditionalInfo getAdditionalInfo() {
        return this.additionalInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PropertyGroup
    @LazyProperty(cacheValidator=AdditionalInfoValidator.class)
    public AdditionalInfo getAdditionalInfo(DBRProgressMonitor monitor) throws DBException {
        AdditionalInfo additionalInfo = this.additionalInfo;
        synchronized (additionalInfo) {
            if (!this.additionalInfo.loaded && monitor != null) {
                this.read(monitor);
            }
            return this.additionalInfo;
        }
    }

    @NotNull
    public List<DBSEntityConstraintInfo> getSupportedConstraints() {
        return List.of(DBSEntityConstraintInfo.of((DBSEntityConstraintType)DBSEntityConstraintType.PRIMARY_KEY, ExasolTableUniqueKey.class));
    }

    @Override
    @Nullable
    @Association
    public Collection<ExasolTableUniqueKey> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((ExasolSchema)this.getContainer()).getConstraintCache().getObjects(monitor, (ExasolSchema)this.getContainer(), this);
    }

    public ExasolTableUniqueKey getConstraint(DBRProgressMonitor monitor, String ukName) throws DBException {
        return (ExasolTableUniqueKey)((ExasolSchema)this.getContainer()).getConstraintCache().getObject(monitor, (ExasolSchema)this.getContainer(), this, ukName);
    }

    @Override
    @Association
    public Collection<ExasolTableForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getSchema().getAssociationCache().getObjects(monitor, this.getSchema(), this);
    }

    public synchronized DBSTableForeignKey getAssociation(DBRProgressMonitor monitor, String fkName) throws DBException {
        return (DBSTableForeignKey)((ExasolSchema)this.getContainer()).getAssociationCache().getObject(monitor, (ExasolSchema)this.getContainer(), this, fkName);
    }

    public ExasolTableUniqueKey getPrimaryKey(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.getConstraints(monitor).isEmpty()) {
            return null;
        }
        return this.getConstraints(monitor).iterator().next();
    }

    @Override
    public boolean isView() {
        return false;
    }

    public JDBCStructCache<ExasolSchema, ExasolTable, ExasolTableColumn> getCache() {
        return ((ExasolSchema)this.getContainer()).getTableCache();
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.refreshObject(monitor);
        ((ExasolSchema)this.getContainer()).getTableCache().clearChildrenCache(this);
        ((ExasolSchema)this.getContainer()).getConstraintCache().clearObjectCache(this);
        ((ExasolSchema)this.getContainer()).getAssociationCache().clearObjectCache(this);
        return this;
    }

    @Override
    public ExasolTableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return (ExasolTableColumn)((ExasolSchema)this.getContainer()).getTableCache().getChild(monitor, (ExasolSchema)this.getContainer(), this, attributeName);
    }

    public List<ExasolTableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((ExasolSchema)this.getContainer()).getTableCache().getChildren(monitor, (ExasolSchema)this.getContainer(), this);
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return ExasolUtils.generateDDLforTable(monitor, (ExasolDataSource)this.getDataSource(), this);
    }

    public DBSObjectState getObjectState() {
        return DBSObjectState.NORMAL;
    }

    public Collection<ExasolTableColumn> getDistributionKey(DBRProgressMonitor monitor) throws DBException {
        ArrayList<ExasolTableColumn> distKeyCols = new ArrayList<ExasolTableColumn>();
        for (ExasolTableColumn c : this.getAttributes(monitor)) {
            if (!c.isDistKey().booleanValue()) continue;
            distKeyCols.add(c);
        }
        return distKeyCols;
    }

    public ExasolTablePartitionColumn getPartition(String name) throws DBException {
        return (ExasolTablePartitionColumn)this.tablePartitionColumnCache.getCachedObject(name);
    }

    public Collection<ExasolTablePartitionColumn> getPartitions(DBRProgressMonitor monitor) throws DBException {
        return this.tablePartitionColumnCache.getAllObjects(monitor, this);
    }

    public ExasolTablePartitionColumnCache getPartitionCache() {
        return this.tablePartitionColumnCache;
    }

    public Collection<ExasolTableColumn> getAvailableColumns(DBRProgressMonitor monitor) throws DBException {
        return this.tablePartitionColumnCache.getAvailableTableColumns(this, monitor);
    }

    public void setHasPartitionKey(Boolean hasPartitionKey) {
        if (!this.additionalInfo.hasPartitionKey.booleanValue() && hasPartitionKey.booleanValue()) {
            return;
        }
        this.additionalInfo.hasPartitionKey = hasPartitionKey;
        this.tablePartitionColumnCache.setCache(new ArrayList());
    }

    public void setHasPartitionKey(Boolean hasPartitionKey, Boolean force) {
        if (force.booleanValue()) {
            this.additionalInfo.hasPartitionKey = hasPartitionKey;
        }
        this.setHasPartitionKey(hasPartitionKey);
    }

    public List<ExasolTableIndex> getIndexes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getIndexCache().getObjects(monitor, this.getSchema(), this.getObject());
    }

    private ExasolTableIndexCache getIndexCache() {
        return this.getSchema().getIndexCache();
    }

    public Collection<ExasolTableForeignKey> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        ExasolTableForeignKeyCache associationCache = this.getSchema().getAssociationCache();
        ArrayList<ExasolTableForeignKey> refForeignKeys = new ArrayList<ExasolTableForeignKey>();
        for (ExasolTableForeignKey exasolTableForeignKey : associationCache.getObjects(monitor, this.getSchema(), null)) {
            if (exasolTableForeignKey.getReferencedTable() != this) continue;
            refForeignKeys.add(exasolTableForeignKey);
        }
        return refForeignKeys;
    }

    public boolean supportsChangingReferentialIntegrity(@NotNull DBRProgressMonitor monitor) throws DBException {
        return !CommonUtils.isEmpty(this.getAssociations(monitor));
    }

    public void enableReferentialIntegrity(@NotNull DBRProgressMonitor monitor, boolean enable) throws DBException {
        Collection<ExasolTableForeignKey> foreignKeys = this.getAssociations(monitor);
        if (CommonUtils.isEmpty(foreignKeys)) {
            return;
        }
        String template = enable ? ENABLE_REFERENTIAL_INTEGRITY_STATEMENT : DISABLE_REFERENTIAL_INTEGRITY_STATEMENT;
        template = template.replace(TABLE_NAME_PLACEHOLDER, this.getFullyQualifiedName(DBPEvaluationContext.DDL));
        Throwable throwable = null;
        Object var6_7 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Changing referential integrity");){
            try {
                Throwable throwable2 = null;
                Object var9_13 = null;
                try (JDBCStatement statement = session.createStatement();){
                    for (DBPNamedObject dBPNamedObject : foreignKeys) {
                        String sql = template.replace(FOREIGN_KEY_NAME_PLACEHOLDER, dBPNamedObject.getName());
                        statement.executeUpdate(sql);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (SQLException e) {
                throw new DBException("Unable to change referential integrity", (Throwable)e);
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Nullable
    public String getChangeReferentialIntegrityStatement(@NotNull DBRProgressMonitor monitor, boolean enable) throws DBException {
        if (!this.supportsChangingReferentialIntegrity(monitor)) {
            return null;
        }
        if (enable) {
            return ENABLE_REFERENTIAL_INTEGRITY_STATEMENT;
        }
        return DISABLE_REFERENTIAL_INTEGRITY_STATEMENT;
    }

    public class AdditionalInfo
    extends TableAdditionalInfo {
        private Boolean hasDistKey;
        private long tablecount;
        private float deletePercentage;
        private Boolean hasPartitionKey;
        private Timestamp lastCommit;
        private Timestamp createTime;

        @Property(viewable=true, expensive=false, editable=false, order=90)
        public Boolean getHasDistKey(DBRProgressMonitor monitor) throws DBCException {
            return this.hasDistKey;
        }

        @Property(viewable=true, expensive=false, updatable=false, order=95)
        public Boolean getHasPartitionKey(DBRProgressMonitor monitor) throws DBCException {
            return this.hasPartitionKey;
        }

        @Property(viewable=true, expensive=false, editable=false, order=100)
        public Timestamp getLastCommit(DBRProgressMonitor monitor) throws DBCException {
            return this.lastCommit;
        }

        @Property(viewable=true, expensive=false, editable=false, order=100)
        public Timestamp getCreateTime(DBRProgressMonitor monitor) throws DBCException {
            return this.createTime;
        }

        @Property(viewable=true, expensive=false, editable=false, order=150, category="Statistics", formatter=ByteNumberFormat.class)
        public long getRawsize(DBRProgressMonitor monitor) throws DBCException {
            return ExasolTable.this.sizeRaw;
        }

        @Property(viewable=true, expensive=false, editable=false, order=200, category="Statistics", formatter=ByteNumberFormat.class)
        public long getCompressedsize(DBRProgressMonitor monitor) throws DBCException {
            return ExasolTable.this.sizeCompressed;
        }

        @Property(viewable=true, expensive=false, editable=false, order=250, category="Statistics")
        public float getDeletePercentage(DBRProgressMonitor monitor) throws DBCException {
            return this.deletePercentage;
        }

        @Property(viewable=true, expensive=false, editable=false, order=300, category="Statistics")
        public long getTableCount(DBRProgressMonitor monitor) throws DBCException {
            return this.tablecount;
        }
    }

    public static class AdditionalInfoValidator
    implements IPropertyCacheValidator<ExasolTable> {
        public boolean isPropertyCached(ExasolTable object, Object propertyId) {
            return object.getAdditionalInfo().isLoaded();
        }
    }

    public static class TableAdditionalInfo {
        volatile boolean loaded = false;

        boolean isLoaded() {
            return this.loaded;
        }
    }
}

