/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.connection;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceProvider;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.model.connection.DBPDriverFileSource;
import org.jkiss.dbeaver.model.connection.DBPDriverLibraryProvider;
import org.jkiss.dbeaver.model.connection.DBPDriverLoader;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocationManager;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialectMetadata;
import org.jkiss.utils.Pair;

public interface DBPDriver
extends DBPNamedObject,
DBPDriverLibraryProvider {
    @NotNull
    public DBPDataSourceProvider getDataSourceProvider();

    @NotNull
    public DBPDataSourceProviderDescriptor getProviderDescriptor();

    @NotNull
    public String getId();

    @NotNull
    public String getProviderId();

    @Deprecated
    @Nullable
    public String getCategory();

    @NotNull
    public List<String> getCategories();

    @NotNull
    public String getFullName();

    @Nullable
    public String getDescription();

    @NotNull
    public DBPImage getIcon();

    @NotNull
    public DBPImage getPlainIcon();

    @NotNull
    public DBPImage getIconBig();

    @Nullable
    public DBPImage getLogoImage();

    @Nullable
    public String getDriverClassName();

    @Nullable
    public String getDefaultHost();

    @Nullable
    public String getDefaultPort();

    @Nullable
    public String getDefaultDatabase();

    @Nullable
    public String getDefaultServer();

    @Nullable
    public String getDefaultUser();

    @Nullable
    public String getSampleURL();

    @Nullable
    public String getWebURL();

    @Nullable
    public String getPropertiesWebURL();

    @Nullable
    public String getDatabaseDocumentationSuffixURL();

    @NotNull
    public SQLDialectMetadata getScriptDialect();

    public boolean isClientRequired();

    public boolean supportsDriverProperties();

    public boolean isEmbedded();

    public boolean isPropagateDriverProperties();

    public boolean isAnonymousAccess();

    public boolean isAllowsEmptyPassword();

    public boolean isLicenseRequired();

    public boolean isCustomDriverLoader();

    public boolean isSampleURLApplicable();

    public boolean isCustomEndpointInformation();

    public boolean isSingleConnection();

    public boolean isThreadSafeDriver();

    public boolean isInstantiable();

    public boolean isInternalDriver();

    public boolean isCustom();

    public boolean isTemporary();

    public boolean isDisabled();

    public DBPDriver getReplacedBy();

    public boolean isNotAvailable();

    @Nullable
    public String getNonAvailabilityTitle();

    @Nullable
    public String getNonAvailabilityDescription();

    @Nullable
    public String getNonAvailabilityReason();

    @NotNull
    public List<Pair<String, String>> getDriverReplacementsInfo();

    public int getPromotedScore();

    @Nullable
    public DBXTreeNode getNavigatorRoot();

    @NotNull
    public DBPPropertyDescriptor[] getMainPropertyDescriptors();

    @NotNull
    public DBPPropertyDescriptor[] getProviderPropertyDescriptors();

    @NotNull
    public Map<String, Object> getDefaultConnectionProperties();

    @NotNull
    public Map<String, Object> getConnectionProperties();

    @NotNull
    public Map<String, Object> getDriverParameters();

    @Nullable
    public Object getDriverParameter(String var1);

    public boolean isSupportedByLocalSystem();

    @Nullable
    public String getLicense();

    @Nullable
    public DBPNativeClientLocationManager getNativeClientManager();

    @NotNull
    public List<DBPNativeClientLocation> getNativeClientLocations();

    @NotNull
    public List<? extends DBPDriverFileSource> getDriverFileSources();

    @NotNull
    public DBPDriverLoader getDefaultDriverLoader();

    @NotNull
    public DBPDriverLoader getDriverLoader(@NotNull DBPDataSourceContainer var1);

    @NotNull
    public List<DBPDriverLoader> getAllDriverLoaders();

    public void validateFilesPresence(@NotNull DBRProgressMonitor var1, @NotNull DBPDataSourceContainer var2) throws DBException;

    public void resetDriverInstance();

    @Nullable
    public String getConnectionURL(DBPConnectionConfiguration var1);

    @NotNull
    public DBPDriver createOriginalCopy();

    @NotNull
    public Set<DBPDriverConfigurationType> getSupportedConfigurationTypes();

    @NotNull
    public Set<String> getSupportedPageFields();

    @NotNull
    default public String getFullId() {
        return this.getProviderId() + ":" + this.getId();
    }

    @NotNull
    default public String getPreconfiguredId() {
        return this.isCustom() ? this.getProviderId() + ":custom-driver" : this.getFullId();
    }

    public boolean matchesId(@NotNull String var1);
}

