/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.data;

import java.sql.SQLException;
import java.util.Date;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCDateTimeValueHandler;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class PostgreDateTimeValueHandler
extends JDBCDateTimeValueHandler {
    private static final String POSITIVE_INFINITY_STRING_REPRESENTATION = "infinity";
    private static final String NEGATIVE_INFINITY_STRING_REPRESENTATION = "-infinity";
    private static final long NEGATIVE_INFINITY = -9223372036832400000L;
    private static final long NEGATIVE_SMALLER_INFINITY = -185543533774800000L;
    private static final long POSITIVE_INFINITY = 9223372036825200000L;
    private static final long POSITIVE_SMALLER_INFINITY = 185543533774800000L;

    public PostgreDateTimeValueHandler(DBDFormatSettings formatSettings) {
        super(formatSettings);
    }

    /*
     * WARNING - void declaration
     */
    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        void date;
        if (!(object instanceof Date)) {
            return super.getValueFromObject(session, type, object, copy, validateValue);
        }
        Date date2 = (Date)object;
        long time = date.getTime();
        if (time == -9223372036832400000L || time == -185543533774800000L) {
            return NEGATIVE_INFINITY_STRING_REPRESENTATION;
        }
        if (time == 9223372036825200000L || time == 185543533774800000L) {
            return POSITIVE_INFINITY_STRING_REPRESENTATION;
        }
        return super.getValueFromObject(session, type, object, copy, validateValue);
    }

    protected boolean isReadDateAsObject() {
        return true;
    }

    public void bindValueObject(@NotNull DBCSession session, @NotNull DBCStatement statement, @NotNull DBSTypedObject type, int index, Object value) throws DBCException {
        if (value instanceof String) {
            try {
                ((JDBCPreparedStatement)statement).setObject(index + 1, (Object)value.toString(), ((PostgreDataSource)session.getDataSource()).getServerType().getParameterBindType(type, value));
            }
            catch (SQLException e) {
                throw new DBCException(ModelMessages.model_jdbc_exception_could_not_bind_statement_parameter, (Throwable)e);
            }
            return;
        }
        super.bindValueObject(session, statement, type, index, value);
    }

    @NotNull
    protected String getFormatterId(DBSTypedObject column) {
        switch (column.getTypeName()) {
            case "timetz": {
                return "timetz";
            }
            case "timestamptz": {
                return "timestamptz";
            }
        }
        return super.getFormatterId(column);
    }
}

