/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.driver;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBIconComposite;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceProvider;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DatabaseURL;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.connection.DBPAuthModelDescriptor;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.connection.DBPDriverLibraryProvider;
import org.jkiss.dbeaver.model.connection.DBPDriverLoader;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocationManager;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.impl.ProviderPropertyDescriptor;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.model.runtime.OSDescriptor;
import org.jkiss.dbeaver.model.sql.SQLDialectMetadata;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.NativeClientDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverFileSource;
import org.jkiss.dbeaver.registry.driver.DriverLibraryAbstract;
import org.jkiss.dbeaver.registry.driver.DriverLibraryLocal;
import org.jkiss.dbeaver.registry.driver.DriverLibraryMavenArtifact;
import org.jkiss.dbeaver.registry.driver.DriverLoaderDescriptor;
import org.jkiss.dbeaver.registry.driver.RemoteNativeClientLocation;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public class DriverDescriptor
extends AbstractDescriptor
implements DBPDriver {
    private static final Log log = Log.getLog(DriverDescriptor.class);
    private static final String PROP_DRIVERS_LOCATION = "DRIVERS_LOCATION";
    private static final String LICENSE_ACCEPT_KEY = "driver.license.accept.";
    public static final DriverDescriptor NULL_DRIVER = new DriverDescriptor("NULL");
    private boolean propagateDriverProperties;
    private boolean origPropagateDriverProperties;
    private final DataSourceProviderDescriptor providerDescriptor;
    private final String id;
    private String category;
    private final List<String> categories;
    private String name;
    private String description;
    private String driverClassName;
    private String driverDefaultHost;
    private String driverDefaultPort;
    private String driverDefaultDatabase;
    private String driverDefaultServer;
    private String driverDefaultUser;
    private String sampleURL;
    private String dialectId;
    private final String origName;
    private final String origDescription;
    private final String origClassName;
    private final String origDefaultHost;
    private final String origDefaultPort;
    private final String origDefaultDatabase;
    private final String origDefaultServer;
    private final String origDefaultUser;
    private final String origSampleURL;
    private String origDialectId;
    private String webURL;
    private String propertiesWebURL;
    private String databaseDocumentationSuffixURL;
    private DBPImage iconPlain;
    private DBPImage iconNormal;
    private DBPImage iconError;
    private DBPImage iconBig;
    private DBPImage logoImage;
    private boolean embedded;
    private boolean origEmbedded;
    private boolean supportsDistributedMode;
    private boolean notAvailableDriver;
    private boolean singleConnection;
    private boolean origThreadSafe;
    private boolean threadSafe;
    private boolean clientRequired;
    private boolean supportsDriverProperties;
    private boolean anonymousAccess;
    private boolean origAnonymousAccess;
    private boolean allowsEmptyPassword;
    private boolean origAllowsEmptyPassword;
    private boolean licenseRequired;
    private boolean customDriverLoader;
    private boolean useURLTemplate;
    private boolean customEndpointInformation;
    private boolean instantiable;
    private boolean origInstantiable;
    private boolean custom;
    private boolean modified;
    private boolean disabled;
    private boolean temporary;
    private int promoted;
    private Set<DBPDriverConfigurationType> configurationTypes = new HashSet<DBPDriverConfigurationType>(Collections.singleton(DBPDriverConfigurationType.MANUAL));
    private Set<String> supportedPageFields = new HashSet<String>(Set.of("host", "port", "database"));
    private final List<DBPNativeClientLocation> nativeClientHomes = new ArrayList<DBPNativeClientLocation>();
    private final List<DriverFileSource> fileSources = new ArrayList<DriverFileSource>();
    private final List<DBPDriverLibrary> libraries = new ArrayList<DBPDriverLibrary>();
    private final List<DBPDriverLibrary> origLibraries = new ArrayList<DBPDriverLibrary>();
    private final List<ProviderPropertyDescriptor> mainPropertyDescriptors = new ArrayList<ProviderPropertyDescriptor>();
    private final Set<ProviderPropertyDescriptor> providerPropertyDescriptors = new LinkedHashSet<ProviderPropertyDescriptor>();
    private final List<OSDescriptor> supportedSystems = new ArrayList<OSDescriptor>();
    private final List<ReplaceInfo> driverReplacements = new ArrayList<ReplaceInfo>();
    private DriverDescriptor replacedBy;
    private String nonAvailabilityTitle;
    private String nonAvailabilityDescription;
    private String nonAvailabilityReason;
    private final Map<String, Object> defaultParameters = new HashMap<String, Object>();
    private final Map<String, Object> customParameters = new HashMap<String, Object>();
    private final Map<String, Object> defaultConnectionProperties = new HashMap<String, Object>();
    private final Map<String, Object> customConnectionProperties = new HashMap<String, Object>();
    private final Map<String, Object> originalConnectionProperties = new HashMap<String, Object>();
    private volatile Map<String, DriverLoaderDescriptor> driverLoaders;
    private volatile boolean loadersInitialized = false;
    private volatile DriverLoaderDescriptor defaultDriverLoader;

    static {
        Path driversHome = DriverDescriptor.getCustomDriversHome();
        if (driversHome != null) {
            System.setProperty(PROP_DRIVERS_LOCATION, driversHome.toAbsolutePath().toString());
        }
    }

    private DriverDescriptor(String id) {
        this(DataSourceProviderDescriptor.NULL_PROVIDER, id);
    }

    public DriverDescriptor(DataSourceProviderDescriptor providerDescriptor, String id) {
        this(providerDescriptor, id, null);
    }

    public DriverDescriptor(DataSourceProviderDescriptor providerDescriptor, String id, DriverDescriptor copyFrom) {
        super(providerDescriptor.getPluginId());
        this.providerDescriptor = providerDescriptor;
        this.id = id;
        this.custom = true;
        this.useURLTemplate = true;
        this.customEndpointInformation = false;
        this.instantiable = true;
        this.promoted = 0;
        this.origThreadSafe = true;
        this.threadSafe = true;
        this.supportsDistributedMode = true;
        this.notAvailableDriver = false;
        this.origName = null;
        this.origDescription = null;
        this.origClassName = null;
        this.origDefaultHost = null;
        this.origDefaultPort = null;
        this.origDefaultDatabase = null;
        this.origDefaultServer = null;
        this.origDefaultUser = null;
        this.origSampleURL = null;
        this.origDialectId = null;
        if (copyFrom != null) {
            this.iconPlain = copyFrom.iconPlain;
            this.iconBig = copyFrom.iconBig;
        } else {
            this.iconPlain = providerDescriptor.getIcon();
            this.iconBig = DBIcon.DATABASE_BIG_DEFAULT;
        }
        if (this.iconPlain == null) {
            this.iconPlain = DBIcon.DATABASE_DEFAULT;
        }
        this.makeIconExtensions();
        if (copyFrom != null) {
            this.category = copyFrom.category;
            this.categories = new ArrayList<String>(copyFrom.categories);
            this.name = copyFrom.name;
            this.description = copyFrom.description;
            this.driverClassName = copyFrom.driverClassName;
            this.driverDefaultHost = copyFrom.driverDefaultHost;
            this.driverDefaultPort = copyFrom.driverDefaultPort;
            this.driverDefaultDatabase = copyFrom.driverDefaultDatabase;
            this.driverDefaultServer = copyFrom.driverDefaultServer;
            this.driverDefaultUser = copyFrom.driverDefaultUser;
            this.sampleURL = copyFrom.sampleURL;
            this.dialectId = copyFrom.dialectId;
            this.webURL = copyFrom.webURL;
            this.propertiesWebURL = copyFrom.webURL;
            this.databaseDocumentationSuffixURL = copyFrom.databaseDocumentationSuffixURL;
            this.embedded = copyFrom.embedded;
            this.propagateDriverProperties = copyFrom.propagateDriverProperties;
            this.singleConnection = copyFrom.singleConnection;
            this.threadSafe = copyFrom.threadSafe;
            this.clientRequired = copyFrom.clientRequired;
            this.supportsDriverProperties = copyFrom.supportsDriverProperties;
            this.anonymousAccess = copyFrom.anonymousAccess;
            this.allowsEmptyPassword = copyFrom.allowsEmptyPassword;
            this.licenseRequired = copyFrom.licenseRequired;
            this.customDriverLoader = copyFrom.customDriverLoader;
            this.useURLTemplate = copyFrom.useURLTemplate;
            this.customEndpointInformation = copyFrom.customEndpointInformation;
            this.instantiable = copyFrom.instantiable;
            this.promoted = copyFrom.promoted;
            this.nativeClientHomes.addAll(copyFrom.nativeClientHomes);
            for (DriverFileSource fs : copyFrom.fileSources) {
                this.fileSources.add(new DriverFileSource(fs));
            }
            for (DBPDriverLibrary library : copyFrom.libraries) {
                if (library instanceof DriverLibraryAbstract) {
                    this.libraries.add(((DriverLibraryAbstract)library).copyLibrary(this));
                    continue;
                }
                this.libraries.add(library);
            }
            this.mainPropertyDescriptors.addAll(copyFrom.mainPropertyDescriptors);
            this.providerPropertyDescriptors.addAll(copyFrom.providerPropertyDescriptors);
            this.defaultParameters.putAll(copyFrom.defaultParameters);
            this.customParameters.putAll(copyFrom.customParameters);
            this.defaultConnectionProperties.putAll(copyFrom.defaultConnectionProperties);
            this.customConnectionProperties.putAll(copyFrom.customConnectionProperties);
            this.configurationTypes.addAll(copyFrom.configurationTypes);
            this.supportedPageFields.addAll(copyFrom.supportedPageFields);
            this.supportsDistributedMode = copyFrom.supportsDistributedMode;
            this.notAvailableDriver = copyFrom.notAvailableDriver;
            this.nonAvailabilityTitle = copyFrom.nonAvailabilityTitle;
            this.nonAvailabilityDescription = copyFrom.nonAvailabilityDescription;
            this.nonAvailabilityReason = copyFrom.nonAvailabilityReason;
        } else {
            this.categories = new ArrayList<String>();
            this.name = "";
        }
    }

    public DriverDescriptor(DataSourceProviderDescriptor providerDescriptor, IConfigurationElement config) {
        super(providerDescriptor.getPluginId());
        IConfigurationElement[] notAvailable;
        IConfigurationElement[] replaceElements;
        IConfigurationElement[] propElements;
        String paramValue;
        String paramName;
        IConfigurationElement[] paramElements;
        String logoImageAttr;
        String[] supportedPageFields;
        this.providerDescriptor = providerDescriptor;
        this.id = CommonUtils.notEmpty((String)config.getAttribute("id"));
        this.category = config.getAttribute("category");
        this.categories = Arrays.asList(CommonUtils.split((String)config.getAttribute("categories"), (String)","));
        this.origName = this.name = CommonUtils.notEmpty((String)config.getAttribute("label"));
        this.origDescription = this.description = config.getAttribute("description");
        this.origClassName = this.driverClassName = config.getAttribute("class");
        this.origDefaultHost = this.driverDefaultHost = config.getAttribute("defaultHost");
        this.origDefaultPort = this.driverDefaultPort = config.getAttribute("defaultPort");
        this.origDefaultDatabase = this.driverDefaultDatabase = config.getAttribute("defaultDatabase");
        this.origDefaultServer = this.driverDefaultServer = config.getAttribute("defaultServer");
        this.origDefaultUser = this.driverDefaultUser = config.getAttribute("defaultUser");
        this.origSampleURL = this.sampleURL = config.getAttribute("sampleURL");
        this.origDialectId = this.dialectId = config.getAttribute("dialect");
        this.webURL = config.getAttribute("webURL");
        this.databaseDocumentationSuffixURL = config.getAttribute("databaseDocumentationSuffixURL");
        this.propertiesWebURL = config.getAttribute("propertiesURL");
        this.clientRequired = CommonUtils.getBoolean((String)config.getAttribute("clientRequired"), (boolean)false);
        this.customDriverLoader = CommonUtils.getBoolean((String)config.getAttribute("customDriverLoader"), (boolean)false);
        this.useURLTemplate = CommonUtils.getBoolean((String)config.getAttribute("useURL"), (boolean)true);
        this.customEndpointInformation = CommonUtils.getBoolean((String)config.getAttribute("customEndpoint"), (boolean)false);
        this.promoted = CommonUtils.toInt((Object)config.getAttribute("promoted"), (int)0);
        this.supportsDriverProperties = CommonUtils.getBoolean((String)config.getAttribute("supportsDriverProperties"), (boolean)true);
        this.origInstantiable = this.instantiable = CommonUtils.getBoolean((String)config.getAttribute("instantiable"), (boolean)true);
        this.origEmbedded = this.embedded = CommonUtils.getBoolean((String)config.getAttribute("embedded"));
        this.singleConnection = CommonUtils.getBoolean((String)config.getAttribute("singleConnection"));
        this.origThreadSafe = this.threadSafe = CommonUtils.getBoolean((String)config.getAttribute("threadSafe"), (boolean)true);
        this.origAnonymousAccess = this.anonymousAccess = CommonUtils.getBoolean((String)config.getAttribute("anonymous"));
        this.origAllowsEmptyPassword = this.allowsEmptyPassword = CommonUtils.getBoolean((String)config.getAttribute("allowsEmptyPassword"));
        this.origPropagateDriverProperties = this.propagateDriverProperties = CommonUtils.getBoolean((String)config.getAttribute("propagateDriverProperties"));
        this.licenseRequired = CommonUtils.getBoolean((String)config.getAttribute("licenseRequired"));
        this.supportsDistributedMode = CommonUtils.getBoolean((String)config.getAttribute("supportsDistributedMode"), (boolean)true);
        this.custom = false;
        IConfigurationElement[] iConfigurationElementArray = config.getChildren("file");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement lib = iConfigurationElementArray[n2];
            DriverLibraryAbstract library = DriverLibraryAbstract.createFromConfig(this, lib);
            if (library != null) {
                this.libraries.add(library);
            }
            ++n2;
        }
        this.origLibraries.addAll(this.libraries);
        String[] supportedConfigurationTypes = CommonUtils.split((String)config.getAttribute("supportedConfigurationTypes"), (String)",");
        if (supportedConfigurationTypes.length > 0) {
            this.configurationTypes = Stream.of(supportedConfigurationTypes).map(DBPDriverConfigurationType::valueOf).collect(Collectors.toSet());
        }
        if ((supportedPageFields = CommonUtils.split((String)config.getAttribute("supportedPageFields"), (String)",")).length > 0) {
            this.supportedPageFields = Stream.of(supportedPageFields).collect(Collectors.toSet());
        }
        IConfigurationElement[] iConfigurationElementArray2 = config.getChildren("fileSource");
        int library = iConfigurationElementArray2.length;
        int n3 = 0;
        while (n3 < library) {
            IConfigurationElement lib = iConfigurationElementArray2[n3];
            this.fileSources.add(new DriverFileSource(lib));
            ++n3;
        }
        this.iconPlain = this.iconToImage(config.getAttribute("icon"));
        if (this.iconPlain == null) {
            this.iconPlain = providerDescriptor.getIcon();
        }
        this.iconBig = this.iconPlain;
        if (config.getAttribute("iconBig") != null) {
            this.iconBig = this.iconToImage(config.getAttribute("iconBig"));
        }
        if (!CommonUtils.isEmpty((String)(logoImageAttr = config.getAttribute("logoImage")))) {
            this.logoImage = this.iconToImage(logoImageAttr);
        }
        this.makeIconExtensions();
        IConfigurationElement[] iConfigurationElementArray3 = config.getChildren("os");
        int n4 = iConfigurationElementArray3.length;
        library = 0;
        while (library < n4) {
            IConfigurationElement os = iConfigurationElementArray3[library];
            this.supportedSystems.add(new OSDescriptor(os.getAttribute("name"), os.getAttribute("arch")));
            ++library;
        }
        Object[] pp = config.getChildren("main-properties");
        if (!ArrayUtils.isEmpty((Object[])pp)) {
            String copyFromDriverId = pp[0].getAttribute("copyFrom");
            if (!CommonUtils.isEmpty((String)copyFromDriverId)) {
                DriverDescriptor copyFromDriver = providerDescriptor.getDriver(copyFromDriverId);
                if (copyFromDriver == null) {
                    log.debug((Object)("Driver '" + copyFromDriverId + "' not found. Cannot copy main properties into '" + this.getId() + "'"));
                } else {
                    this.mainPropertyDescriptors.addAll(copyFromDriver.mainPropertyDescriptors);
                }
            }
            this.mainPropertyDescriptors.addAll(Arrays.stream(pp[0].getChildren("propertyGroup")).map(ProviderPropertyDescriptor::extractProviderProperties).flatMap(Collection::stream).toList());
        }
        if (!ArrayUtils.isEmpty((Object[])(pp = config.getChildren("provider-properties")))) {
            String copyFromDriverId = pp[0].getAttribute("copyFrom");
            if (!CommonUtils.isEmpty((String)copyFromDriverId)) {
                DriverDescriptor copyFromDriver = providerDescriptor.getDriver(copyFromDriverId);
                if (copyFromDriver == null) {
                    log.debug((Object)("Driver '" + copyFromDriverId + "' not found. Cannot copy provider properties into '" + this.getId() + "'"));
                } else {
                    this.providerPropertyDescriptors.addAll(copyFromDriver.providerPropertyDescriptors);
                }
            }
            this.providerPropertyDescriptors.addAll(Arrays.stream(pp[0].getChildren("propertyGroup")).map(ProviderPropertyDescriptor::extractProviderProperties).flatMap(Collection::stream).toList());
        }
        IConfigurationElement[] iConfigurationElementArray4 = paramElements = config.getChildren("parameter");
        int n5 = paramElements.length;
        int n6 = 0;
        while (n6 < n5) {
            IConfigurationElement param = iConfigurationElementArray4[n6];
            paramName = param.getAttribute("name");
            paramValue = param.getAttribute("value");
            if (CommonUtils.isEmpty((String)paramValue)) {
                paramValue = param.getValue();
            }
            if (!CommonUtils.isEmpty((String)paramName) && !CommonUtils.isEmpty((String)paramValue)) {
                this.setDriverParameter(paramName, paramValue, true);
            }
            ++n6;
        }
        iConfigurationElementArray4 = propElements = config.getChildren("property");
        n5 = propElements.length;
        n6 = 0;
        while (n6 < n5) {
            IConfigurationElement param = iConfigurationElementArray4[n6];
            paramName = param.getAttribute("name");
            paramValue = param.getAttribute("value");
            if (CommonUtils.isEmpty((String)paramValue)) {
                paramValue = param.getValue();
            }
            if (!CommonUtils.isEmpty((String)paramName) && !CommonUtils.isEmpty((String)paramValue)) {
                this.defaultConnectionProperties.put(paramName, paramValue);
                if (!paramName.startsWith("@dbeaver-")) {
                    this.customConnectionProperties.put(paramName, paramValue);
                    this.originalConnectionProperties.put(paramName, paramValue);
                }
            }
            ++n6;
        }
        iConfigurationElementArray4 = replaceElements = config.getChildren("replace");
        n5 = replaceElements.length;
        n6 = 0;
        while (n6 < n5) {
            IConfigurationElement replace = iConfigurationElementArray4[n6];
            String providerId = replace.getAttribute("provider");
            String driverId = replace.getAttribute("driver");
            if (!CommonUtils.isEmpty((String)providerId) && !CommonUtils.isEmpty((String)driverId)) {
                this.driverReplacements.add(new ReplaceInfo(providerId, driverId));
            }
            ++n6;
        }
        iConfigurationElementArray4 = notAvailable = config.getChildren("notAvailableDriver");
        n5 = notAvailable.length;
        n6 = 0;
        while (n6 < n5) {
            IConfigurationElement element = iConfigurationElementArray4[n6];
            this.nonAvailabilityReason = element.getAttribute("message");
            this.nonAvailabilityTitle = element.getAttribute("title");
            this.nonAvailabilityDescription = element.getAttribute("description");
            ++n6;
        }
    }

    Map<String, Object> getDefaultParameters() {
        return this.defaultParameters;
    }

    Map<String, Object> getCustomParameters() {
        return this.customParameters;
    }

    List<DBPNativeClientLocation> getNativeClientHomes() {
        return this.nativeClientHomes;
    }

    public DriverDescriptor getReplacedBy() {
        return this.replacedBy;
    }

    public boolean isNotAvailable() {
        return this.nonAvailabilityReason != null;
    }

    @NotNull
    public String getNonAvailabilityReason() {
        return this.nonAvailabilityReason;
    }

    @Nullable
    public String getNonAvailabilityTitle() {
        return this.nonAvailabilityTitle;
    }

    @Nullable
    public String getNonAvailabilityDescription() {
        return this.nonAvailabilityDescription;
    }

    public void setReplacedBy(DriverDescriptor replaceBy) {
        this.replacedBy = replaceBy;
    }

    public boolean replaces(DriverDescriptor driver) {
        for (ReplaceInfo replaceInfo : this.driverReplacements) {
            if (!driver.getProviderDescriptor().getId().equals(replaceInfo.providerId) || !driver.getId().equals(replaceInfo.driverId)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<Pair<String, String>> getDriverReplacementsInfo() {
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        for (ReplaceInfo replaceInfo : this.driverReplacements) {
            result.add((Pair<String, String>)new Pair((Object)replaceInfo.providerId, (Object)replaceInfo.driverId));
        }
        return result;
    }

    void makeIconExtensions() {
        this.iconNormal = this.isCustom() ? new DBIconComposite(this.iconPlain, false, null, null, (DBPImage)DBIcon.OVER_LAMP, null) : this.iconPlain;
        this.iconError = new DBIconComposite(this.iconPlain, false, null, null, (DBPImage)(this.isCustom() ? DBIcon.OVER_LAMP : null), (DBPImage)DBIcon.OVER_ERROR);
    }

    @NotNull
    public DataSourceProviderDescriptor getProviderDescriptor() {
        return this.providerDescriptor;
    }

    @NotNull
    public DBPDataSourceProvider getDataSourceProvider() {
        return this.providerDescriptor.getInstance(this);
    }

    @Nullable
    public DBPNativeClientLocationManager getNativeClientManager() {
        DBPDataSourceProvider provider = this.getDataSourceProvider();
        if (provider instanceof DBPNativeClientLocationManager) {
            return (DBPNativeClientLocationManager)provider;
        }
        return null;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getProviderId() {
        return this.providerDescriptor.getId();
    }

    @Property(viewable=true, order=2)
    @Nullable
    public String getCategory() {
        return this.category;
    }

    public void setCategory(@Nullable String category) {
        this.category = CommonUtils.nullIfEmpty((String)category);
    }

    @NotNull
    public List<String> getCategories() {
        return new ArrayList<String>(this.categories);
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Property(viewable=true, length=PropertyLength.MULTILINE, order=100)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @NotNull
    public String getFullName() {
        if (CommonUtils.isEmpty((String)this.category) || this.name.contains(this.category)) {
            return this.name;
        }
        return this.category + " / " + this.name;
    }

    @NotNull
    public DBPImage getPlainIcon() {
        return this.iconPlain;
    }

    void setIconPlain(DBPImage iconPlain) {
        this.iconPlain = iconPlain;
    }

    @NotNull
    public DBPImage getIcon() {
        DriverLoaderDescriptor loader = this.getDefaultDriverLoader();
        if (!loader.isLoaded() && loader.isFailed()) {
            return this.iconError;
        }
        return this.iconNormal;
    }

    @NotNull
    public DBPImage getIconBig() {
        return this.iconBig;
    }

    @Nullable
    public DBPImage getLogoImage() {
        return this.logoImage;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public void setCustom(boolean custom) {
        this.custom = custom;
    }

    public boolean isModified() {
        return !this.isTemporary() && this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Property(viewable=true, order=2)
    @Nullable
    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        if (this.driverClassName == null || !this.driverClassName.equals(driverClassName)) {
            this.driverClassName = driverClassName;
            this.resetDriverInstance();
        }
    }

    @Nullable
    public String getDefaultHost() {
        return this.driverDefaultHost;
    }

    public void setDriverDefaultHost(String driverDefaultHost) {
        this.driverDefaultHost = driverDefaultHost;
    }

    @Nullable
    public String getDefaultPort() {
        return this.driverDefaultPort;
    }

    public void setDriverDefaultPort(String driverDefaultPort) {
        this.driverDefaultPort = driverDefaultPort;
    }

    @Nullable
    public String getDefaultDatabase() {
        return this.driverDefaultDatabase;
    }

    public void setDriverDefaultDatabase(String driverDefaultDatabase) {
        this.driverDefaultDatabase = driverDefaultDatabase;
    }

    @Nullable
    public String getDefaultServer() {
        return this.driverDefaultServer;
    }

    public void setDriverDefaultServer(String driverDefaultServer) {
        this.driverDefaultServer = driverDefaultServer;
    }

    @Nullable
    public String getDefaultUser() {
        return this.driverDefaultUser;
    }

    public void setDriverDefaultUser(String driverDefaultUser) {
        this.driverDefaultUser = driverDefaultUser;
    }

    @Property(viewable=true, order=3)
    @Nullable
    public String getSampleURL() {
        return this.sampleURL;
    }

    public void setSampleURL(String sampleURL) {
        this.sampleURL = sampleURL;
    }

    @Nullable
    public String getWebURL() {
        return this.webURL;
    }

    @Nullable
    public String getPropertiesWebURL() {
        return this.propertiesWebURL;
    }

    @Nullable
    public String getDatabaseDocumentationSuffixURL() {
        return this.databaseDocumentationSuffixURL;
    }

    @NotNull
    public SQLDialectMetadata getScriptDialect() {
        if (!CommonUtils.isEmpty((String)this.dialectId)) {
            SQLDialectMetadata dialect = DBWorkbench.getPlatform().getSQLDialectRegistry().getDialect(this.dialectId);
            if (dialect != null) {
                return dialect;
            }
            log.debug((Object)("SQL dialect '" + this.dialectId + "' not found for driver '" + this.getFullId() + "'. Using default dialect."));
        }
        return this.providerDescriptor.getScriptDialect();
    }

    public boolean isClientRequired() {
        return this.clientRequired;
    }

    public boolean supportsDriverProperties() {
        return this.supportsDriverProperties;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public void setEmbedded(boolean embedded) {
        this.embedded = embedded;
    }

    public boolean isPropagateDriverProperties() {
        return this.propagateDriverProperties;
    }

    public void setPropagateDriverProperties(boolean propagateDriverProperties) {
        this.propagateDriverProperties = propagateDriverProperties;
    }

    public boolean isSingleConnection() {
        return this.singleConnection;
    }

    public boolean isThreadSafeDriver() {
        return this.threadSafe;
    }

    public void setThreadSafeDriver(boolean threadSafe) {
        this.threadSafe = threadSafe;
    }

    public boolean isOrigThreadSafeDriver() {
        return this.origThreadSafe;
    }

    public boolean isAnonymousAccess() {
        return this.anonymousAccess;
    }

    public void setAnonymousAccess(boolean anonymousAccess) {
        this.anonymousAccess = anonymousAccess;
    }

    public boolean isAllowsEmptyPassword() {
        return this.allowsEmptyPassword;
    }

    public void setAllowsEmptyPassword(boolean allowsEmptyPassword) {
        this.allowsEmptyPassword = allowsEmptyPassword;
    }

    public boolean isLicenseRequired() {
        return this.licenseRequired;
    }

    public boolean isCustomDriverLoader() {
        return this.customDriverLoader;
    }

    void setCustomDriverLoader(boolean customDriverLoader) {
        this.customDriverLoader = customDriverLoader;
    }

    public boolean isSampleURLApplicable() {
        return this.useURLTemplate;
    }

    public boolean isCustomEndpointInformation() {
        return this.customEndpointInformation;
    }

    void setUseURL(boolean useURLTemplate) {
        this.useURLTemplate = useURLTemplate;
    }

    public int getPromotedScore() {
        return this.promoted;
    }

    public boolean isInstantiable() {
        return this.instantiable;
    }

    public void setInstantiable(boolean instantiable) {
        this.instantiable = instantiable;
    }

    public boolean isTemporary() {
        return this.temporary || this.providerDescriptor.isTemporary();
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    @Nullable
    public DBXTreeNode getNavigatorRoot() {
        return this.providerDescriptor.getTreeDescriptor();
    }

    public boolean isManagable() {
        return this.getProviderDescriptor().isDriversManagable();
    }

    public boolean isInternalDriver() {
        return this.driverClassName != null && this.driverClassName.contains("sun.jdbc");
    }

    @NotNull
    public List<DBPNativeClientLocation> getNativeClientLocations() {
        ArrayList<DBPNativeClientLocation> ids = new ArrayList<DBPNativeClientLocation>();
        for (NativeClientDescriptor nc : this.getProviderDescriptor().getNativeClients()) {
            if (nc.findDistribution() == null) continue;
            ids.add(new RemoteNativeClientLocation(nc));
        }
        ids.addAll(this.nativeClientHomes);
        return ids;
    }

    public void setNativeClientLocations(Collection<DBPNativeClientLocation> locations) {
        this.nativeClientHomes.clear();
        this.nativeClientHomes.addAll(locations);
    }

    void addNativeClientLocation(DBPNativeClientLocation location) {
        if (!this.nativeClientHomes.contains(location)) {
            this.nativeClientHomes.add(location);
        }
    }

    @NotNull
    public List<? extends DBPDriverLibrary> getDriverLibraries() {
        return this.libraries;
    }

    public void setDriverLibraries(List<? extends DBPDriverLibrary> libs) {
        ArrayList<DBPDriverLibrary> deletedLibs = new ArrayList<DBPDriverLibrary>();
        for (DBPDriverLibrary dBPDriverLibrary : this.libraries) {
            if (dBPDriverLibrary.isCustom() || libs.contains(dBPDriverLibrary)) continue;
            dBPDriverLibrary.setDisabled(true);
            deletedLibs.add(dBPDriverLibrary);
        }
        for (DBPDriverLibrary dBPDriverLibrary : libs) {
            dBPDriverLibrary.setDisabled(false);
        }
        this.libraries.clear();
        this.libraries.addAll(deletedLibs);
        this.libraries.addAll(libs);
    }

    public List<DBPDriverLibrary> getEnabledDriverLibraries() {
        ArrayList<DBPDriverLibrary> filtered = new ArrayList<DBPDriverLibrary>();
        for (DBPDriverLibrary lib : this.libraries) {
            if (lib.isDisabled()) continue;
            filtered.add(lib);
        }
        return filtered;
    }

    public DBPDriverLibrary getDriverLibrary(String path) {
        for (DBPDriverLibrary lib : this.libraries) {
            if (!lib.getPath().equals(path)) continue;
            return lib;
        }
        return null;
    }

    public DBPDriverLibrary addDriverLibrary(String path, DBPDriverLibrary.FileType fileType) {
        DBPDriverLibrary lib2;
        for (DBPDriverLibrary lib2 : this.libraries) {
            if (!lib2.getPath().equals(path)) continue;
            return lib2;
        }
        lib2 = DriverLibraryAbstract.createFromPath(this, fileType, path, null);
        this.addDriverLibrary(lib2, true);
        return lib2;
    }

    public boolean addDriverLibrary(DBPDriverLibrary descriptor, boolean resetCache) {
        if (resetCache && descriptor instanceof DriverLibraryMavenArtifact) {
            DriverLibraryMavenArtifact mavenLib = (DriverLibraryMavenArtifact)descriptor;
            mavenLib.resetVersion();
            this.resetDriverInstance();
        }
        if (!this.libraries.contains(descriptor)) {
            this.libraries.add(descriptor);
            return true;
        }
        return false;
    }

    public void disabledAllDefaultLibraries() {
        this.libraries.stream().filter(s -> !s.isCustom()).forEach(libr -> libr.setDisabled(true));
    }

    @NotNull
    public List<DriverFileSource> getDriverFileSources() {
        return this.fileSources;
    }

    @NotNull
    public synchronized DriverLoaderDescriptor getDefaultDriverLoader() {
        if (this.defaultDriverLoader == null) {
            this.defaultDriverLoader = new DriverLoaderDescriptor("default", this);
        }
        return this.defaultDriverLoader;
    }

    @NotNull
    public DBPDriverLoader getDriverLoader(@NotNull DBPDataSourceContainer dataSourceContainer) {
        this.getAllDriverLoaders();
        DBPAuthModelDescriptor authModel = dataSourceContainer.getConnectionConfiguration().getAuthModelDescriptor();
        DriverLoaderDescriptor loader = this.driverLoaders.get(authModel.getId());
        if (loader != null) {
            return loader;
        }
        return this.getDefaultDriverLoader();
    }

    @Nullable
    public DriverLoaderDescriptor preCreateDriverLoader(String loaderId) {
        DriverLoaderDescriptor loader;
        if (this.driverLoaders == null) {
            this.driverLoaders = new LinkedHashMap<String, DriverLoaderDescriptor>();
        }
        if ((loader = this.driverLoaders.get(loaderId)) == null) {
            loader = new DriverLoaderDescriptor(loaderId, this);
            this.driverLoaders.put(loaderId, loader);
        }
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<DBPDriverLoader> getAllDriverLoaders() {
        if (!this.loadersInitialized) {
            DriverDescriptor driverDescriptor = this;
            synchronized (driverDescriptor) {
                if (!this.loadersInitialized) {
                    if (this.driverLoaders == null) {
                        this.driverLoaders = new LinkedHashMap<String, DriverLoaderDescriptor>();
                    }
                    for (DBPAuthModelDescriptor dBPAuthModelDescriptor : DataSourceProviderRegistry.getInstance().getApplicableAuthModels(this)) {
                        List driverLibraries = dBPAuthModelDescriptor.getDriverLibraries();
                        if (CommonUtils.isEmpty((Collection)driverLibraries) || this.driverLoaders.containsKey(dBPAuthModelDescriptor.getId())) continue;
                        DriverLoaderDescriptor loader = new DriverLoaderDescriptor(dBPAuthModelDescriptor.getId(), this);
                        loader.addLibraryProvider((DBPDriverLibraryProvider)dBPAuthModelDescriptor);
                        this.driverLoaders.put(dBPAuthModelDescriptor.getId(), loader);
                    }
                }
            }
        }
        ArrayList<DBPDriverLoader> loaders = new ArrayList<DBPDriverLoader>();
        loaders.add(this.getDefaultDriverLoader());
        loaders.addAll(this.driverLoaders.values());
        return loaders;
    }

    public void validateFilesPresence(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer dataSourceContainer) throws DBException {
        this.getDriverLoader(dataSourceContainer).validateFilesPresence(monitor);
    }

    public void resetDriverInstance() {
        for (DBPDriverLoader dld : this.getAllDriverLoaders()) {
            ((DriverLoaderDescriptor)dld).resetDriverInstance();
        }
    }

    @NotNull
    public DBPPropertyDescriptor[] getMainPropertyDescriptors() {
        return this.mainPropertyDescriptors.toArray(new DBPPropertyDescriptor[0]);
    }

    public void addMainPropertyDescriptors(Collection<ProviderPropertyDescriptor> props) {
        this.mainPropertyDescriptors.addAll(props);
    }

    @NotNull
    public ProviderPropertyDescriptor[] getProviderPropertyDescriptors() {
        return this.providerPropertyDescriptors.toArray(new ProviderPropertyDescriptor[0]);
    }

    public void addProviderPropertyDescriptors(Collection<ProviderPropertyDescriptor> props) {
        this.providerPropertyDescriptors.addAll(props);
    }

    @NotNull
    public Map<String, Object> getDefaultConnectionProperties() {
        return this.defaultConnectionProperties;
    }

    @NotNull
    public Map<String, Object> getConnectionProperties() {
        return this.customConnectionProperties;
    }

    @NotNull
    private Map<String, Object> getOriginalConnectionProperties() {
        return this.originalConnectionProperties;
    }

    public void setConnectionProperty(String name, String value) {
        this.customConnectionProperties.put(name, value);
    }

    public void setConnectionProperties(Map<String, Object> parameters) {
        this.customConnectionProperties.clear();
        this.customConnectionProperties.putAll(parameters);
    }

    public Map<String, Object> getDefaultDriverParameters() {
        return this.defaultParameters;
    }

    @NotNull
    public Map<String, Object> getDriverParameters() {
        return this.customParameters;
    }

    @Nullable
    public Object getDriverParameter(String name) {
        DBPPropertyDescriptor defProperty;
        Object value = this.customParameters.get(name);
        if (value == null && (defProperty = this.providerDescriptor.getDriverProperty(name)) != null) {
            return defProperty.getDefaultValue();
        }
        return value;
    }

    public void setDriverParameter(String name, String value, boolean setDefault) {
        DBPPropertyDescriptor prop = this.getProviderDescriptor().getDriverProperty(name);
        String valueObject = prop == null ? value : GeneralUtils.convertString((String)value, (Class)prop.getDataType());
        this.customParameters.put(name, valueObject);
        if (setDefault) {
            this.defaultParameters.put(name, valueObject);
        }
    }

    public void setDriverParameters(Map<String, Object> parameters) {
        this.customParameters.clear();
        this.customParameters.putAll(parameters);
    }

    public boolean isSupportedByLocalSystem() {
        if (DBWorkbench.isDistributed() || DBWorkbench.getPlatform().getApplication().isMultiuser()) {
            return this.supportsDistributedMode;
        }
        if (this.supportedSystems.isEmpty()) {
            return true;
        }
        OSDescriptor localSystem = DBWorkbench.getPlatform().getLocalSystem();
        for (OSDescriptor system : this.supportedSystems) {
            if (!system.matches(localSystem)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public String getLicense() {
        for (DBPDriverLibrary file : this.libraries) {
            Path licenseFile;
            if (file.getType() != DBPDriverLibrary.FileType.license || (licenseFile = file.getLocalFile()) == null || !Files.exists(licenseFile, new LinkOption[0])) continue;
            try {
                return new String(Files.readAllBytes(licenseFile));
            }
            catch (IOException e) {
                log.warn((Object)e);
            }
        }
        return null;
    }

    public boolean isSampleURLForced() {
        return this.isSampleURLApplicable() && !CommonUtils.equalObjects((Object)this.sampleURL, (Object)this.origSampleURL);
    }

    @Nullable
    public String getConnectionURL(@NotNull DBPConnectionConfiguration connectionInfo) {
        if (connectionInfo.getConfigurationType() == DBPDriverConfigurationType.URL) {
            return connectionInfo.getUrl();
        }
        if (this.isSampleURLForced()) {
            return DatabaseURL.generateUrlByTemplate((DBPDriver)this, (DBPConnectionConfiguration)connectionInfo);
        }
        return this.getDataSourceProvider().getConnectionURL((DBPDriver)this, connectionInfo);
    }

    @NotNull
    public DBPDriver createOriginalCopy() {
        DriverDescriptor driverCopy = this.getProviderDescriptor().createDriver(this);
        for (DBPDriverLibrary lib : this.origLibraries) {
            if (!(lib instanceof DriverLibraryLocal) || lib.isCustom()) continue;
            DBPDriverLibrary libCopy = ((DriverLibraryLocal)lib).copyLibrary(this);
            libCopy.setDisabled(false);
            if (libCopy instanceof DriverLibraryLocal) {
                ((DriverLibraryLocal)libCopy).setUseOriginalJar(true);
            }
            driverCopy.libraries.add(libCopy);
        }
        driverCopy.setName(this.getOrigName());
        driverCopy.setDescription(this.getOrigDescription());
        driverCopy.setDriverClassName(this.getOrigClassName());
        driverCopy.setSampleURL(this.getOrigSampleURL());
        driverCopy.setDriverDefaultHost(this.getDefaultHost());
        driverCopy.setDriverDefaultPort(this.getDefaultPort());
        driverCopy.setDriverDefaultDatabase(this.getDefaultDatabase());
        driverCopy.setDriverDefaultUser(this.getDefaultUser());
        driverCopy.setConnectionProperties(this.getOriginalConnectionProperties());
        driverCopy.setThreadSafeDriver(this.isOrigThreadSafeDriver());
        return driverCopy;
    }

    boolean acceptLicense(String licenseText) {
        DBPPreferenceStore prefs = DBWorkbench.getPlatform().getPreferenceStore();
        String acceptedStr = prefs.getString(LICENSE_ACCEPT_KEY + this.getId());
        if (!CommonUtils.isEmpty((String)acceptedStr)) {
            return true;
        }
        if (DBWorkbench.getPlatformUI().acceptLicense("You have to accept license of '" + this.getFullName() + " ' to continue", licenseText)) {
            prefs.setValue(LICENSE_ACCEPT_KEY + this.getId(), "true:" + System.currentTimeMillis() + ":" + System.getProperty("user.name"));
            return true;
        }
        return false;
    }

    public String getOrigName() {
        return this.origName;
    }

    public String getOrigDescription() {
        return this.origDescription;
    }

    public String getOrigClassName() {
        return this.origClassName;
    }

    public String getOrigDefaultPort() {
        return this.origDefaultPort;
    }

    public String getOrigDefaultDatabase() {
        return this.origDefaultDatabase;
    }

    public String getOrigDefaultServer() {
        return this.origDefaultServer;
    }

    public String getOrigDefaultUser() {
        return this.origDefaultUser;
    }

    public String getOrigSampleURL() {
        return this.origSampleURL;
    }

    public boolean isOrigEmbedded() {
        return this.origEmbedded;
    }

    public boolean isOrigPropagateDriverProperties() {
        return this.origPropagateDriverProperties;
    }

    public boolean isOrigAnonymousAccess() {
        return this.origAnonymousAccess;
    }

    public boolean isOrigAllowsEmptyPassword() {
        return this.origAllowsEmptyPassword;
    }

    public boolean isOrigInstantiable() {
        return this.origInstantiable;
    }

    public List<DBPDriverLibrary> getOrigLibraries() {
        return this.origLibraries;
    }

    @NotNull
    public Set<DBPDriverConfigurationType> getSupportedConfigurationTypes() {
        return this.configurationTypes;
    }

    @NotNull
    public Set<String> getSupportedPageFields() {
        return this.supportedPageFields;
    }

    public boolean isSupportsDistributedMode() {
        return this.supportsDistributedMode;
    }

    public void setSupportsDistributedMode(boolean supportsDistributedMode) {
        this.supportsDistributedMode = supportsDistributedMode;
    }

    public DBPNativeClientLocation getDefaultClientLocation() {
        DBPNativeClientLocationManager clientManager = this.getNativeClientManager();
        if (clientManager != null) {
            return clientManager.getDefaultLocalClientLocation();
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    @NotNull
    public static Path getExternalDriversStorageFolder() {
        DBPPlatform platform = DBWorkbench.getPlatform();
        if (platform.getApplication().isMultiuser()) {
            try {
                return platform.getTempFolder((DBRProgressMonitor)new LoggingProgressMonitor(), "data").resolve("libraries");
            }
            catch (IOException e) {
                throw new RuntimeException("Error getting drivers temp folder", e);
            }
        }
        Path customFolder = DriverDescriptor.getCustomDriversHome();
        String distributedFolderName = platform.getApplication().defaultDistributedDriversFolderName();
        if (distributedFolderName != null) {
            customFolder = customFolder.resolve(distributedFolderName);
        }
        return customFolder;
    }

    public static Path getWorkspaceDriversStorageFolder() {
        return DBWorkbench.getPlatform().getWorkspace().getAbsolutePath().resolve("data").resolve("libraries");
    }

    public static Path getProvidedDriversStorageFolder() {
        return DBWorkbench.getPlatform().getWorkspace().getMetadataFolder().resolve("drivers");
    }

    public static Path getDriversContribFolder() throws IOException {
        return Path.of(Platform.getInstallLocation().getDataArea("drivers").toExternalForm(), new String[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static Path getCustomDriversHome() {
        Path homeFolder;
        block7: {
            DBPPlatform platform = DBWorkbench.getPlatform();
            String driversHome = platform.getPreferenceStore().getString("ui.drivers.home");
            if (!CommonUtils.isEmpty((String)driversHome)) {
                homeFolder = Path.of(driversHome, new String[0]);
            } else {
                if (platform.getWorkspace().getAbsolutePath().getParent() == null) {
                    homeFolder = platform.getApplication().getDefaultWorkingFolder();
                    if (homeFolder != null && homeFolder.getParent() != null) {
                        homeFolder = homeFolder.getParent().resolve("drivers");
                        break block7;
                    } else {
                        log.warn((Object)"Can't find folder path for drivers. Use home folder");
                        return RuntimeUtils.getUserHomeDir().toPath().resolve("drivers");
                    }
                }
                homeFolder = platform.getWorkspace().getAbsolutePath().getParent().resolve("drivers");
            }
        }
        if (Files.exists(homeFolder, new LinkOption[0])) return homeFolder;
        try {
            Files.createDirectories(homeFolder, new FileAttribute[0]);
            return homeFolder;
        }
        catch (IOException e) {
            log.warn((Object)("Can't create drivers folder '" + String.valueOf(homeFolder.toAbsolutePath()) + "'"), (Throwable)e);
        }
        return homeFolder;
    }

    @NotNull
    public static String[] getDriversSources() {
        String sourcesString = DBWorkbench.getPlatform().getPreferenceStore().getString("ui.drivers.sources");
        List pathList = CommonUtils.splitString((String)sourcesString, (char)'|');
        return pathList.toArray(new String[0]);
    }

    @NotNull
    public static String getDriversPrimarySource() {
        String sourcesString = DBWorkbench.getPlatform().getPreferenceStore().getString("ui.drivers.sources");
        int divPos = sourcesString.indexOf(124);
        return divPos == -1 ? sourcesString : sourcesString.substring(0, divPos);
    }

    @NotNull
    public static String[] getGlobalLibraries() {
        String librariesString = DBWorkbench.getPlatform().getPreferenceStore().getString("ui.drivers.global.libraries");
        ArrayList<String> libraries = new ArrayList<String>();
        for (String library : CommonUtils.splitString((String)librariesString, (char)'|')) {
            try {
                libraries.add(URLDecoder.decode(library, GeneralUtils.UTF8_ENCODING));
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)e);
            }
        }
        return libraries.toArray(new String[0]);
    }

    public boolean matchesId(@NotNull String driverId) {
        if (driverId.equals(this.id)) {
            return true;
        }
        for (ReplaceInfo replace : this.driverReplacements) {
            if (!driverId.equals(replace.driverId)) continue;
            return true;
        }
        return false;
    }

    private static class ReplaceInfo {
        String providerId;
        String driverId;

        private ReplaceInfo(String providerId, String driverId) {
            this.providerId = providerId;
            this.driverId = driverId;
        }
    }
}

