/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.select;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryRowsTableValueModel
extends SQLQueryRowsSourceModel {
    @NotNull
    private final List<SQLQueryValueExpression> values;
    private final boolean isIncomplete;

    public SQLQueryRowsTableValueModel(@NotNull STMTreeNode syntaxNode, @NotNull List<SQLQueryValueExpression> values, boolean isIncomplete) {
        super(syntaxNode, new SQLQueryNodeModel[0]);
        this.values = values;
        this.isIncomplete = isIncomplete;
    }

    @NotNull
    public List<SQLQueryValueExpression> getValues() {
        return this.values;
    }

    @Override
    @NotNull
    protected SQLQueryDataContext propagateContextImpl(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        LinkedList<SQLQueryResultColumn> resultColumns = new LinkedList<SQLQueryResultColumn>();
        for (SQLQueryValueExpression value : this.values) {
            value.propagateContext(context, statistics);
            resultColumns.addLast(new SQLQueryResultColumn(resultColumns.size(), new SQLQuerySymbol("?"), this, null, null, SQLQueryExprType.UNKNOWN));
        }
        context = context.hideSources().overrideResultTuple(this, List.copyOf(resultColumns), Collections.emptyList());
        if (this.isIncomplete) {
            context = context.markHasUnresolvedSource();
        }
        return context;
    }

    @Override
    protected SQLQueryRowsSourceContext resolveRowSourcesImpl(@NotNull SQLQueryRowsSourceContext context, @NotNull SQLQueryRecognitionContext statistics) {
        return context.reset();
    }

    @Override
    protected SQLQueryRowsDataContext resolveRowDataImpl(@NotNull SQLQueryRowsDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        LinkedList<SQLQueryResultColumn> resultColumns = new LinkedList<SQLQueryResultColumn>();
        SQLQueryRowsDataContext emptyTuple = this.getRowsSources().makeEmptyTuple();
        for (SQLQueryValueExpression value : this.values) {
            value.resolveRowSources(this.getRowsSources(), statistics);
            value.resolveValueRelations(emptyTuple, statistics);
            resultColumns.addLast(new SQLQueryResultColumn(resultColumns.size(), new SQLQuerySymbol("?"), this, null, null, SQLQueryExprType.UNKNOWN));
        }
        return this.getRowsSources().makeTuple(this, List.copyOf(resultColumns), Collections.emptyList());
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitRowsTableValue(this, arg);
    }
}

