/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.expressions;

import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryQualifiedName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryComplexName;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SourceResolutionResult;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryMemberAccessEntry;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryTupleRefEntry;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryValueTupleReferenceExpression
extends SQLQueryValueExpression {
    @NotNull
    private final SQLQueryQualifiedName tableName;
    @Nullable
    private final SQLQueryMemberAccessEntry memberAccessEntry;
    @Nullable
    private final SQLQueryTupleRefEntry tupleRefEntry;
    @Nullable
    private SQLQueryRowsSourceModel tupleSource = null;

    public SQLQueryValueTupleReferenceExpression(@NotNull STMTreeNode syntaxNode, @NotNull SQLQueryQualifiedName tableName, @Nullable SQLQueryMemberAccessEntry memberAccessEntry, @Nullable SQLQueryTupleRefEntry tupleRefEntry) {
        super(syntaxNode, new SQLQueryNodeModel[0]);
        this.tableName = tableName;
        this.memberAccessEntry = memberAccessEntry;
        this.tupleRefEntry = tupleRefEntry;
    }

    @NotNull
    public SQLQueryQualifiedName getTableName() {
        return this.tableName;
    }

    @Nullable
    public SQLQueryTupleRefEntry getTupleRefEntry() {
        return this.tupleRefEntry;
    }

    @Nullable
    public SQLQueryRowsSourceModel getTupleSource() {
        return this.tupleSource;
    }

    @Override
    protected void propagateContextImpl(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        if (this.tableName.isNotClassified()) {
            SQLQuerySymbolOrigin.ValueRefFromContext tableNameOrigin = new SQLQuerySymbolOrigin.ValueRefFromContext(context);
            if (this.tableName.invalidPartsCount == 0) {
                SourceResolutionResult rr = context.resolveSource(statistics.getMonitor(), this.tableName.toListOfStrings());
                if (rr != null) {
                    this.tupleSource = rr.source;
                    this.tableName.setDefinition(rr, (SQLQuerySymbolOrigin)tableNameOrigin);
                    if (this.memberAccessEntry != null) {
                        this.memberAccessEntry.setOrigin(new SQLQuerySymbolOrigin.ColumnRefFromReferencedContext(rr));
                    }
                    if (this.tupleRefEntry != null) {
                        this.tupleRefEntry.setOrigin(new SQLQuerySymbolOrigin.ExpandableTupleRef(this.getSyntaxNode(), context, rr));
                    }
                } else {
                    this.tableName.setSymbolClass(SQLQuerySymbolClass.ERROR);
                    statistics.appendError(this.tableName.entityName, "Table or subquery " + this.tableName.toIdentifierString() + " not found");
                }
            } else {
                SQLQueryQualifiedName.performPartialResolution(context, statistics, this.tableName, (SQLQuerySymbolOrigin)tableNameOrigin, Set.of(RelationalObjectType.TYPE_UNKNOWN), SQLQuerySymbolClass.ERROR);
                statistics.appendError(this.getSyntaxNode(), "Invalid tuple reference");
            }
            this.type = SQLQueryExprType.UNKNOWN;
        }
    }

    @Override
    protected void resolveRowSourcesImpl(@NotNull SQLQueryRowsSourceContext context, @NotNull SQLQueryRecognitionContext statistics) {
    }

    @Override
    protected SQLQueryExprType resolveValueTypeImpl(@NotNull SQLQueryRowsDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        if (this.tableName.isNotClassified()) {
            SQLQuerySymbolOrigin.RowsDataRef tableNameOrigin = new SQLQuerySymbolOrigin.RowsDataRef(context);
            if (this.tableName.invalidPartsCount == 0) {
                SQLQueryRowsSourceContext.KnownRowsSourceInfo rr = context.getRowsSources().findReferencedSource(new SQLQueryComplexName(this.tableName.toListOfStrings()));
                if (rr != null) {
                    this.tupleSource = rr.source;
                    this.tableName.setDefinition(rr, (SQLQuerySymbolOrigin)tableNameOrigin);
                    if (this.memberAccessEntry != null) {
                        this.memberAccessEntry.setOrigin(new SQLQuerySymbolOrigin.ColumnRefFromReferencedContext(rr));
                    }
                    if (this.tupleRefEntry != null) {
                        this.tupleRefEntry.setOrigin(new SQLQuerySymbolOrigin.ExpandableTupleRef(this.getSyntaxNode(), null, rr));
                    }
                } else {
                    this.tableName.setSymbolClass(SQLQuerySymbolClass.ERROR);
                    statistics.appendError(this.tableName.entityName, "Table or subquery " + this.tableName.toIdentifierString() + " not found");
                }
            } else {
                SQLQueryQualifiedName.performPartialResolution(context.getRowsSources(), statistics, this.tableName, (SQLQuerySymbolOrigin)tableNameOrigin, Set.of(RelationalObjectType.TYPE_UNKNOWN), SQLQuerySymbolClass.ERROR);
                statistics.appendError(this.getSyntaxNode(), "Invalid tuple reference");
            }
            this.type = SQLQueryExprType.UNKNOWN;
        }
        return this.type;
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitValueTupleRefExpr(this, arg);
    }

    public String toString() {
        String name = this.tableName.toIdentifierString();
        String type = this.type == null ? "<NULL>" : this.type.toString();
        return "TupleReference[" + name + ":" + type + "]";
    }
}

