/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone.tipoftheday;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.app.standalone.tipoftheday.ShowTipOfTheDayDialog;
import org.jkiss.dbeaver.ui.app.standalone.tipoftheday.TipsXmlHandler;
import org.jkiss.utils.CommonUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ShowTipOfTheDayHandler
extends AbstractHandler {
    private static final Log log = Log.getLog(ShowTipOfTheDayHandler.class);

    static void showTipOfTheDay(IWorkbenchWindow window) {
        if (UIUtils.isWindowVisible((Display)window.getShell().getDisplay(), ShowTipOfTheDayDialog.class)) {
            return;
        }
        List<String> tips = ShowTipOfTheDayHandler.loadTips();
        if (!CommonUtils.isEmpty(tips)) {
            ShowTipOfTheDayHandler.showTipOfTheDayDialog(tips, window);
        }
    }

    private static void showTipOfTheDayDialog(List<String> tips, IWorkbenchWindow window) {
        if (tips.isEmpty()) {
            return;
        }
        ShowTipOfTheDayDialog tipDialog = new ShowTipOfTheDayDialog(window.getShell(), tips);
        tipDialog.setDisplayShowOnStartup(true);
        tipDialog.open();
    }

    private static List<String> loadTips() {
        URL url;
        ArrayList<String> result = new ArrayList<String>();
        String pathToTipsFile = Platform.getProduct().getProperty("tipsFile");
        if (pathToTipsFile == null) {
            return result;
        }
        try {
            url = FileLocator.find((URL)new URL(pathToTipsFile));
        }
        catch (MalformedURLException e) {
            log.debug((Object)e);
            return null;
        }
        if (url != null) {
            try {
                Throwable e = null;
                Object var4_8 = null;
                try (InputStream tipsInputStream = url.openConnection().getInputStream();){
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                    SAXParser saxParser = factory.newSAXParser();
                    TipsXmlHandler handler = new TipsXmlHandler();
                    saxParser.parse(tipsInputStream, (DefaultHandler)handler);
                    result.addAll(handler.getTips());
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (ParserConfigurationException | SAXException e) {
                log.error((Object)"Unable to parse tips file:", (Throwable)e);
            }
            catch (IOException ioe) {
                log.error((Object)"Tips file wasn't found", (Throwable)ioe);
            }
            if (!result.isEmpty() && result.size() > 1) {
                Collections.shuffle(result);
            }
        }
        return result;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ShowTipOfTheDayHandler.showTipOfTheDay(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event));
        return null;
    }
}

