/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.data.preferences;

import java.util.Locale;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ValueFormatSelector;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.Spreadsheet;
import org.jkiss.dbeaver.ui.editors.data.internal.DataEditorsMessages;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageResultSetPresentationGrid
extends TargetPrefPage {
    private static final Log log = Log.getLog(PrefPageResultSetPresentationGrid.class);
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.resultset.grid";
    private Button gridShowOddRows;
    private Button gridHighlightRowsWithSelectedCells;
    private Button colorizeDataTypes;
    private Button gridShowAttrIcons;
    private Button gridShowAttrFilters;
    private Button gridShowAttrOrder;
    private Button useSmoothScrolling;
    private Button showBooleanAsCheckbox;
    private Button showWhitespaceCharacters;
    private ValueFormatSelector textValueFormat;
    private Button toggleBooleanOnClick;
    private Button moveAfterInlineEnter;
    private Combo gridDoubleClickBehavior;
    private Text gridRowBatchSize;
    private Text maxDefColumnWidth;

    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("resultset.show.oddRows") || store.contains("resultset.show.colorizeDataTypes") || store.contains("resultset.show.attIcons") || store.contains("resultset.show.attFilters") || store.contains("resultset.show.attrOrder") || store.contains("resultset.hScroll.smooth") || store.contains("resultset.show.boolean.checkbox") || store.contains("resultset.show.whitespace.characters") || store.contains("resultset.show.boolean.toggleOnClick") || store.contains("resultset.behavior.doubleClick") || store.contains("resultset.show.row.batch.size") || store.contains("resultset.max.column.def.width");
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)2, (int)5);
        Group uiGroup = UIUtils.createControlGroup((Composite)composite, (String)DataEditorsMessages.pref_page_database_resultsets_group_grid, (int)2, (int)1808, (int)0);
        Group appearanceGroup = UIUtils.createControlGroup((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_group_appearance, (int)2, (int)770, (int)0);
        this.gridShowOddRows = UIUtils.createCheckbox((Composite)appearanceGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_mark_odd_rows, null, (boolean)false, (int)2);
        this.colorizeDataTypes = UIUtils.createCheckbox((Composite)appearanceGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_colorize_data_types, null, (boolean)false, (int)2);
        this.gridShowAttrIcons = UIUtils.createCheckbox((Composite)appearanceGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_show_attr_icons, (String)DataEditorsMessages.pref_page_database_resultsets_label_show_attr_icons_tip, (boolean)false, (int)2);
        this.gridShowAttrFilters = UIUtils.createCheckbox((Composite)appearanceGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_show_attr_filters, (String)DataEditorsMessages.pref_page_database_resultsets_label_show_attr_filters_tip, (boolean)false, (int)2);
        this.gridShowAttrOrder = UIUtils.createCheckbox((Composite)appearanceGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_show_attr_ordering, (String)DataEditorsMessages.pref_page_database_resultsets_label_show_attr_ordering_tip, (boolean)false, (int)2);
        this.showBooleanAsCheckbox = UIUtils.createCheckbox((Composite)appearanceGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_show_boolean_as_checkbox, (String)DataEditorsMessages.pref_page_database_resultsets_label_show_boolean_as_checkbox_tip, (boolean)false, (int)2);
        this.showWhitespaceCharacters = UIUtils.createCheckbox((Composite)appearanceGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_show_whitespace_characters, (String)DataEditorsMessages.pref_page_database_resultsets_label_show_whitespace_characters_tip, (boolean)false, (int)2);
        this.textValueFormat = new ValueFormatSelector((Composite)appearanceGroup);
        this.maxDefColumnWidth = UIUtils.createLabelText((Composite)appearanceGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_max_def_column_width, (String)"", (int)2048);
        this.maxDefColumnWidth.setToolTipText(DataEditorsMessages.pref_page_database_resultsets_label_max_def_column_width_tip);
        this.maxDefColumnWidth.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        UIUtils.createPreferenceLink((Composite)appearanceGroup, (String)DataEditorsMessages.pref_page_database_resultsets_link_colors_and_fonts, (String)"org.eclipse.ui.preferencePages.ColorsAndFonts", (IWorkbenchPreferenceContainer)((IWorkbenchPreferenceContainer)this.getContainer()), null).setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).create());
        Group behaviorGroup = UIUtils.createControlGroup((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_group_behavior, (int)2, (int)770, (int)0);
        this.gridHighlightRowsWithSelectedCells = UIUtils.createCheckbox((Composite)behaviorGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_highlight_rows_with_selected_cells, null, (boolean)false, (int)2);
        this.useSmoothScrolling = UIUtils.createCheckbox((Composite)behaviorGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_use_smooth_scrolling, (String)DataEditorsMessages.pref_page_database_resultsets_label_use_smooth_scrolling_tip, (boolean)false, (int)2);
        this.toggleBooleanOnClick = UIUtils.createCheckbox((Composite)behaviorGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_toggle_boolean_on_click, (String)DataEditorsMessages.pref_page_database_resultsets_label_toggle_boolean_on_click_tip, (boolean)false, (int)2);
        this.moveAfterInlineEnter = UIUtils.createCheckbox((Composite)behaviorGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_enter_for_inline_behavior, (String)DataEditorsMessages.pref_page_database_resultsets_label_enter_for_inline_behavior_tip, (boolean)false, (int)2);
        UIUtils.createPreferenceLink((Composite)behaviorGroup, (String)("<a>" + DataEditorsMessages.pref_page_database_resultsets_label_show_boolean_config_link + "  - ''{0}''</a>"), (String)"org.jkiss.dbeaver.preferences.main.misc", (IWorkbenchPreferenceContainer)((IWorkbenchPreferenceContainer)this.getContainer()), null).setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).create());
        this.gridDoubleClickBehavior = UIUtils.createLabelCombo((Composite)behaviorGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_double_click_behavior, (int)8);
        this.gridDoubleClickBehavior.add(DataEditorsMessages.pref_page_result_selector_none, Spreadsheet.DoubleClickBehavior.NONE.ordinal());
        this.gridDoubleClickBehavior.add(DataEditorsMessages.pref_page_result_selector_editor, Spreadsheet.DoubleClickBehavior.EDITOR.ordinal());
        this.gridDoubleClickBehavior.add(DataEditorsMessages.pref_page_result_selector_inline_editor, Spreadsheet.DoubleClickBehavior.INLINE_EDITOR.ordinal());
        this.gridDoubleClickBehavior.add(DataEditorsMessages.pref_page_result_selector_copy_cell, Spreadsheet.DoubleClickBehavior.COPY_VALUE.ordinal());
        this.gridDoubleClickBehavior.add(DataEditorsMessages.pref_page_result_selector_paste_cell_value, Spreadsheet.DoubleClickBehavior.COPY_PASTE_VALUE.ordinal());
        this.gridRowBatchSize = UIUtils.createLabelText((Composite)behaviorGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_row_batch_size, (String)"", (int)2048);
        this.gridRowBatchSize.setToolTipText(DataEditorsMessages.pref_page_database_resultsets_label_row_batch_size_tip);
        return composite;
    }

    protected void loadPreferences(DBPPreferenceStore store) {
        try {
            this.gridShowOddRows.setSelection(store.getBoolean("resultset.show.oddRows"));
            this.gridHighlightRowsWithSelectedCells.setSelection(store.getBoolean("resultset.highlight.selectedRows"));
            this.colorizeDataTypes.setSelection(store.getBoolean("resultset.show.colorizeDataTypes"));
            this.gridShowAttrIcons.setSelection(store.getBoolean("resultset.show.attIcons"));
            this.gridShowAttrFilters.setSelection(store.getBoolean("resultset.show.attFilters"));
            this.gridShowAttrOrder.setSelection(store.getBoolean("resultset.show.attrOrder"));
            this.useSmoothScrolling.setSelection(store.getBoolean("resultset.hScroll.smooth"));
            this.showBooleanAsCheckbox.setSelection(store.getBoolean("resultset.show.boolean.checkbox"));
            this.showWhitespaceCharacters.setSelection(store.getBoolean("resultset.show.whitespace.characters"));
            this.textValueFormat.select((DBDDisplayFormat)CommonUtils.valueOf(DBDDisplayFormat.class, (String)store.getString("resultset.grid.value.format"), (Enum)DBDDisplayFormat.UI));
            this.toggleBooleanOnClick.setSelection(store.getBoolean("resultset.show.boolean.toggleOnClick"));
            this.moveAfterInlineEnter.setSelection(store.getBoolean("resultset.behavior.inlineEnter"));
            this.gridDoubleClickBehavior.select(((Spreadsheet.DoubleClickBehavior)CommonUtils.valueOf(Spreadsheet.DoubleClickBehavior.class, (String)store.getString("resultset.behavior.doubleClick"), (Enum)Spreadsheet.DoubleClickBehavior.NONE)).ordinal());
            this.gridRowBatchSize.setText(store.getString("resultset.show.row.batch.size"));
            this.maxDefColumnWidth.setText(store.getString("resultset.max.column.def.width"));
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    protected void savePreferences(DBPPreferenceStore store) {
        try {
            store.setValue("resultset.show.oddRows", this.gridShowOddRows.getSelection());
            store.setValue("resultset.behavior.inlineEnter", this.moveAfterInlineEnter.getSelection());
            store.setValue("resultset.highlight.selectedRows", this.gridHighlightRowsWithSelectedCells.getSelection());
            store.setValue("resultset.show.colorizeDataTypes", this.colorizeDataTypes.getSelection());
            store.setValue("resultset.show.attIcons", this.gridShowAttrIcons.getSelection());
            store.setValue("resultset.show.attFilters", this.gridShowAttrFilters.getSelection());
            store.setValue("resultset.show.attrOrder", this.gridShowAttrOrder.getSelection());
            store.setValue("resultset.hScroll.smooth", this.useSmoothScrolling.getSelection());
            store.setValue("resultset.show.boolean.checkbox", this.showBooleanAsCheckbox.getSelection());
            store.setValue("resultset.show.whitespace.characters", this.showWhitespaceCharacters.getSelection());
            store.setValue("resultset.grid.value.format", this.textValueFormat.getSelection().name());
            store.setValue("resultset.show.boolean.toggleOnClick", this.toggleBooleanOnClick.getSelection());
            store.setValue("resultset.behavior.doubleClick", ((Spreadsheet.DoubleClickBehavior)CommonUtils.fromOrdinal(Spreadsheet.DoubleClickBehavior.class, (int)this.gridDoubleClickBehavior.getSelectionIndex())).name());
            store.setValue("resultset.show.row.batch.size", CommonUtils.toInt((Object)this.gridRowBatchSize.getText()));
            int maxColumnWidth = CommonUtils.toInt((Object)this.maxDefColumnWidth.getText());
            maxColumnWidth = maxColumnWidth < 0 ? 0 : (maxColumnWidth > 100 ? 100 : maxColumnWidth);
            store.setValue("resultset.max.column.def.width", maxColumnWidth);
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("resultset.behavior.inlineEnter");
        store.setToDefault("resultset.show.oddRows");
        store.setToDefault("resultset.highlight.selectedRows");
        store.setToDefault("resultset.show.colorizeDataTypes");
        store.setToDefault("resultset.show.attIcons");
        store.setToDefault("resultset.show.attFilters");
        store.setToDefault("resultset.show.attrOrder");
        store.setToDefault("resultset.hScroll.smooth");
        store.setToDefault("resultset.show.boolean.checkbox");
        store.setToDefault("resultset.show.whitespace.characters");
        store.setToDefault("resultset.grid.value.format");
        store.setToDefault("resultset.show.boolean.toggleOnClick");
        store.setToDefault("resultset.behavior.doubleClick");
        store.setToDefault("resultset.show.row.batch.size");
        store.setToDefault("resultset.max.column.def.width");
    }

    protected void performDefaults() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.gridShowOddRows.setSelection(store.getDefaultBoolean("resultset.show.oddRows"));
        this.gridHighlightRowsWithSelectedCells.setSelection(store.getDefaultBoolean("resultset.highlight.selectedRows"));
        this.colorizeDataTypes.setSelection(store.getDefaultBoolean("resultset.show.colorizeDataTypes"));
        this.gridShowAttrIcons.setSelection(store.getDefaultBoolean("resultset.show.attIcons"));
        this.gridShowAttrFilters.setSelection(store.getDefaultBoolean("resultset.show.attFilters"));
        this.gridShowAttrOrder.setSelection(store.getDefaultBoolean("resultset.show.attrOrder"));
        this.useSmoothScrolling.setSelection(store.getDefaultBoolean("resultset.hScroll.smooth"));
        this.showBooleanAsCheckbox.setSelection(store.getDefaultBoolean("resultset.show.boolean.checkbox"));
        this.showWhitespaceCharacters.setSelection(store.getDefaultBoolean("resultset.show.whitespace.characters"));
        this.textValueFormat.select(DBDDisplayFormat.UI);
        this.toggleBooleanOnClick.setSelection(store.getDefaultBoolean("resultset.show.boolean.toggleOnClick"));
        this.moveAfterInlineEnter.setSelection(store.getDefaultBoolean("resultset.behavior.inlineEnter"));
        UIUtils.setComboSelection((Combo)this.gridDoubleClickBehavior, (String)store.getDefaultString("resultset.behavior.doubleClick"));
        this.gridRowBatchSize.setText(String.valueOf(store.getDefaultInt("resultset.show.row.batch.size")));
        this.maxDefColumnWidth.setText(String.valueOf(store.getDefaultInt("resultset.max.column.def.width")));
        super.performDefaults();
    }

    protected String getPropertyPageID() {
        return PAGE_ID;
    }
}

