/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.edit;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.edit.SQLServerBaseTableManager;
import org.jkiss.dbeaver.ext.mssql.edit.SQLServerTableColumnManager;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerExtendedProperty;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTable;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableBase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableCheckConstraint;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableColumn;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableForeignKey;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableIndex;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableUniqueKey;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLStructEditor;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class SQLServerTableManager
extends SQLServerBaseTableManager<SQLServerTableBase> {
    private static final Class<? extends DBSObject>[] CHILD_TYPES = (Class[])CommonUtils.array((Object[])new Class[]{SQLServerTableColumn.class, SQLServerTableUniqueKey.class, SQLServerTableForeignKey.class, SQLServerTableIndex.class, SQLServerTableCheckConstraint.class, SQLServerExtendedProperty.class});

    protected SQLServerTable createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) {
        SQLServerSchema schema = (SQLServerSchema)container;
        SQLServerTable table = new SQLServerTable(schema);
        this.setNewObjectName(monitor, schema, table);
        return table;
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) {
        if (command.getProperties().size() > 1 || command.getProperty((Object)"description") == null) {
            StringBuilder query = new StringBuilder("ALTER TABLE ");
            query.append(((SQLServerTableBase)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL)).append(" ");
            this.appendTableModifiers(monitor, (SQLServerTableBase)command.getObject(), (SQLObjectEditor.NestedObjectCommand)command, query, true);
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(query.toString()));
        }
    }

    protected void appendTableModifiers(DBRProgressMonitor monitor, SQLServerTableBase table, SQLObjectEditor.NestedObjectCommand tableProps, StringBuilder ddl, boolean alter) {
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) {
        SQLServerTableBase object = (SQLServerTableBase)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction(ModelMessages.model_jdbc_drop_table, "DROP " + this.getCreateTableType((DBSEntity)object) + " " + object.getFullyQualifiedName(DBPEvaluationContext.DDL) + (!object.isView() && CommonUtils.getOption(options, (String)"deleteCascade") ? " CASCADE CONSTRAINTS" : "")));
    }

    @NotNull
    public Class<? extends DBSObject>[] getChildTypes() {
        return CHILD_TYPES;
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull SQLServerTableBase object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, object, options, newName);
    }

    protected boolean isIncludeIndexInDDL(@NotNull DBRProgressMonitor monitor, @NotNull DBSTableIndex index) throws DBException {
        Collection constraints = index.getTable().getConstraints(monitor);
        if (constraints.size() > 0 && index.isUnique()) {
            for (DBSEntityConstraint constraint : constraints) {
                if (!(constraint instanceof SQLServerTableUniqueKey) || constraint.getConstraintType() != DBSEntityConstraintType.UNIQUE_KEY || ((SQLServerTableUniqueKey)constraint).getIndex() != index) continue;
                return false;
            }
        }
        return !index.isPrimary() && super.isIncludeIndexInDDL(monitor, index);
    }

    protected void addExtraDDLCommands(DBRProgressMonitor monitor, SQLServerTableBase table, Map<String, Object> options, SQLStructEditor.StructCreateCommand createCommand) {
        SQLObjectEditor ccm = this.getObjectEditor(DBWorkbench.getPlatform().getEditorsRegistry(), SQLServerTableCheckConstraint.class);
        if (ccm != null) {
            try {
                Collection checkConstraints;
                if (table instanceof SQLServerTable && !CommonUtils.isEmpty((Collection)(checkConstraints = CommonUtils.safeCollection(((SQLServerTable)table).getCheckConstraints(monitor))))) {
                    for (SQLServerTableCheckConstraint checkConstraint : checkConstraints) {
                        createCommand.aggregateCommand((DBECommand)ccm.makeCreateCommand((DBSObject)checkConstraint, options));
                    }
                }
            }
            catch (DBException e) {
                log.debug((Object)e);
            }
        }
    }

    @Override
    protected void addObjectExtraActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.NestedObjectCommand<SQLServerTableBase, SQLObjectEditor.PropertyHandler> command, @NotNull Map<String, Object> options) throws DBException {
        super.addObjectExtraActions(monitor, executionContext, actionList, command, options);
        SQLServerTableBase tableBase = (SQLServerTableBase)command.getObject();
        if (!tableBase.isPersisted()) {
            for (SQLServerTableColumn column : CommonUtils.safeCollection(tableBase.getAttributes(monitor))) {
                if (CommonUtils.isEmpty((String)column.getDescription())) continue;
                SQLServerTableColumnManager.addColumnCommentAction(actionList, column, false);
            }
        }
    }
}

