/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.layout;

import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.jkiss.dbeaver.erd.ui.internal.ERDUIMessages;
import org.jkiss.dbeaver.erd.ui.layout.algorithm.direct.DirectedGraphLayoutVisitor;
import org.jkiss.dbeaver.erd.ui.part.DiagramPart;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UIUtils;

public class GraphLayoutAuto
extends AbstractLayout {
    private DiagramPart diagram;

    public GraphLayoutAuto(DiagramPart diagram) {
        this.diagram = diagram;
    }

    protected Dimension calculatePreferredSize(IFigure container, int widthHint, int heightHint) {
        container.validate();
        List children = container.getChildren();
        Rectangle result = new Rectangle().setLocation(container.getClientArea().getLocation());
        for (IFigure child : children) {
            result.union(child.getBounds());
        }
        result.resize(container.getInsets().getWidth(), container.getInsets().getHeight());
        return result.getSize();
    }

    public void layout(IFigure container) {
        DBRProgressMonitor monitor = this.diagram.getDiagram().getMonitor();
        monitor.subTask(ERDUIMessages.erd_job_layout_diagram);
        UIUtils.syncExec(() -> {
            new DirectedGraphLayoutVisitor(this.diagram.getDiagram().getDecorator()).layoutDiagram(this.diagram);
            this.diagram.setTableModelBounds();
        });
    }
}

