/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.dpi.model.adapters;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.dpi.model.DPIContext;
import org.jkiss.dbeaver.dpi.model.adapters.AbstractTypeAdapter;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialectMetadata;
import org.jkiss.dbeaver.runtime.DBWorkbench;

class SQLDialectAdapter
extends AbstractTypeAdapter<SQLDialect> {
    public SQLDialectAdapter(DPIContext context) {
        super(context);
    }

    public void write(JsonWriter jsonWriter, SQLDialect sqlDialect) throws IOException {
        jsonWriter.value(sqlDialect.getDialectId());
    }

    public SQLDialect read(JsonReader jsonReader) throws IOException {
        String dialectId = jsonReader.nextString();
        SQLDialectMetadata dialectMetadata = DBWorkbench.getPlatform().getSQLDialectRegistry().getDialect(dialectId);
        if (dialectMetadata == null) {
            throw new IOException("Dialect not found: " + dialectId);
        }
        try {
            return dialectMetadata.createInstance();
        }
        catch (DBException e) {
            throw new IOException("Failed to create dialect instance: " + e.getMessage(), e);
        }
    }
}

