/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerType;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.utils.CommonUtils;

public class DBWUtils {
    public static final String LOOPBACK_HOST_NAME = "127.0.0.1";
    public static final String LOOPBACK_IPV6_HOST_NAME = ":1";
    public static final String LOOPBACK_IPV6_FULL_HOST_NAME = "0:0:0:0:0:0:0:1";
    public static final String LOCALHOST_NAME = "localhost";
    public static final String LOCAL_NAME = "local";

    public static void updateConfigWithTunnelInfo(DBWHandlerConfiguration configuration, DBPConnectionConfiguration connectionInfo, String localHost, int localPort) {
        if (CommonUtils.isNotEmpty((String)localHost)) {
            connectionInfo.setHostName(localHost);
        } else if (!LOCALHOST_NAME.equals(connectionInfo.getHostName()) && !LOCAL_NAME.equals(connectionInfo.getHostName())) {
            connectionInfo.setHostName(LOOPBACK_HOST_NAME);
        }
        connectionInfo.setHostPort(Integer.toString(localPort));
        if (configuration.getDriver() != null) {
            String newURL = configuration.getDriver().getConnectionURL(connectionInfo);
            connectionInfo.setUrl(newURL);
        }
    }

    @NotNull
    public static String getTargetTunnelHostName(@Nullable DBPDataSourceContainer dataSourceContainer, @NotNull DBPConnectionConfiguration cfg) {
        String hostText = cfg.getHostName();
        if (DBWUtils.isLocalAddress(hostText)) {
            DBWNetworkProfile networkProfile = dataSourceContainer == null ? null : DBWUtils.getNetworkProfile(dataSourceContainer);
            for (DBWHandlerConfiguration hc : cfg.getHandlers()) {
                DBWHandlerConfiguration hCfg;
                if (!hc.isEnabled() || hc.getType() != DBWHandlerType.TUNNEL) continue;
                String tunnelHost = null;
                if (networkProfile != null && (hCfg = networkProfile.getConfiguration(hc.getHandlerDescriptor())) != null) {
                    tunnelHost = DBWUtils.getTunnelHostFromConfig(hCfg);
                }
                if (tunnelHost == null) {
                    tunnelHost = DBWUtils.getTunnelHostFromConfig(hc);
                }
                if (CommonUtils.isEmpty(tunnelHost)) continue;
                hostText = tunnelHost;
                break;
            }
        }
        return CommonUtils.notEmpty((String)hostText);
    }

    @Nullable
    public static String getTunnelHostFromConfig(DBWHandlerConfiguration hc) {
        String host = hc.getStringProperty("host");
        if (CommonUtils.isEmpty((String)host)) {
            return null;
        }
        return host;
    }

    public static boolean isLocalAddress(String hostText) {
        return CommonUtils.isEmpty((String)hostText) || hostText.equals(LOCALHOST_NAME) || hostText.equals(LOCAL_NAME) || hostText.equals(LOOPBACK_HOST_NAME) || hostText.equals(LOOPBACK_IPV6_HOST_NAME) || hostText.equals(LOOPBACK_IPV6_FULL_HOST_NAME);
    }

    @Nullable
    public static DBWNetworkProfile getNetworkProfile(@NotNull DBPDataSourceContainer dataSourceContainer) {
        DBPConnectionConfiguration cfg = dataSourceContainer.getConnectionConfiguration();
        return CommonUtils.isEmpty((String)cfg.getConfigProfileName()) ? null : dataSourceContainer.getRegistry().getNetworkProfile(cfg.getConfigProfileSource(), cfg.getConfigProfileName());
    }
}

