/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLSourceObject;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractTrigger;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSActionTiming;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSManipulationType;

public class MySQLTrigger
extends AbstractTrigger
implements MySQLSourceObject,
DBPRefreshableObject {
    private MySQLCatalog catalog;
    private MySQLTable table;
    private String body;
    private String charsetClient;
    private String sqlMode;

    public MySQLTrigger(MySQLCatalog catalog, MySQLTable table, ResultSet dbResult) {
        super(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TRIGGER_NAME"), null, true);
        this.catalog = catalog;
        this.table = table;
        this.setManipulationType(DBSManipulationType.getByName((String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"EVENT_MANIPULATION")));
        this.setActionTiming(DBSActionTiming.getByName((String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ACTION_TIMING")));
        this.charsetClient = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CHARACTER_SET_CLIENT");
        this.sqlMode = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SQL_MODE");
    }

    public MySQLTrigger(MySQLCatalog catalog, MySQLTable table, String name) {
        super(name, null, false);
        this.catalog = catalog;
        this.table = table;
        this.setActionTiming(DBSActionTiming.AFTER);
        this.setManipulationType(DBSManipulationType.INSERT);
        this.body = "";
    }

    public MySQLTrigger(MySQLCatalog catalog, MySQLTable table, MySQLTrigger source) {
        super(source.name, source.getDescription(), false);
        this.catalog = catalog;
        this.table = table;
        this.body = source.body;
        this.charsetClient = source.charsetClient;
        this.sqlMode = source.sqlMode;
    }

    @Property(viewable=true, order=2, listProvider=AbstractTrigger.TriggerTimingListProvider.class)
    public DBSActionTiming getActionTiming() {
        return super.getActionTiming();
    }

    @Property(viewable=true, order=3, listProvider=AbstractTrigger.TriggerTypeListProvider.class)
    public DBSManipulationType getManipulationType() {
        return super.getManipulationType();
    }

    public String getBody() {
        return this.body;
    }

    public MySQLCatalog getCatalog() {
        return this.catalog;
    }

    @Property(viewable=true, order=4)
    public MySQLTable getTable() {
        return this.table;
    }

    @Property(order=5)
    public String getCharsetClient() {
        return this.charsetClient;
    }

    @Property(order=6)
    public String getSqlMode() {
        return this.sqlMode;
    }

    public MySQLTable getParentObject() {
        return this.table;
    }

    @NotNull
    public MySQLDataSource getDataSource() {
        return this.catalog.getDataSource();
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (this.body == null) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read trigger declaration");){
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement("SHOW CREATE TRIGGER " + this.getFullyQualifiedName(DBPEvaluationContext.DDL));){
                        Throwable throwable3 = null;
                        Object var10_16 = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery();){
                            this.body = dbResult.next() ? JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SQL Original Statement") : "-- Trigger definition not found in catalog";
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                this.body = "-- " + e.getMessage();
                throw new DBDatabaseException((Throwable)e, (DBPDataSource)this.getDataSource());
            }
        }
        return this.body;
    }

    @Override
    public void setObjectDefinitionText(String sourceText) {
        this.body = sourceText;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.catalog, this});
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getCatalog().triggerCache.refreshObject(monitor, (DBSObject)this.getCatalog(), this);
    }
}

