/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.dbeaver.model.rcp.RCPProject;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.dbeaver.ui.preferences.PrefPageNetworkProfiles;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageProjectNetworkProfiles
extends PrefPageNetworkProfiles
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.project.settings.networkProfiles";
    private DBPProject projectMeta;

    @Override
    public void saveSettings(DBWNetworkProfile profile) {
        super.saveSettings(profile);
        if (this.projectMeta.isUseSecretStorage()) {
            try {
                DBSSecretController secretController = DBSSecretController.getProjectSecretController((DBPProject)this.projectMeta);
                profile.persistSecrets(secretController);
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Save error", "Cannot save network profile credentials", (Throwable)e);
            }
        }
    }

    @Override
    protected DBSSecretController getSecretController() throws DBException {
        DBSSecretController secretController = null;
        if (this.projectMeta.isUseSecretStorage()) {
            secretController = DBSSecretController.getProjectSecretController((DBPProject)this.projectMeta);
        }
        return secretController;
    }

    @Override
    protected List<DBWNetworkProfile> getDefaultNetworkProfiles() {
        return this.projectMeta.getDataSourceRegistry().getNetworkProfiles();
    }

    @Override
    protected void updateNetworkProfiles(List<DBWNetworkProfile> allProfiles) {
        for (DBWNetworkProfile profile : allProfiles) {
            this.saveSettings(profile);
            this.projectMeta.getDataSourceRegistry().updateNetworkProfile(profile);
        }
        this.projectMeta.getDataSourceRegistry().flushConfig();
    }

    @Override
    protected boolean deleteProfile(DBWNetworkProfile selectedProfile) {
        List usedBy = this.projectMeta.getDataSourceRegistry().getDataSourcesByProfile(selectedProfile);
        if (!usedBy.isEmpty()) {
            UIUtils.showMessageBox((Shell)this.getShell(), (String)UIConnectionMessages.pref_page_network_profiles_tool_delete_dialog_error_title, (String)NLS.bind((String)UIConnectionMessages.pref_page_network_profiles_tool_delete_dialog_error_info, (Object[])new Object[]{selectedProfile.getProfileName(), usedBy.size(), usedBy.stream().sorted(Comparator.comparing(DBPNamedObject::getName)).map(x -> " - " + x.getName()).collect(Collectors.joining("\n"))}), (int)1);
            return false;
        }
        if (UIUtils.confirmAction((Shell)this.getShell(), (String)UIConnectionMessages.pref_page_network_profiles_tool_delete_confirmation_title, (String)NLS.bind((String)UIConnectionMessages.pref_page_network_profiles_tool_delete_confirmation_question, (Object)selectedProfile.getProfileName()))) {
            this.projectMeta.getDataSourceRegistry().removeNetworkProfile(selectedProfile);
            this.projectMeta.getDataSourceRegistry().flushConfig();
            return true;
        }
        return false;
    }

    @Override
    protected DBWNetworkProfile createNewProfile(@Nullable DBWNetworkProfile sourceProfile) {
        String profileName;
        String string = profileName = sourceProfile == null ? "" : sourceProfile.getProfileName();
        while (true) {
            if (CommonUtils.isEmptyTrimmed((String)(profileName = EnterNameDialog.chooseName((Shell)this.getShell(), (String)UIConnectionMessages.pref_page_network_profiles_tool_create_dialog_profile_name, (String)profileName)))) {
                return null;
            }
            if (this.projectMeta.getDataSourceRegistry().getNetworkProfile(null, profileName) == null) break;
            UIUtils.showMessageBox((Shell)this.getShell(), (String)UIConnectionMessages.pref_page_network_profiles_tool_create_dialog_error_title, (String)NLS.bind((String)UIConnectionMessages.pref_page_network_profiles_tool_create_dialog_error_info, (Object)profileName, (Object)this.projectMeta.getName()), (int)1);
        }
        DBWNetworkProfile newProfile = new DBWNetworkProfile(this.projectMeta);
        newProfile.setProfileName(profileName);
        this.projectMeta.getDataSourceRegistry().updateNetworkProfile(newProfile);
        this.projectMeta.getDataSourceRegistry().flushConfig();
        return newProfile;
    }

    public void init(IWorkbench workbench) {
    }

    public IAdaptable getElement() {
        IProject iProject;
        DBPProject dBPProject = this.projectMeta;
        if (dBPProject instanceof RCPProject) {
            RCPProject rcpProject = (RCPProject)dBPProject;
            iProject = rcpProject.getEclipseProject();
        } else {
            iProject = null;
        }
        return iProject;
    }

    public void setElement(IAdaptable element) {
        IProject iProject;
        DBNNode node;
        DBPProject dBPProject;
        if (element instanceof DBNNode && (dBPProject = (node = (DBNNode)element).getOwnerProject()) instanceof RCPProject) {
            RCPProject rcpProject = (RCPProject)dBPProject;
            iProject = rcpProject.getEclipseProject();
        } else {
            iProject = (IProject)GeneralUtils.adapt((Object)element, IProject.class);
        }
        if (iProject != null) {
            this.projectMeta = DBPPlatformDesktop.getInstance().getWorkspace().getProject(iProject);
        }
    }
}

