/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.part;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Color;
import org.jkiss.dbeaver.erd.model.ERDAssociation;
import org.jkiss.dbeaver.erd.model.ERDAttributeVisibility;
import org.jkiss.dbeaver.erd.model.ERDElement;
import org.jkiss.dbeaver.erd.model.ERDEntity;
import org.jkiss.dbeaver.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.erd.model.ERDObject;
import org.jkiss.dbeaver.erd.ui.ERDUIUtils;
import org.jkiss.dbeaver.erd.ui.command.AttributeCheckCommand;
import org.jkiss.dbeaver.erd.ui.editor.ERDGraphicalViewer;
import org.jkiss.dbeaver.erd.ui.editor.ERDHighlightingHandle;
import org.jkiss.dbeaver.erd.ui.editor.ERDHighlightingManager;
import org.jkiss.dbeaver.erd.ui.editor.ERDThemeSettings;
import org.jkiss.dbeaver.erd.ui.figures.AttributeItemFigure;
import org.jkiss.dbeaver.erd.ui.figures.EditableLabel;
import org.jkiss.dbeaver.erd.ui.internal.ERDUIActivator;
import org.jkiss.dbeaver.erd.ui.internal.ERDUIMessages;
import org.jkiss.dbeaver.erd.ui.part.AssociationPart;
import org.jkiss.dbeaver.erd.ui.part.EntityPart;
import org.jkiss.dbeaver.erd.ui.part.NodePart;
import org.jkiss.dbeaver.erd.ui.policy.AttributeConnectionEditPolicy;
import org.jkiss.dbeaver.erd.ui.policy.AttributeDragAndDropEditPolicy;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.utils.ListNode;

public class AttributePart
extends NodePart {
    public static final String PROP_CHECKED = "CHECKED";
    private ERDHighlightingHandle associatedRelationsHighlighing = null;
    protected AbstractGraphicalEditPart.AccessibleGraphicalEditPart accPart;

    public boolean isSelectable() {
        return true;
    }

    public ERDEntityAttribute getAttribute() {
        return (ERDEntityAttribute)this.getModel();
    }

    public ERDEntity getEntity() {
        return (ERDEntity)this.getParent().getModel();
    }

    public String getAttributeLabel() {
        return ERDUIUtils.getFullAttributeLabel(this.getDiagram(), this.getAttribute(), false);
    }

    protected void addSourceConnection(ConnectionEditPart connection, int index) {
        if (!this.getEditor().getDiagramRouter().supportedAttributeAssociation() || ERDAttributeVisibility.isHideAttributeAssociations((DBPPreferenceStore)ERDUIActivator.getDefault().getPreferences())) {
            return;
        }
        AssociationPart associationPart = (AssociationPart)connection;
        ERDAssociation association = associationPart.getAssociation();
        ERDEntityAttribute attribute = this.getAttribute();
        for (ERDEntityAttribute attr : association.getSourceAttributes()) {
            if (attr.getObject() != attribute.getObject()) continue;
            super.addSourceConnection(connection, index);
        }
    }

    @Override
    protected List<ERDAssociation> getModelSourceConnections() {
        if (!this.getEditor().getDiagramRouter().supportedAttributeAssociation() || ERDAttributeVisibility.isHideAttributeAssociations((DBPPreferenceStore)ERDUIActivator.getDefault().getPreferences())) {
            return Collections.emptyList();
        }
        ERDEntityAttribute attribute = this.getAttribute();
        ArrayList<ERDAssociation> list = new ArrayList<ERDAssociation>();
        for (ERDAssociation erdAssociation : super.getModelSourceConnections()) {
            for (ERDEntityAttribute attr : erdAssociation.getSourceAttributes()) {
                if (attr.getObject() != attribute.getObject()) continue;
                list.add(erdAssociation);
            }
        }
        return list;
    }

    @Override
    protected List<ERDAssociation> getModelTargetConnections() {
        if (!this.getEditor().getDiagramRouter().supportedAttributeAssociation() || ERDAttributeVisibility.isHideAttributeAssociations((DBPPreferenceStore)ERDUIActivator.getDefault().getPreferences())) {
            return Collections.emptyList();
        }
        ERDEntityAttribute attribute = this.getAttribute();
        ArrayList<ERDAssociation> list = new ArrayList<ERDAssociation>();
        for (ERDAssociation erdAssociation : super.getModelTargetConnections()) {
            for (ERDEntityAttribute attr : erdAssociation.getTargetAttributes()) {
                if (attr.getObject() != attribute.getObject()) continue;
                list.add(erdAssociation);
            }
        }
        return list;
    }

    protected void addTargetConnection(ConnectionEditPart connection, int index) {
        if (!this.getEditor().getDiagramRouter().supportedAttributeAssociation() || ERDAttributeVisibility.isHideAttributeAssociations((DBPPreferenceStore)ERDUIActivator.getDefault().getPreferences())) {
            return;
        }
        AssociationPart associationPart = (AssociationPart)connection;
        ERDAssociation association = associationPart.getAssociation();
        ERDEntityAttribute attribute = this.getAttribute();
        for (ERDEntityAttribute attr : association.getTargetAttributes()) {
            if (attr.getObject() != attribute.getObject()) continue;
            super.addTargetConnection(connection, index);
        }
    }

    protected AttributeItemFigure createFigure() {
        return new AttributeItemFigure(this);
    }

    public AttributeItemFigure getFigure() {
        return (AttributeItemFigure)super.getFigure();
    }

    protected void createEditPolicies() {
        if (!this.getEditor().isReadOnly()) {
            if (this.isLayoutEnabled() && this.getEditPolicy("ContainerEditPolicy") == null && this.isColumnDragAndDropSupported()) {
                this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new AttributeConnectionEditPolicy(this));
                this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new AttributeDragAndDropEditPolicy(this));
            }
            this.getDiagram().getModelAdapter().installPartEditPolicies((EditPart)this);
        }
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            ERDUIUtils.openObjectEditor(this.getDiagram(), (ERDObject)this.getAttribute());
        } else {
            this.getDiagram().getModelAdapter().performPartRequest((EditPart)this, request);
        }
    }

    public AttributeCheckCommand createAttributeCheckCommand(boolean newChecked) {
        return new AttributeCheckCommand<AttributePart>(this, newChecked);
    }

    public void setSelected(int value) {
        super.setSelected(value);
        EditableLabel columnLabel = this.getFigure().getLabel();
        columnLabel.setSelected(value != 0);
        columnLabel.repaint();
        if (value != 0) {
            EditPartViewer editPartViewer = this.getViewer();
            if (editPartViewer instanceof ERDGraphicalViewer) {
                ERDGraphicalViewer erdViewer = (ERDGraphicalViewer)editPartViewer;
                if (this.associatedRelationsHighlighing == null) {
                    Color attributeColor = ERDThemeSettings.instance.fkHighlightColor;
                    Color associationColor = ERDThemeSettings.instance.fkHighlightColor;
                    ERDHighlightingManager highlightingManager = erdViewer.getEditor().getHighlightingManager();
                    ListNode<ERDHighlightingHandle> nodes = highlightingManager.highlightRelatedAttributes(this, attributeColor);
                    nodes = highlightingManager.highlightAssociation(nodes, this, associationColor);
                    this.associatedRelationsHighlighing = highlightingManager.makeHighlightingGroupHandle(nodes);
                }
            }
        } else if (this.associatedRelationsHighlighing != null) {
            this.associatedRelationsHighlighing.release();
            this.associatedRelationsHighlighing = null;
        }
    }

    public void handleNameChange() {
        AttributeItemFigure figure = this.getFigure();
        figure.updateLabels();
        this.setSelected(0);
        figure.revalidate();
    }

    @Override
    protected void commitNameChange(PropertyChangeEvent evt) {
        AttributeItemFigure figure = this.getFigure();
        figure.updateLabels();
        this.setSelected(2);
        figure.revalidate();
    }

    protected void refreshVisuals() {
        this.getFigure().updateLabels();
    }

    public DragTracker getDragTracker(Request request) {
        DragEditPartsTracker dragTracker = new DragEditPartsTracker((EditPart)this);
        dragTracker.setDefaultCursor(SharedCursors.CURSOR_TREE_MOVE);
        return dragTracker;
    }

    public EditPart getTargetEditPart(Request request) {
        if ("move".equals(request.getType()) || "add children".equals(request.getType())) {
            return this;
        }
        return super.getTargetEditPart(request);
    }

    protected void registerVisuals() {
        super.registerVisuals();
        Map visualPartMap = this.getViewer().getVisualPartMap();
        visualPartMap.put(this.getFigure().getCheckBox(), this);
        visualPartMap.put(this.getFigure().getLabel(), this);
    }

    protected void unregisterVisuals() {
        Map visualPartMap = this.getViewer().getVisualPartMap();
        visualPartMap.remove((Object)this.getFigure().getLabel());
        visualPartMap.remove((Object)this.getFigure().getCheckBox());
        super.unregisterVisuals();
    }

    public String toString() {
        return ERDUIMessages.column_.trim() + " " + this.getAttribute().getLabelText();
    }

    @Override
    public ERDElement getElement() {
        return this.getEntity();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor((IFigure)this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChopboxAnchor((IFigure)this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        ERDAssociation association;
        ERDEntityAttribute attribute = this.getAttribute();
        Object object = connection.getModel();
        if (object instanceof ERDAssociation && (association = (ERDAssociation)object).getTargetAttributes().contains(attribute)) {
            return new ChopboxAnchor(this.getFigure().getParent());
        }
        return new ChopboxAnchor((IFigure)this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChopboxAnchor((IFigure)this.getFigure());
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accPart == null) {
            this.accPart = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

                public void getName(AccessibleEvent e) {
                    e.result = NLS.bind((String)ERDUIMessages.erd_accessibility_attribute_part, (Object)ERDUIUtils.getFullAttributeLabel(AttributePart.this.getDiagram(), AttributePart.this.getAttribute(), true, true));
                }
            };
        }
        return this.accPart;
    }

    public List<AssociationPart> getAssociatingBySource() {
        ArrayList<AssociationPart> parts = new ArrayList<AssociationPart>();
        ERDEntityAttribute attribute = this.getAttribute();
        List associations = this.getEntity().getAssociations();
        for (ERDAssociation attributeAssociation : associations) {
            EditPart editPart;
            if (!attributeAssociation.getSourceAttributes().contains(attribute)) continue;
            AssociationPart connectionPart = this.getConnectionPart(attributeAssociation, true);
            if (connectionPart == null && (editPart = this.getParent()) instanceof EntityPart) {
                EntityPart entityPart = (EntityPart)editPart;
                for (GraphicalEditPart entityAttribute : entityPart.getChildren()) {
                    for (Object o : entityAttribute.getSourceConnections()) {
                        AssociationPart entityAssociatonPart;
                        if (!(o instanceof AssociationPart) || !(entityAssociatonPart = (AssociationPart)o).getAssociation().equals(attributeAssociation)) continue;
                        parts.add(entityAssociatonPart);
                    }
                }
                continue;
            }
            parts.add(connectionPart);
        }
        return parts;
    }

    public List<AssociationPart> getAssociatingByTarget() {
        ArrayList<AssociationPart> parts = new ArrayList<AssociationPart>();
        ERDEntityAttribute attribute = this.getAttribute();
        List associations = this.getEntity().getReferences();
        for (ERDAssociation attributeAssociation : associations) {
            EditPart editPart;
            if (!attributeAssociation.getTargetAttributes().contains(attribute)) continue;
            AssociationPart connectionPart = this.getConnectionPart(attributeAssociation, true);
            if (connectionPart == null && (editPart = this.getParent()) instanceof EntityPart) {
                EntityPart entityPart = (EntityPart)editPart;
                for (GraphicalEditPart entityAttribute : entityPart.getChildren()) {
                    for (Object o : entityAttribute.getTargetConnections()) {
                        AssociationPart entityAssociatonPart;
                        if (!(o instanceof AssociationPart) || !(entityAssociatonPart = (AssociationPart)o).getAssociation().equals(attributeAssociation)) continue;
                        parts.add(entityAssociatonPart);
                    }
                }
                continue;
            }
            parts.add(connectionPart);
        }
        return parts;
    }
}

