/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.navigator;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.ERDContentProvider;
import org.jkiss.dbeaver.erd.model.ERDPersistedState;
import org.jkiss.dbeaver.erd.model.navigator.DBNDiagram;
import org.jkiss.dbeaver.erd.model.navigator.DBNDiagramFolder;
import org.jkiss.dbeaver.erd.ui.editor.ERDEditorStandalone;
import org.jkiss.dbeaver.erd.ui.model.DiagramLoader;
import org.jkiss.dbeaver.erd.ui.model.ERDContentProviderDecorated;
import org.jkiss.dbeaver.erd.ui.model.ERDDecoratorDefault;
import org.jkiss.dbeaver.erd.ui.model.EntityDiagram;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.resources.AbstractResourceHandler;
import org.jkiss.dbeaver.utils.ResourceUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class ERDResourceHandler
extends AbstractResourceHandler {
    private static final Log log = Log.getLog(ERDResourceHandler.class);
    private static final String ERD_EXT = "erd";

    public static IFolder getDiagramsFolder(DBPProject project, boolean forceCreate) throws CoreException {
        return DBPPlatformDesktop.getInstance().getWorkspace().getResourceDefaultRoot(project, ERDResourceHandler.class, forceCreate);
    }

    public int getFeatures(IResource resource) {
        if (resource instanceof IFolder) {
            if (resource.getParent() instanceof IFolder) {
                return 30;
            }
            return 20;
        }
        return 11;
    }

    @NotNull
    public String getTypeName(@NotNull IResource resource) {
        if (resource instanceof IFolder) {
            return "diagram folder";
        }
        return "diagram";
    }

    @NotNull
    public DBNResource makeNavigatorNode(@NotNull DBNNode parentNode, @NotNull IResource resource) throws CoreException, DBException {
        if (resource instanceof IFile) {
            return new DBNDiagram(parentNode, resource, (DBPResourceHandler)this);
        }
        return new DBNDiagramFolder(parentNode, resource, (DBPResourceHandler)this);
    }

    public void openResource(@NotNull IResource resource) throws CoreException, DBException {
        if (!(resource instanceof IFile)) {
            super.openResource(resource);
            return;
        }
        FileEditorInput erdInput = new FileEditorInput((IFile)resource);
        UIUtils.getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)erdInput, ERDEditorStandalone.class.getName());
    }

    public static IFile createDiagram(EntityDiagram copyFrom, String title, IFolder folder, DBRProgressMonitor monitor) throws DBException {
        if (folder == null) {
            try {
                folder = ERDResourceHandler.getDiagramsFolder(DBWorkbench.getPlatform().getWorkspace().getActiveProject(), true);
            }
            catch (CoreException e) {
                throw new DBException("Can't obtain folder for diagram", (Throwable)e);
            }
        }
        if (folder == null) {
            throw new DBException("Can't detect folder for diagram");
        }
        ResourceUtils.checkFolderExists((IFolder)folder, (DBRProgressMonitor)monitor);
        IFile file = ResourceUtils.getUniqueFile((IFolder)folder, (String)CommonUtils.escapeFileName((String)title), (String)ERD_EXT);
        try {
            DBRRunnableWithProgress runnable = monitor1 -> {
                try {
                    EntityDiagram newDiagram = copyFrom == null ? new EntityDiagram(null, "<Diagram>", (ERDContentProvider)new ERDContentProviderDecorated(), new ERDDecoratorDefault()) : copyFrom.copy();
                    newDiagram.setName(title);
                    newDiagram.setLayoutManualAllowed(true);
                    newDiagram.setLayoutManualDesired(true);
                    String diagramState = DiagramLoader.serializeDiagram(monitor1, null, newDiagram, false, false);
                    ByteArrayInputStream data = new ByteArrayInputStream(diagramState.getBytes(StandardCharsets.UTF_8));
                    file.create((InputStream)data, true, RuntimeUtils.getNestedMonitor((DBRProgressMonitor)monitor1));
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            };
            if (monitor == null) {
                UIUtils.runInProgressService((DBRRunnableWithProgress)runnable);
            } else {
                runnable.run(monitor);
            }
        }
        catch (InvocationTargetException e) {
            throw new DBException("Error creating diagram", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
        return file;
    }

    @Nullable
    public List<DBPDataSourceContainer> getAssociatedDataSources(DBNResource resource) {
        if (resource.getResource() instanceof IFile) {
            try {
                IResource iResource = resource.getResource();
                DBPProject projectMeta = DBPPlatformDesktop.getInstance().getWorkspace().getProject(iResource.getProject());
                if (projectMeta == null) {
                    return Collections.emptyList();
                }
                if (iResource instanceof IFile) {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (InputStream is = ((IFile)iResource).getContents();){
                        return ERDPersistedState.extractContainers((DBPProject)projectMeta, (InputStream)is);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)e);
                return null;
            }
        }
        return super.getAssociatedDataSources(resource);
    }
}

