/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.clickhouse.edit;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.clickhouse.model.ClickhouseTable;
import org.jkiss.dbeaver.ext.generic.edit.GenericTableManager;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class ClickhouseTableManager
extends GenericTableManager {
    private static final Log log = Log.getLog(ClickhouseTableManager.class);

    protected String getDropTableType(GenericTableBase table) {
        return "TABLE";
    }

    protected void appendTableModifiers(DBRProgressMonitor monitor, GenericTableBase table, SQLObjectEditor.NestedObjectCommand tableProps, StringBuilder ddl, boolean alter) {
        if (table instanceof ClickhouseTable) {
            ClickhouseTable clickhouseTable = (ClickhouseTable)table;
            if (clickhouseTable.getEngine() != null) {
                ddl.append(" ENGINE = ").append(clickhouseTable.getEngine().getName());
                if (CommonUtils.isNotEmpty((String)clickhouseTable.getEngineMessage())) {
                    ddl.append("\n").append(clickhouseTable.getEngineMessage());
                }
            } else {
                try {
                    List attributes = table.getAttributes(monitor);
                    if (!CommonUtils.isEmpty((Collection)attributes)) {
                        ddl.append(" ENGINE = MergeTree()\nORDER BY ").append(DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)attributes.get(0))));
                    } else {
                        ddl.append(" ENGINE = Log");
                    }
                }
                catch (DBException dBException) {
                    log.debug((Object)("Can't read " + table.getName() + " columns"));
                }
            }
            if (!table.isPersisted() && tableProps.getProperty((Object)"description") != null && CommonUtils.isNotEmpty((String)table.getDescription())) {
                ddl.append("\nCOMMENT ").append(SQLUtils.quoteString((DBSObject)table, (String)table.getDescription()));
            }
        }
    }

    protected void addObjectExtraActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.NestedObjectCommand<GenericTableBase, SQLObjectEditor.PropertyHandler> command, @NotNull Map<String, Object> options) {
        GenericTableBase tableBase = (GenericTableBase)command.getObject();
        if (tableBase.isPersisted() && command.hasProperty((Object)"description")) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment table", "ALTER TABLE " + tableBase.getFullyQualifiedName(DBPEvaluationContext.DDL) + " MODIFY COMMENT " + SQLUtils.quoteString((DBSObject)tableBase, (String)CommonUtils.notEmpty((String)tableBase.getDescription()))));
        }
    }
}

