/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Tracker;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;

public final class ResizeableComposite
extends Composite {
    private final int style;
    private Control content;
    private Point minSize = new Point(0, 0);
    private Point prefSize = new Point(-1, -1);

    public ResizeableComposite(@NotNull Composite parent, int style) {
        super(parent, 0);
        Label dragger;
        boolean vertical;
        this.style = style;
        boolean horizontal = (style & 0x100) != 0;
        boolean bl = vertical = (style & 0x200) != 0;
        if (!horizontal && !vertical) {
            throw new IllegalArgumentException("Must specify at least one of HORIZONTAL or VERTICAL styles");
        }
        GridLayoutFactory.fillDefaults().numColumns(horizontal ? 2 : 1).spacing(0, 0).applyTo((Composite)this);
        if (horizontal) {
            dragger = new Label((Composite)this, 0);
            dragger.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            dragger.setCursor(this.getDisplay().getSystemCursor(9));
            dragger.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.SEPARATOR_V));
            dragger.addMouseListener(MouseListener.mouseDownAdapter(e -> this.update((MouseEvent)e, true)));
        }
        if (vertical) {
            dragger = new Label((Composite)this, 0);
            dragger.setLayoutData((Object)new GridData(0x1000000, 1, false, false));
            dragger.setCursor(this.getDisplay().getSystemCursor(7));
            dragger.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.SEPARATOR_H));
            dragger.addMouseListener(MouseListener.mouseDownAdapter(e -> this.update((MouseEvent)e, false)));
            if (horizontal) {
                ((GridData)dragger.getLayoutData()).horizontalSpan = 2;
            }
        }
    }

    public void setContent(@NotNull Control content) {
        this.checkWidget();
        this.content = content;
        this.content.moveAbove(null);
        this.updateLayoutData();
    }

    public void setMinSize(@NotNull Point minSize) {
        this.checkWidget();
        this.minSize = new Point(minSize.x, minSize.y);
        this.updateLayoutData();
    }

    public void setPrefSize(@NotNull Point prefSize) {
        this.checkWidget();
        this.prefSize = new Point(prefSize.x, prefSize.y);
        this.updateLayoutData();
    }

    private void updateLayoutData() {
        if (this.content != null) {
            this.content.setLayoutData((Object)this.createLayoutData());
            this.layout(true, true);
        }
    }

    @NotNull
    private GridData createLayoutData() {
        GridData data = new GridData(4, 4, (this.style & 0x100) == 0, (this.style & 0x200) == 0);
        if (this.minSize != null) {
            data.minimumWidth = this.minSize.x;
            data.minimumHeight = this.minSize.y;
        }
        if (this.prefSize != null) {
            data.widthHint = this.prefSize.x;
            data.heightHint = this.prefSize.y;
        }
        return data;
    }

    private void update(@NotNull MouseEvent e, boolean horizontal) {
        if (this.content == null) {
            return;
        }
        Point size = this.content.getSize();
        Control control = (Control)e.widget;
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        if (horizontal) {
            rectangle.width = control.getLocation().x + e.x;
            rectangle.height = size.y;
        } else {
            rectangle.width = size.x;
            rectangle.height = control.getLocation().y + e.y;
        }
        Tracker tracker = new Tracker((Composite)this, 0x10 | (horizontal ? 131072 : 1024));
        tracker.setStippled(true);
        tracker.setRectangles(new Rectangle[]{rectangle});
        if (tracker.open()) {
            GridData data = (GridData)this.content.getLayoutData();
            int adjustment = horizontal ? (data.widthHint != -1 ? size.x - data.widthHint : 0) : (data.heightHint != -1 ? size.y - data.heightHint : 0);
            int extra = horizontal ? rectangle.width - size.x : rectangle.height - size.y;
            Rectangle result = tracker.getRectangles()[0];
            tracker.dispose();
            if (horizontal) {
                int width = result.width - adjustment - extra;
                if (width == size.x) {
                    return;
                }
                data.widthHint = Math.max(width, data.minimumWidth);
            } else {
                int height = result.height - adjustment - extra;
                if (height == size.y) {
                    return;
                }
                data.heightHint = Math.max(height, data.minimumHeight);
            }
            this.layout(true, true);
        }
    }
}

