/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectPersistAction;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectType;
import org.jkiss.dbeaver.ext.oracle.model.OracleProcedureBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleSourceType;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.ext.oracle.model.source.OracleSourceObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class OracleProcedureStandalone
extends OracleProcedureBase<OracleSchema>
implements OracleSourceObject,
DBPRefreshableObject {
    private boolean valid;
    private String sourceDeclaration;

    public OracleProcedureStandalone(OracleSchema schema, ResultSet dbResult) {
        super(schema, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OBJECT_NAME"), JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"OBJECT_ID"), DBSProcedureType.valueOf((String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OBJECT_TYPE")));
        this.valid = "VALID".equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"STATUS"));
    }

    public OracleProcedureStandalone(OracleSchema oracleSchema, String name, DBSProcedureType procedureType) {
        super(oracleSchema, name, 0L, procedureType);
        this.sourceDeclaration = procedureType.name() + " " + name + GeneralUtils.getDefaultLineSeparator() + "IS" + GeneralUtils.getDefaultLineSeparator() + "BEGIN" + GeneralUtils.getDefaultLineSeparator() + "END " + name + ";" + GeneralUtils.getDefaultLineSeparator();
    }

    @Property(viewable=true, order=3)
    public boolean isValid() {
        return this.valid;
    }

    @Override
    @NotNull
    public OracleSchema getSchema() {
        return (OracleSchema)this.getParentObject();
    }

    @Override
    public OracleSourceType getSourceType() {
        return this.getProcedureType() == DBSProcedureType.PROCEDURE ? OracleSourceType.PROCEDURE : OracleSourceType.FUNCTION;
    }

    @Override
    public Integer getOverloadNumber() {
        return null;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getSchema(), this});
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBCException {
        if (this.sourceDeclaration == null && monitor != null) {
            this.sourceDeclaration = OracleUtils.getSource(monitor, this, false, true);
        }
        return this.sourceDeclaration;
    }

    public void setObjectDefinitionText(String sourceDeclaration) {
        this.sourceDeclaration = sourceDeclaration;
    }

    @Override
    public DBEPersistAction[] getCompileActions(DBRProgressMonitor monitor) {
        return new DBEPersistAction[]{new OracleObjectPersistAction(this.getProcedureType() == DBSProcedureType.PROCEDURE ? OracleObjectType.PROCEDURE : OracleObjectType.FUNCTION, "Compile procedure", "ALTER " + this.getSourceType().name() + " " + this.getFullyQualifiedName(DBPEvaluationContext.DDL) + " COMPILE")};
    }

    @NotNull
    public DBSObjectState getObjectState() {
        return this.valid ? DBSObjectState.NORMAL : DBSObjectState.INVALID;
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
        this.valid = OracleUtils.getObjectStatus(monitor, this, this.getProcedureType() == DBSProcedureType.PROCEDURE ? OracleObjectType.PROCEDURE : OracleObjectType.FUNCTION);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getSchema().proceduresCache.refreshObject(monitor, this.getSchema(), this);
    }
}

