/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.util.Date;
import java.util.Map;
import java.util.StringJoiner;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchemaObject;
import org.jkiss.dbeaver.ext.oracle.model.OracleSourceType;
import org.jkiss.dbeaver.ext.oracle.model.source.OracleSourceObject;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class OracleJob
extends OracleSchemaObject
implements OracleSourceObject {
    private long job;
    private String loginUser;
    private String privilegedUser;
    private String schemaUser;
    private Date lastDate;
    private Date thisDate;
    private String nextDate;
    private String interval;
    private long totalTime;
    private long failures;
    private long instance;
    private String action;
    private String nlsEnv;
    private boolean broken;

    public OracleJob(@NotNull OracleSchema schema, @NotNull ResultSet resultSet) {
        super(schema, String.valueOf(JDBCUtils.safeGetInt((ResultSet)resultSet, (String)"JOB")), true);
        this.job = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"JOB");
        this.loginUser = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"LOG_USER");
        this.privilegedUser = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"PRIV_USER");
        this.schemaUser = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"SCHEMA_USER");
        this.lastDate = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"LAST_DATE");
        this.thisDate = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"THIS_DATE");
        this.nextDate = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"NEXT_DATE");
        this.interval = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"INTERVAL");
        this.totalTime = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"TOTAL_TIME");
        this.failures = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"FAILURES");
        this.instance = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"INSTANCE");
        this.nlsEnv = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"NLS_ENV");
        this.action = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"WHAT");
        this.broken = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"BROKEN", (String)"Y");
    }

    public OracleJob(OracleSchema schema, String name) {
        super(schema, name, false);
    }

    public long getJob() {
        return this.job;
    }

    @Property(viewable=true, order=11)
    @Nullable
    public String getLoginUser() {
        return this.loginUser;
    }

    @Property(viewable=true, order=12)
    @Nullable
    public String getPrivilegedUser() {
        return this.privilegedUser;
    }

    @Property(viewable=true, order=13)
    @Nullable
    public String getSchemaUser() {
        return this.schemaUser;
    }

    @Property(viewable=true, order=14)
    @Nullable
    public Date getLastDate() {
        return this.lastDate;
    }

    @Property(viewable=true, order=15)
    public Date getThisDate() {
        return this.thisDate;
    }

    @Property(viewable=true, order=16, updatable=true, editable=true)
    @Nullable
    public String getNextDate() {
        return this.broken ? null : this.nextDate;
    }

    public void setNextDate(String nextDate) {
        this.nextDate = nextDate;
    }

    @Property(viewable=true, order=17, updatable=true, editable=true)
    @Nullable
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    @Property(viewable=true, order=18)
    public String getTotalTime() {
        return RuntimeUtils.formatExecutionTime((long)this.totalTime);
    }

    @Property(viewable=true, order=19)
    public long getFailures() {
        return this.failures;
    }

    @Property(viewable=true, order=20)
    public long getInstance() {
        return this.instance;
    }

    @Property(viewable=true, order=21, updatable=true, editable=true)
    @Nullable
    public String getNlsEnv() {
        return this.nlsEnv;
    }

    public void setNlsEnv(String nlsEnv) {
        this.nlsEnv = nlsEnv;
    }

    @Property(viewable=true, order=22, updatable=true)
    public boolean isBroken() {
        return this.broken;
    }

    public void setBroken(boolean broken) {
        this.broken = broken;
    }

    @Property(viewable=true, order=23, updatable=true, editable=true, length=PropertyLength.MULTILINE)
    @Nullable
    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    @Override
    public OracleSourceType getSourceType() {
        return OracleSourceType.JOB;
    }

    @Override
    public DBEPersistAction[] getCompileActions(DBRProgressMonitor monitor) {
        return new DBEPersistAction[0];
    }

    @Override
    public boolean supportsCompile() {
        return false;
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (this.job == 0L) {
            return "";
        }
        StringJoiner args = new StringJoiner(",\n\t");
        args.add("job => " + SQLUtils.quoteString((DBSObject)this, (String)this.name));
        args.add("what => " + SQLUtils.quoteString((DBSObject)this, (String)this.action));
        args.add("next_date => TO_DATE(%s)".formatted(SQLUtils.quoteString((DBSObject)this, (String)CommonUtils.escapeDisplayString((String)this.nextDate))));
        args.add("interval => " + SQLUtils.quoteString((DBSObject)this, (String)CommonUtils.escapeDisplayString((String)this.interval)));
        String brokenStatement = String.format("DBMS_JOB.BROKEN(%s, %s);", this.job, this.broken ? "TRUE" : "FALSE");
        return "BEGIN\n  DBMS_JOB.SUBMIT(\n    %s\n  );\n  %s\n  COMMIT;\nEND;\n".formatted(args, brokenStatement);
    }

    public void setObjectDefinitionText(String source) {
    }

    @NotNull
    public DBSObjectState getObjectState() {
        return this.broken ? DBSObjectState.INVALID : DBSObjectState.NORMAL;
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
    }
}

