/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.compat.DbCompat;
import com.sleepycat.persist.impl.Accessor;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EnhancedAccessor;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Evolver;
import com.sleepycat.persist.impl.FieldInfo;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.RawAccessor;
import com.sleepycat.persist.impl.RawComplexInput;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.RecordOutput;
import com.sleepycat.persist.impl.ReflectionAccessor;
import com.sleepycat.persist.impl.RefreshException;
import com.sleepycat.persist.impl.SimpleCatalog;
import com.sleepycat.persist.model.ClassMetadata;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.model.FieldMetadata;
import com.sleepycat.persist.raw.RawField;
import com.sleepycat.persist.raw.RawObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class CompositeKeyFormat
extends Format {
    private static final long serialVersionUID = 306843428409314630L;
    private ClassMetadata metadata;
    private List<FieldInfo> fields;
    private transient Accessor objAccessor;
    private transient Accessor rawAccessor;
    private volatile transient Map<String, RawField> rawFields;
    private volatile transient FieldInfo[] rawInputFields;

    static String[] getFieldNameArray(List<FieldMetadata> list) {
        int n = 0;
        String[] stringArray = new String[list.size()];
        for (FieldMetadata fieldMetadata : list) {
            stringArray[n] = fieldMetadata.getName();
            ++n;
        }
        return stringArray;
    }

    CompositeKeyFormat(Catalog catalog, Class clazz, ClassMetadata classMetadata, List<FieldMetadata> list) {
        this(catalog, clazz, classMetadata, CompositeKeyFormat.getFieldNameArray(list));
    }

    CompositeKeyFormat(Catalog catalog, Class clazz, String[] stringArray) {
        this(catalog, clazz, null, stringArray);
    }

    private CompositeKeyFormat(Catalog catalog, Class clazz, ClassMetadata classMetadata, String[] stringArray) {
        super(catalog, clazz);
        this.metadata = classMetadata;
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != Object.class) {
            throw new IllegalArgumentException("Composite key class must be derived from Object: " + clazz.getName());
        }
        List<FieldInfo> list = FieldInfo.getInstanceFields(clazz, classMetadata);
        this.fields = new ArrayList<FieldInfo>(list.size());
        for (String string : stringArray) {
            FieldInfo fieldInfo = null;
            for (FieldInfo fieldInfo2 : list) {
                if (!string.equals(fieldInfo2.getName())) continue;
                fieldInfo = fieldInfo2;
                break;
            }
            if (fieldInfo == null) {
                throw new IllegalArgumentException("Composite key field is not an instance field: " + this.getClassName() + '.' + string);
            }
            this.fields.add(fieldInfo);
            list.remove(fieldInfo);
            Class clazz3 = fieldInfo.getFieldClass(this.getCatalog());
            if (SimpleCatalog.isSimpleType(clazz3) || clazz3.isEnum()) continue;
            throw new IllegalArgumentException("Composite key field is not a simple type or enum: " + this.getClassName() + '.' + string);
        }
        if (list.size() > 0) {
            throw new IllegalArgumentException("All composite key instance fields must be key fields: " + this.getClassName() + '.' + list.get(0).getName());
        }
    }

    List<FieldInfo> getFieldInfo() {
        return this.fields;
    }

    @Override
    void migrateFromBeta(Map<String, Format> map) {
        super.migrateFromBeta(map);
        for (FieldInfo fieldInfo : this.fields) {
            fieldInfo.migrateFromBeta(map);
        }
    }

    @Override
    boolean isModelClass() {
        return true;
    }

    @Override
    public ClassMetadata getClassMetadata() {
        if (this.metadata == null) {
            throw DbCompat.unexpectedState(this.getClassName());
        }
        return this.metadata;
    }

    @Override
    public Map<String, RawField> getFields() {
        if (this.rawFields == null) {
            HashMap<String, RawField> hashMap = new HashMap<String, RawField>();
            for (FieldInfo fieldInfo : this.fields) {
                hashMap.put(fieldInfo.getName(), fieldInfo);
            }
            this.rawFields = hashMap;
        }
        return this.rawFields;
    }

    @Override
    void collectRelatedFormats(Catalog catalog, Map<String, Format> map) {
        for (FieldInfo fieldInfo : this.fields) {
            fieldInfo.collectRelatedFormats(catalog, map);
        }
    }

    @Override
    void initialize(Catalog catalog, EntityModel entityModel, int n) {
        for (FieldInfo fieldInfo : this.fields) {
            fieldInfo.initialize(catalog, entityModel, n);
        }
        Class clazz = this.getType();
        if (clazz != null) {
            this.objAccessor = EnhancedAccessor.isEnhanced(clazz) ? new EnhancedAccessor(catalog, clazz, this.fields) : new ReflectionAccessor(catalog, clazz, this.fields);
        }
        this.rawAccessor = new RawAccessor(this, this.fields);
    }

    @Override
    Object newArray(int n) {
        return this.objAccessor.newArray(n);
    }

    @Override
    public Object newInstance(EntityInput entityInput, boolean bl) {
        Accessor accessor = bl ? this.rawAccessor : this.objAccessor;
        return accessor.newInstance();
    }

    @Override
    public Object readObject(Object object, EntityInput entityInput, boolean bl) throws RefreshException {
        Accessor accessor = bl ? this.rawAccessor : this.objAccessor;
        accessor.readCompositeKeyFields(object, entityInput);
        return object;
    }

    @Override
    void writeObject(Object object, EntityOutput entityOutput, boolean bl) throws RefreshException {
        Accessor accessor = bl ? this.rawAccessor : this.objAccessor;
        accessor.writeCompositeKeyFields(object, entityOutput);
    }

    @Override
    Object convertRawObject(Catalog catalog, boolean bl, RawObject rawObject, IdentityHashMap identityHashMap) throws RefreshException {
        FieldInfo[] fieldInfoArray = this.rawInputFields;
        if (fieldInfoArray == null) {
            fieldInfoArray = new FieldInfo[this.fields.size()];
            this.fields.toArray(fieldInfoArray);
            this.rawInputFields = fieldInfoArray;
        }
        if (rawObject.getSuper() != null) {
            throw new IllegalArgumentException("RawObject has too many superclasses: " + rawObject.getType().getClassName());
        }
        Object[] objectArray = new RawObject[fieldInfoArray.length];
        Arrays.fill(objectArray, rawObject);
        RawComplexInput rawComplexInput = new RawComplexInput(catalog, bl, identityHashMap, fieldInfoArray, (RawObject[])objectArray);
        Object object = this.newInstance(rawComplexInput, bl);
        identityHashMap.put(rawObject, object);
        return this.readObject(object, rawComplexInput, bl);
    }

    @Override
    void skipContents(RecordInput recordInput) throws RefreshException {
        int n = this.fields.size();
        for (int i = 0; i < n; ++i) {
            this.fields.get(i).getType().skipContents(recordInput);
        }
    }

    @Override
    void copySecKey(RecordInput recordInput, RecordOutput recordOutput) {
        int n = this.fields.size();
        for (int i = 0; i < n; ++i) {
            this.fields.get(i).getType().copySecKey(recordInput, recordOutput);
        }
    }

    @Override
    Format getSequenceKeyFormat() {
        if (this.fields.size() != 1) {
            throw new IllegalArgumentException("A composite key class used with a sequence may contain only a single key field: " + this.getClassName());
        }
        return this.fields.get(0).getType().getSequenceKeyFormat();
    }

    @Override
    boolean evolve(Format format, Evolver evolver) {
        if (!(format instanceof CompositeKeyFormat)) {
            evolver.addEvolveError(this, format, null, "A composite key class may not be changed to a different type");
            return false;
        }
        CompositeKeyFormat compositeKeyFormat = (CompositeKeyFormat)format;
        if (this.fields.size() != compositeKeyFormat.fields.size()) {
            evolver.addEvolveError(this, compositeKeyFormat, "Composite key class fields were added or removed ", "Old fields: " + this.fields + " new fields: " + compositeKeyFormat.fields);
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < this.fields.size(); ++i) {
            int n = evolver.evolveRequiredKeyField(this, compositeKeyFormat, this.fields.get(i), compositeKeyFormat.fields.get(i));
            if (n == 2) {
                return false;
            }
            if (n != 1) continue;
            bl = true;
        }
        if (bl) {
            evolver.useEvolvedFormat(this, compositeKeyFormat, compositeKeyFormat);
        } else {
            evolver.useOldFormat(this, compositeKeyFormat);
        }
        return true;
    }
}

