/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

public final class DatabaseType {
    public static final DatabaseType BTREE = new DatabaseType("BTREE", 1);
    public static final DatabaseType HASH = new DatabaseType("HASH", 2);
    public static final DatabaseType HEAP = new DatabaseType("HEAP", 6);
    public static final DatabaseType QUEUE = new DatabaseType("QUEUE", 4);
    public static final DatabaseType RECNO = new DatabaseType("RECNO", 3);
    public static final DatabaseType UNKNOWN = new DatabaseType("UNKNOWN", 5);
    private String statusName;
    private int id;

    static DatabaseType fromInt(int n) {
        switch (n) {
            case 1: {
                return BTREE;
            }
            case 2: {
                return HASH;
            }
            case 6: {
                return HEAP;
            }
            case 4: {
                return QUEUE;
            }
            case 3: {
                return RECNO;
            }
            case 5: {
                return UNKNOWN;
            }
        }
        throw new IllegalArgumentException("Unknown database type: " + n);
    }

    private DatabaseType(String string, int n) {
        this.statusName = string;
        this.id = n;
    }

    int getId() {
        return this.id;
    }

    public String toString() {
        return "DatabaseType." + this.statusName;
    }
}

