/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.BtreeCompressor;
import com.sleepycat.db.BtreePrefixCalculator;
import com.sleepycat.db.CacheFilePriority;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.DatabaseType;
import com.sleepycat.db.ErrorHandler;
import com.sleepycat.db.FeedbackHandler;
import com.sleepycat.db.Hasher;
import com.sleepycat.db.MessageHandler;
import com.sleepycat.db.MultipleDataEntry;
import com.sleepycat.db.PanicHandler;
import com.sleepycat.db.PartitionHandler;
import com.sleepycat.db.RecordNumberAppender;
import com.sleepycat.db.internal.Db;
import com.sleepycat.db.internal.DbEnv;
import com.sleepycat.db.internal.DbTxn;
import com.sleepycat.db.internal.DbUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.util.Comparator;

public class DatabaseConfig
implements Cloneable {
    public static final DatabaseConfig DEFAULT = new DatabaseConfig();
    private DatabaseType type = DatabaseType.UNKNOWN;
    private int mode = 420;
    private int btMinKey = 0;
    private int byteOrder = 0;
    private long cacheSize = 0L;
    private File createDir = null;
    private int cacheCount = 0;
    private OutputStream errorStream = null;
    private String errorPrefix = null;
    private int hashFillFactor = 0;
    private int hashNumElements = 0;
    private long heapSize = 0L;
    private int heapRegionSize = 0;
    private OutputStream messageStream = null;
    private Boolean noWaitDbExclusiveLock = null;
    private int pageSize = 0;
    private File[] partitionDirs = null;
    private DatabaseEntry partitionKeys = null;
    private int partitionParts = 0;
    private String password = null;
    private CacheFilePriority priority = null;
    private int queueExtentSize = 0;
    private int recordDelimiter = 0;
    private int recordLength = 0;
    private int recordPad = -1;
    private File recordSource = null;
    private boolean allowCreate = false;
    private boolean btreeRecordNumbers = false;
    private boolean checksum = false;
    private boolean readUncommitted = false;
    private boolean encrypted = false;
    private boolean exclusiveCreate = false;
    private boolean multiversion = false;
    private boolean noMMap = false;
    private boolean queueInOrder = false;
    private boolean readOnly = false;
    private boolean renumbering = false;
    private boolean reverseSplitOff = false;
    private boolean sortedDuplicates = false;
    private boolean snapshot = false;
    private boolean unsortedDuplicates = false;
    private boolean transactional = false;
    private boolean transactionNotDurable = false;
    private boolean truncate = false;
    private Comparator btreeComparator = null;
    private BtreeCompressor btreeCompressor = null;
    private BtreePrefixCalculator btreePrefixCalculator = null;
    private Comparator duplicateComparator = null;
    private FeedbackHandler feedbackHandler = null;
    private ErrorHandler errorHandler = null;
    private MessageHandler messageHandler = null;
    private PartitionHandler partitionHandler = null;
    private Comparator hashComparator = null;
    private Hasher hasher = null;
    private RecordNumberAppender recnoAppender = null;
    private PanicHandler panicHandler = null;

    static DatabaseConfig checkNull(DatabaseConfig databaseConfig) {
        return databaseConfig == null ? DEFAULT : databaseConfig;
    }

    public DatabaseConfig() {
    }

    public DatabaseConfig cloneConfig() {
        try {
            return (DatabaseConfig)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void setAllowCreate(boolean bl) {
        this.allowCreate = bl;
    }

    public boolean getAllowCreate() {
        return this.allowCreate;
    }

    public void setBtreeComparator(Comparator comparator) {
        this.btreeComparator = comparator;
    }

    public Comparator getBtreeComparator() {
        return this.btreeComparator;
    }

    public void setBtreeMinKey(int n) {
        this.btMinKey = n;
    }

    public int getBtreeMinKey() {
        return this.btMinKey;
    }

    public void setByteOrder(int n) {
        this.byteOrder = n;
    }

    public int getByteOrder() {
        return this.byteOrder;
    }

    public boolean getByteSwapped() {
        return this.byteOrder != 0 && this.byteOrder != DbUtil.default_lorder();
    }

    public void setBtreeCompressor(BtreeCompressor btreeCompressor) {
        this.btreeCompressor = btreeCompressor;
    }

    public BtreeCompressor getBtreeCompressor() {
        return this.btreeCompressor;
    }

    public void setBtreePrefixCalculator(BtreePrefixCalculator btreePrefixCalculator) {
        this.btreePrefixCalculator = btreePrefixCalculator;
    }

    public BtreePrefixCalculator getBtreePrefixCalculator() {
        return this.btreePrefixCalculator;
    }

    public void setCacheSize(long l) {
        this.cacheSize = l;
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public void setCreateDir(File file) {
        this.createDir = file;
    }

    public File getCreateDir() {
        return this.createDir;
    }

    public void setCacheCount(int n) {
        this.cacheCount = n;
    }

    public int getCacheCount() {
        return this.cacheCount;
    }

    public void setChecksum(boolean bl) {
        this.checksum = bl;
    }

    public boolean getChecksum() {
        return this.checksum;
    }

    public void setReadUncommitted(boolean bl) {
        this.readUncommitted = bl;
    }

    public boolean getReadUncommitted() {
        return this.readUncommitted;
    }

    public void setDirtyRead(boolean bl) {
        this.setReadUncommitted(bl);
    }

    public boolean getDirtyRead() {
        return this.getReadUncommitted();
    }

    public void setDuplicateComparator(Comparator comparator) {
        this.duplicateComparator = comparator;
    }

    public Comparator getDuplicateComparator() {
        return this.duplicateComparator;
    }

    public void setEncrypted(String string) {
        this.password = string;
    }

    public boolean getEncrypted() {
        return this.password != null;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorPrefix(String string) {
        this.errorPrefix = string;
    }

    public String getErrorPrefix() {
        return this.errorPrefix;
    }

    public void setErrorStream(OutputStream outputStream) {
        this.errorStream = outputStream;
    }

    public OutputStream getErrorStream() {
        return this.errorStream;
    }

    public void setExclusiveCreate(boolean bl) {
        this.exclusiveCreate = bl;
    }

    public boolean getExclusiveCreate() {
        return this.exclusiveCreate;
    }

    public void setFeedbackHandler(FeedbackHandler feedbackHandler) {
        this.feedbackHandler = feedbackHandler;
    }

    public FeedbackHandler getFeedbackHandler() {
        return this.feedbackHandler;
    }

    public void setHashFillFactor(int n) {
        this.hashFillFactor = n;
    }

    public int getHashFillFactor() {
        return this.hashFillFactor;
    }

    public void setHashComparator(Comparator comparator) {
        this.hashComparator = comparator;
    }

    public Comparator getHashComparator() {
        return this.hashComparator;
    }

    public void setHasher(Hasher hasher) {
        this.hasher = hasher;
    }

    public Hasher getHasher() {
        return this.hasher;
    }

    public void setHashNumElements(int n) {
        this.hashNumElements = n;
    }

    public int getHashNumElements() {
        return this.hashNumElements;
    }

    public void setHeapsize(long l) {
        this.heapSize = l;
    }

    public long getHeapsize() {
        return this.heapSize;
    }

    public void setHeapRegionSize(int n) {
        this.heapRegionSize = n;
    }

    public long getHeapRegionSize() {
        return this.heapRegionSize;
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setMessageStream(OutputStream outputStream) {
        this.messageStream = outputStream;
    }

    public OutputStream getMessageStream() {
        return this.messageStream;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public long getMode() {
        return this.mode;
    }

    public void setMultiversion(boolean bl) {
        this.multiversion = bl;
    }

    public boolean getMultiversion() {
        return this.multiversion;
    }

    public void setNoMMap(boolean bl) {
        this.noMMap = bl;
    }

    public boolean getNoMMap() {
        return this.noMMap;
    }

    public void setNoWaitDbExclusiveLock(Boolean bl) {
        this.noWaitDbExclusiveLock = bl;
    }

    public Boolean getNoWaitDbExclusiveLock() {
        return this.noWaitDbExclusiveLock;
    }

    public void setPageSize(int n) {
        this.pageSize = n;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPanicHandler(PanicHandler panicHandler) {
        this.panicHandler = panicHandler;
    }

    public PanicHandler getPanicHandler() {
        return this.panicHandler;
    }

    public void setPartitionByCallback(int n, PartitionHandler partitionHandler) {
        this.partitionParts = n;
        this.partitionHandler = partitionHandler;
    }

    public void setPartitionByRange(int n, MultipleDataEntry multipleDataEntry) {
        this.partitionParts = n;
        this.partitionKeys = multipleDataEntry;
    }

    public PartitionHandler getPartitionHandler() {
        return this.partitionHandler;
    }

    public int getPartitionParts() {
        return this.partitionParts;
    }

    public DatabaseEntry getPartitionKeys() {
        return this.partitionKeys;
    }

    public void setPartitionDirs(File[] fileArray) {
        this.partitionDirs = fileArray;
    }

    public File[] getPartitionDirs() {
        return this.partitionDirs;
    }

    public void setPriority(CacheFilePriority cacheFilePriority) {
        this.priority = cacheFilePriority;
    }

    public CacheFilePriority getPriority() {
        return this.priority;
    }

    public void setQueueExtentSize(int n) {
        this.queueExtentSize = n;
    }

    public int getQueueExtentSize() {
        return this.queueExtentSize;
    }

    public void setQueueInOrder(boolean bl) {
        this.queueInOrder = bl;
    }

    public boolean getQueueInOrder() {
        return this.queueInOrder;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setRecordNumberAppender(RecordNumberAppender recordNumberAppender) {
        this.recnoAppender = recordNumberAppender;
    }

    public RecordNumberAppender getRecordNumberAppender() {
        return this.recnoAppender;
    }

    public void setRecordDelimiter(int n) {
        this.recordDelimiter = n;
    }

    public int getRecordDelimiter() {
        return this.recordDelimiter;
    }

    public void setRecordLength(int n) {
        this.recordLength = n;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public void setBtreeRecordNumbers(boolean bl) {
        this.btreeRecordNumbers = bl;
    }

    public boolean getBtreeRecordNumbers() {
        return this.btreeRecordNumbers;
    }

    public void setRecordPad(int n) {
        this.recordPad = n;
    }

    public int getRecordPad() {
        return this.recordPad;
    }

    public void setRecordSource(File file) {
        this.recordSource = file;
    }

    public File getRecordSource() {
        return this.recordSource;
    }

    public void setRenumbering(boolean bl) {
        this.renumbering = bl;
    }

    public boolean getRenumbering() {
        return this.renumbering;
    }

    public void setReverseSplitOff(boolean bl) {
        this.reverseSplitOff = bl;
    }

    public boolean getReverseSplitOff() {
        return this.reverseSplitOff;
    }

    public void setSortedDuplicates(boolean bl) {
        this.sortedDuplicates = bl;
    }

    public boolean getSortedDuplicates() {
        return this.sortedDuplicates;
    }

    public void setUnsortedDuplicates(boolean bl) {
        this.unsortedDuplicates = bl;
    }

    public boolean getUnsortedDuplicates() {
        return this.unsortedDuplicates;
    }

    public void setSnapshot(boolean bl) {
        this.snapshot = bl;
    }

    public boolean getSnapshot() {
        return this.snapshot;
    }

    public boolean getTransactional() {
        return this.transactional;
    }

    public void setTransactional(boolean bl) {
        this.transactional = bl;
    }

    public void setTransactionNotDurable(boolean bl) {
        this.transactionNotDurable = bl;
    }

    public boolean getTransactionNotDurable() {
        return this.transactionNotDurable;
    }

    public void setTruncate(boolean bl) {
        this.truncate = bl;
    }

    public boolean getTruncate() {
        return this.truncate;
    }

    public void setType(DatabaseType databaseType) {
        this.type = databaseType;
    }

    public DatabaseType getType() {
        return this.type;
    }

    Db createDatabase(DbEnv dbEnv) throws DatabaseException {
        return new Db(dbEnv, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Db openDatabase(DbEnv dbEnv, DbTxn dbTxn, String string, String string2) throws DatabaseException, FileNotFoundException {
        Db db = this.createDatabase(dbEnv);
        boolean bl = dbEnv == null || (dbEnv.get_open_flags() & 0x20) != 0;
        int n = 0;
        n |= this.allowCreate ? 1 : 0;
        n |= this.readUncommitted ? 512 : 0;
        n |= this.exclusiveCreate ? 4 : 0;
        n |= this.multiversion ? 8 : 0;
        n |= this.noMMap ? 16 : 0;
        n |= this.readOnly ? 1024 : 0;
        n |= bl ? 32 : 0;
        n |= this.truncate ? 131072 : 0;
        if (this.transactional && dbTxn == null) {
            n |= 0x100;
        }
        boolean bl2 = false;
        try {
            this.configureDatabase(db, DEFAULT);
            db.open(dbTxn, string, string2, this.type.getId(), n, this.mode);
            bl2 = true;
            Db db2 = db;
            return db2;
        }
        finally {
            if (!bl2) {
                try {
                    db.close(0);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    void configureDatabase(Db db, DatabaseConfig databaseConfig) throws DatabaseException {
        int n = 0;
        n |= this.checksum ? 8 : 0;
        n |= this.btreeRecordNumbers ? 64 : 0;
        n |= this.queueInOrder ? 32 : 0;
        n |= this.renumbering ? 128 : 0;
        n |= this.reverseSplitOff ? 256 : 0;
        n |= this.sortedDuplicates ? 2 : 0;
        n |= this.snapshot ? 512 : 0;
        n |= this.unsortedDuplicates ? 16 : 0;
        n |= this.transactionNotDurable ? 4 : 0;
        if (!db.getPrivateDbEnv()) {
            n |= this.password != null ? 1 : 0;
        }
        if (n != 0) {
            db.set_flags(n);
        }
        if (this.btMinKey != databaseConfig.btMinKey) {
            db.set_bt_minkey(this.btMinKey);
        }
        if (this.byteOrder != databaseConfig.byteOrder) {
            db.set_lorder(this.byteOrder);
        }
        if ((this.cacheSize != databaseConfig.cacheSize || this.cacheCount != databaseConfig.cacheCount) && db.getPrivateDbEnv()) {
            db.set_cachesize(this.cacheSize, this.cacheCount);
        }
        if (this.createDir != databaseConfig.createDir && this.createDir != null && !this.createDir.equals(databaseConfig.createDir)) {
            db.set_create_dir(this.createDir.toString());
        }
        if (this.errorStream != databaseConfig.errorStream) {
            db.set_error_stream(this.errorStream);
        }
        if (this.errorPrefix != databaseConfig.errorPrefix) {
            db.set_errpfx(this.errorPrefix);
        }
        if (this.hashFillFactor != databaseConfig.hashFillFactor) {
            db.set_h_ffactor(this.hashFillFactor);
        }
        if (this.hashNumElements != databaseConfig.hashNumElements) {
            db.set_h_nelem(this.hashNumElements);
        }
        if (this.heapSize != databaseConfig.heapSize) {
            db.set_heapsize(this.heapSize);
        }
        if (this.heapRegionSize != databaseConfig.heapRegionSize) {
            db.set_heap_regionsize(this.heapRegionSize);
        }
        if (this.messageStream != databaseConfig.messageStream) {
            db.set_message_stream(this.messageStream);
        }
        if (this.pageSize != databaseConfig.pageSize) {
            db.set_pagesize(this.pageSize);
        }
        if (this.partitionDirs != null && this.partitionDirs != databaseConfig.partitionDirs) {
            String[] stringArray = new String[this.partitionDirs.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = this.partitionDirs[i].toString();
            }
            db.set_partition_dirs(stringArray);
        }
        if (this.password != databaseConfig.password && db.getPrivateDbEnv()) {
            db.set_encrypt(this.password, 1);
        }
        if (this.priority != databaseConfig.priority) {
            db.set_priority(this.priority.getFlag());
        }
        if (this.queueExtentSize != databaseConfig.queueExtentSize) {
            db.set_q_extentsize(this.queueExtentSize);
        }
        if (this.recordDelimiter != databaseConfig.recordDelimiter) {
            db.set_re_delim(this.recordDelimiter);
        }
        if (this.recordLength != databaseConfig.recordLength) {
            db.set_re_len(this.recordLength);
        }
        if (this.recordPad != databaseConfig.recordPad) {
            db.set_re_pad(this.recordPad);
        }
        if (this.recordSource != databaseConfig.recordSource) {
            db.set_re_source(this.recordSource == null ? null : this.recordSource.toString());
        }
        if (this.noWaitDbExclusiveLock != null && databaseConfig.noWaitDbExclusiveLock != this.noWaitDbExclusiveLock) {
            db.set_lk_exclusive(this.noWaitDbExclusiveLock != false ? 1 : 0);
        }
        if (this.btreeComparator != databaseConfig.btreeComparator) {
            db.set_bt_compare(this.btreeComparator);
        }
        if (this.btreeCompressor != databaseConfig.btreeCompressor) {
            db.set_bt_compress(this.btreeCompressor, this.btreeCompressor);
        }
        if (this.btreePrefixCalculator != databaseConfig.btreePrefixCalculator) {
            db.set_bt_prefix(this.btreePrefixCalculator);
        }
        if (this.duplicateComparator != databaseConfig.duplicateComparator) {
            db.set_dup_compare(this.duplicateComparator);
        }
        if (this.feedbackHandler != databaseConfig.feedbackHandler) {
            db.set_feedback(this.feedbackHandler);
        }
        if (this.errorHandler != databaseConfig.errorHandler) {
            db.set_errcall(this.errorHandler);
        }
        if (this.hashComparator != databaseConfig.hashComparator) {
            db.set_h_compare(this.hashComparator);
        }
        if (this.hasher != databaseConfig.hasher) {
            db.set_h_hash(this.hasher);
        }
        if (this.messageHandler != databaseConfig.messageHandler) {
            db.set_msgcall(this.messageHandler);
        }
        if (this.partitionHandler != databaseConfig.partitionHandler || this.partitionKeys != databaseConfig.partitionKeys || this.partitionParts != databaseConfig.partitionParts) {
            db.set_partition(this.partitionParts, this.partitionKeys, this.partitionHandler);
        }
        if (this.recnoAppender != databaseConfig.recnoAppender) {
            db.set_append_recno(this.recnoAppender);
        }
        if (this.panicHandler != databaseConfig.panicHandler) {
            db.set_paniccall(this.panicHandler);
        }
    }

    DatabaseConfig(Db db) throws DatabaseException {
        int n;
        this.type = DatabaseType.fromInt(db.get_type());
        int n2 = db.get_open_flags();
        this.allowCreate = (n2 & 1) != 0;
        this.readUncommitted = (n2 & 0x200) != 0;
        this.exclusiveCreate = (n2 & 4) != 0;
        this.multiversion = (n2 & 8) != 0;
        this.noMMap = (n2 & 0x10) != 0;
        this.readOnly = (n2 & 0x400) != 0;
        this.truncate = (n2 & 0x20000) != 0;
        int n3 = db.get_flags();
        this.checksum = (n3 & 8) != 0;
        this.btreeRecordNumbers = (n3 & 0x40) != 0;
        this.queueInOrder = (n3 & 0x20) != 0;
        this.renumbering = (n3 & 0x80) != 0;
        this.reverseSplitOff = (n3 & 0x100) != 0;
        this.sortedDuplicates = (n3 & 2) != 0;
        this.snapshot = (n3 & 0x200) != 0;
        this.unsortedDuplicates = !this.sortedDuplicates && (n3 & 0x10) != 0;
        boolean bl = this.transactionNotDurable = (n3 & 4) != 0;
        if (this.type == DatabaseType.BTREE) {
            this.btMinKey = db.get_bt_minkey();
        }
        this.byteOrder = db.get_lorder();
        this.cacheSize = db.get_env().get_cachesize();
        this.cacheCount = db.get_env().get_cachesize_ncache();
        this.errorStream = db.get_error_stream();
        this.errorPrefix = db.get_errpfx();
        if (this.type == DatabaseType.HASH) {
            this.hashFillFactor = db.get_h_ffactor();
            this.hashNumElements = db.get_h_nelem();
        }
        if (this.type == DatabaseType.HEAP) {
            this.heapSize = db.get_heapsize();
            this.heapRegionSize = db.get_heap_regionsize();
        }
        this.messageStream = db.get_message_stream();
        this.pageSize = db.get_pagesize();
        this.password = (n3 & 1) != 0 ? "" : null;
        this.priority = CacheFilePriority.fromFlag(db.get_priority());
        if (this.type == DatabaseType.QUEUE) {
            this.queueExtentSize = db.get_q_extentsize();
        }
        if (this.type == DatabaseType.QUEUE || this.type == DatabaseType.RECNO) {
            this.recordLength = db.get_re_len();
            this.recordPad = db.get_re_pad();
        }
        if (this.type == DatabaseType.RECNO) {
            this.recordDelimiter = db.get_re_delim();
            this.recordSource = db.get_re_source() == null ? null : new File(db.get_re_source());
        }
        this.transactional = db.get_transactional();
        this.createDir = db.get_create_dir() == null ? null : new File(db.get_create_dir());
        String[] stringArray = db.get_partition_dirs();
        if (stringArray == null) {
            this.partitionDirs = null;
        } else {
            this.partitionDirs = new File[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                this.partitionDirs[n] = new File(stringArray[n]);
            }
        }
        n = db.get_lk_exclusive();
        this.noWaitDbExclusiveLock = n == 2 ? Boolean.TRUE : (n == 1 ? Boolean.FALSE : null);
        this.btreeComparator = db.get_bt_compare();
        this.btreeCompressor = db.get_bt_compress();
        this.btreePrefixCalculator = db.get_bt_prefix();
        this.duplicateComparator = db.get_dup_compare();
        this.feedbackHandler = db.get_feedback();
        this.errorHandler = db.get_errcall();
        this.hashComparator = db.get_h_compare();
        this.hasher = db.get_h_hash();
        this.messageHandler = db.get_msgcall();
        this.partitionParts = db.get_partition_parts();
        this.partitionKeys = db.get_partition_keys();
        this.partitionHandler = db.get_partition_callback();
        this.recnoAppender = db.get_append_recno();
        this.panicHandler = db.get_paniccall();
    }
}

