/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.MarshalledTupleEntry;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.util.RuntimeExceptionWrapper;

public class TupleMarshalledBinding<E extends MarshalledTupleEntry>
extends TupleBinding<E> {
    private Class<E> cls;

    public TupleMarshalledBinding(Class<E> clazz) {
        this.cls = clazz;
        if (!MarshalledTupleEntry.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz.toString() + " does not implement MarshalledTupleEntry");
        }
    }

    @Override
    public E entryToObject(TupleInput tupleInput) {
        try {
            MarshalledTupleEntry marshalledTupleEntry = (MarshalledTupleEntry)this.cls.newInstance();
            marshalledTupleEntry.unmarshalEntry(tupleInput);
            return (E)marshalledTupleEntry;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw RuntimeExceptionWrapper.wrapIfNeeded(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw RuntimeExceptionWrapper.wrapIfNeeded(instantiationException);
        }
    }

    @Override
    public void objectToEntry(E e, TupleOutput tupleOutput) {
        e.marshalEntry(tupleOutput);
    }
}

