/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.serial;

import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.db.Cursor;
import com.sleepycat.db.CursorConfig;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.EnvironmentConfig;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.Transaction;
import com.sleepycat.util.FastInputStream;
import com.sleepycat.util.FastOutputStream;
import com.sleepycat.util.RuntimeExceptionWrapper;
import com.sleepycat.util.UtfOps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;

public class StoredClassCatalog
implements ClassCatalog {
    private static final byte REC_LAST_CLASS_ID = 0;
    private static final byte REC_CLASS_FORMAT = 1;
    private static final byte REC_CLASS_INFO = 2;
    private static final byte[] LAST_CLASS_ID_KEY = new byte[]{0};
    private Database db;
    private HashMap<String, ClassInfo> classMap;
    private HashMap<BigInteger, ObjectStreamClass> formatMap;
    private LockMode writeLockMode;
    private boolean cdbMode;
    private boolean txnMode;
    private static byte[] ZERO_LENGTH_BYTE_ARRAY = new byte[0];

    public StoredClassCatalog(Database database) throws DatabaseException, IllegalArgumentException {
        this.db = database;
        DatabaseConfig databaseConfig = this.db.getConfig();
        EnvironmentConfig environmentConfig = this.db.getEnvironment().getConfig();
        this.writeLockMode = DbCompat.getInitializeLocking(environmentConfig) || environmentConfig.getTransactional() ? LockMode.RMW : LockMode.DEFAULT;
        this.cdbMode = DbCompat.getInitializeCDB(environmentConfig);
        this.txnMode = databaseConfig.getTransactional();
        if (!DbCompat.isTypeBtree(databaseConfig)) {
            throw new IllegalArgumentException("The class catalog must be a BTREE database.");
        }
        if (DbCompat.getSortedDuplicates(databaseConfig) || DbCompat.getUnsortedDuplicates(databaseConfig)) {
            throw new IllegalArgumentException("The class catalog database must not allow duplicates.");
        }
        this.classMap = new HashMap();
        this.formatMap = new HashMap();
        DatabaseEntry databaseEntry = new DatabaseEntry(LAST_CLASS_ID_KEY);
        DatabaseEntry databaseEntry2 = new DatabaseEntry();
        if (databaseConfig.getReadOnly()) {
            OperationStatus operationStatus = this.db.get(null, databaseEntry, databaseEntry2, null);
            if (operationStatus != OperationStatus.SUCCESS) {
                throw DbCompat.unexpectedState("A read-only catalog database may not be empty");
            }
        } else {
            databaseEntry2.setData(new byte[1]);
            OperationStatus operationStatus = this.db.get(null, databaseEntry, databaseEntry2, null);
            if (operationStatus == OperationStatus.NOTFOUND) {
                this.db.putNoOverwrite(null, databaseEntry, databaseEntry2);
            }
        }
    }

    @Override
    public synchronized void close() throws DatabaseException {
        if (this.db != null) {
            this.db.close();
        }
        this.db = null;
        this.formatMap = null;
        this.classMap = null;
    }

    @Override
    public synchronized byte[] getClassID(ObjectStreamClass objectStreamClass) throws DatabaseException, ClassNotFoundException {
        ClassInfo classInfo = this.getClassInfo(objectStreamClass);
        return classInfo.getClassID();
    }

    @Override
    public synchronized ObjectStreamClass getClassFormat(byte[] byArray) throws DatabaseException, ClassNotFoundException {
        return this.getClassFormat(byArray, new DatabaseEntry());
    }

    private ObjectStreamClass getClassFormat(byte[] byArray, DatabaseEntry databaseEntry) throws DatabaseException, ClassNotFoundException {
        BigInteger bigInteger = new BigInteger(byArray);
        ObjectStreamClass objectStreamClass = this.formatMap.get(bigInteger);
        if (objectStreamClass == null) {
            byte[] byArray2 = new byte[byArray.length + 1];
            byArray2[0] = 1;
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
            DatabaseEntry databaseEntry2 = new DatabaseEntry(byArray2);
            OperationStatus operationStatus = this.db.get(null, databaseEntry2, databaseEntry, LockMode.DEFAULT);
            if (operationStatus != OperationStatus.SUCCESS) {
                throw new ClassNotFoundException("Catalog class ID not found");
            }
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(databaseEntry.getData(), databaseEntry.getOffset(), databaseEntry.getSize()));
                objectStreamClass = (ObjectStreamClass)objectInputStream.readObject();
            }
            catch (IOException iOException) {
                throw RuntimeExceptionWrapper.wrapIfNeeded(iOException);
            }
            this.formatMap.put(bigInteger, objectStreamClass);
        }
        return objectStreamClass;
    }

    private ClassInfo getClassInfo(ObjectStreamClass objectStreamClass) throws DatabaseException, ClassNotFoundException {
        String string = objectStreamClass.getName();
        ClassInfo classInfo = this.classMap.get(string);
        if (classInfo != null) {
            return classInfo;
        }
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[1 + UtfOps.getByteLength(cArray)];
        byArray[0] = 2;
        UtfOps.charsToBytes(cArray, 0, byArray, 1, cArray.length);
        DatabaseEntry databaseEntry = new DatabaseEntry(byArray);
        DatabaseEntry databaseEntry2 = new DatabaseEntry();
        OperationStatus operationStatus = this.db.get(null, databaseEntry, databaseEntry2, LockMode.DEFAULT);
        if (operationStatus != OperationStatus.SUCCESS) {
            if (DbCompat.isDalvik()) {
                try {
                    FastOutputStream fastOutputStream = new FastOutputStream();
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(fastOutputStream);
                    objectOutputStream.writeObject(objectStreamClass);
                    byte[] byArray2 = fastOutputStream.toByteArray();
                    FastInputStream fastInputStream = new FastInputStream(byArray2);
                    ObjectInputStream objectInputStream = new ObjectInputStream(fastInputStream);
                    objectStreamClass = (ObjectStreamClass)objectInputStream.readObject();
                }
                catch (Exception exception) {
                    throw RuntimeExceptionWrapper.wrapIfNeeded(exception);
                }
            }
            classInfo = this.putClassInfo(new ClassInfo(), string, databaseEntry, objectStreamClass);
        } else {
            classInfo = new ClassInfo(databaseEntry2);
            DatabaseEntry databaseEntry3 = new DatabaseEntry();
            ObjectStreamClass objectStreamClass2 = this.getClassFormat(classInfo.getClassID(), databaseEntry3);
            if (!StoredClassCatalog.areClassFormatsEqual(objectStreamClass2, StoredClassCatalog.getBytes(databaseEntry3), objectStreamClass)) {
                classInfo = this.putClassInfo(classInfo, string, databaseEntry, objectStreamClass);
            }
            classInfo.setClassFormat(objectStreamClass);
            this.classMap.put(string, classInfo);
        }
        return classInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassInfo putClassInfo(ClassInfo classInfo, String string, DatabaseEntry databaseEntry, ObjectStreamClass objectStreamClass) throws DatabaseException {
        CursorConfig cursorConfig = null;
        if (this.cdbMode) {
            cursorConfig = new CursorConfig();
            DbCompat.setWriteCursor(cursorConfig, true);
        }
        Cursor cursor = null;
        Transaction transaction = null;
        try {
            DatabaseEntry databaseEntry2;
            DatabaseEntry databaseEntry3;
            OperationStatus operationStatus;
            if (this.txnMode) {
                transaction = this.db.getEnvironment().beginTransaction(null, null);
            }
            if ((operationStatus = (cursor = this.db.openCursor(transaction, cursorConfig)).getSearchKey(databaseEntry3 = new DatabaseEntry(LAST_CLASS_ID_KEY), databaseEntry2 = new DatabaseEntry(), this.writeLockMode)) != OperationStatus.SUCCESS) {
                throw DbCompat.unexpectedState("Class ID not initialized");
            }
            byte[] byArray = StoredClassCatalog.getBytes(databaseEntry2);
            byArray = StoredClassCatalog.incrementID(byArray);
            databaseEntry2.setData(byArray);
            cursor.put(databaseEntry3, databaseEntry2);
            byte[] byArray2 = new byte[1 + byArray.length];
            byArray2[0] = 1;
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
            databaseEntry3.setData(byArray2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(objectStreamClass);
            }
            catch (IOException iOException) {
                throw RuntimeExceptionWrapper.wrapIfNeeded(iOException);
            }
            databaseEntry2.setData(byteArrayOutputStream.toByteArray());
            cursor.put(databaseEntry3, databaseEntry2);
            classInfo.setClassID(byArray);
            classInfo.toDbt(databaseEntry2);
            cursor.put(databaseEntry, databaseEntry2);
            classInfo.setClassFormat(objectStreamClass);
            this.classMap.put(string, classInfo);
            this.formatMap.put(new BigInteger(byArray), objectStreamClass);
            ClassInfo classInfo2 = classInfo;
            return classInfo2;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (transaction != null) {
                transaction.commit();
            }
        }
    }

    private static byte[] incrementID(byte[] byArray) {
        BigInteger bigInteger = new BigInteger(byArray);
        bigInteger = bigInteger.add(BigInteger.valueOf(1L));
        return bigInteger.toByteArray();
    }

    private static boolean areClassFormatsEqual(ObjectStreamClass objectStreamClass, byte[] byArray, ObjectStreamClass objectStreamClass2) {
        try {
            if (byArray == null) {
                byArray = StoredClassCatalog.getObjectBytes(objectStreamClass);
            }
            byte[] byArray2 = StoredClassCatalog.getObjectBytes(objectStreamClass2);
            return Arrays.equals(byArray2, byArray);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static byte[] getBytes(DatabaseEntry databaseEntry) {
        byte[] byArray = databaseEntry.getData();
        if (byArray == null) {
            return null;
        }
        if (databaseEntry.getOffset() == 0 && byArray.length == databaseEntry.getSize()) {
            return byArray;
        }
        int n = databaseEntry.getSize();
        if (n == 0) {
            return ZERO_LENGTH_BYTE_ARRAY;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, databaseEntry.getOffset(), byArray2, 0, byArray2.length);
        return byArray2;
    }

    private static byte[] getObjectBytes(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public ClassLoader getClassLoader() {
        try {
            return DbCompat.getClassLoader(this.db.getEnvironment());
        }
        catch (DatabaseException databaseException) {
            throw new RuntimeException(databaseException);
        }
    }

    private static class ClassInfo
    implements Serializable {
        static final long serialVersionUID = 3845446969989650562L;
        private byte[] classID;
        private transient ObjectStreamClass classFormat;

        ClassInfo() {
        }

        ClassInfo(DatabaseEntry databaseEntry) {
            byte[] byArray = databaseEntry.getData();
            byte by = byArray[0];
            this.classID = new byte[by];
            System.arraycopy(byArray, 1, this.classID, 0, by);
        }

        void toDbt(DatabaseEntry databaseEntry) {
            byte[] byArray = new byte[1 + this.classID.length];
            byArray[0] = (byte)this.classID.length;
            System.arraycopy(this.classID, 0, byArray, 1, this.classID.length);
            databaseEntry.setData(byArray);
        }

        void setClassID(byte[] byArray) {
            this.classID = byArray;
        }

        byte[] getClassID() {
            return this.classID;
        }

        ObjectStreamClass getClassFormat() {
            return this.classFormat;
        }

        void setClassFormat(ObjectStreamClass objectStreamClass) {
            this.classFormat = objectStreamClass;
        }
    }
}

