/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class FastOutputStream
extends OutputStream {
    public static final int DEFAULT_INIT_SIZE = 100;
    public static final int DEFAULT_BUMP_SIZE = 0;
    private int len;
    private int bumpLen;
    private byte[] buf;
    private static byte[] ZERO_LENGTH_BYTE_ARRAY = new byte[0];

    public FastOutputStream() {
        this.initBuffer(100, 0);
    }

    public FastOutputStream(int n) {
        this.initBuffer(n, 0);
    }

    public FastOutputStream(int n, int n2) {
        this.initBuffer(n, n2);
    }

    public FastOutputStream(byte[] byArray) {
        this.buf = byArray;
        this.bumpLen = 0;
    }

    public FastOutputStream(byte[] byArray, int n) {
        this.buf = byArray;
        this.bumpLen = n;
    }

    private void initBuffer(int n, int n2) {
        this.buf = new byte[n];
        this.bumpLen = n2;
    }

    public int size() {
        return this.len;
    }

    public void reset() {
        this.len = 0;
    }

    public void write(int n) {
        this.writeFast(n);
    }

    public void write(byte[] byArray) {
        this.writeFast(byArray);
    }

    public void write(byte[] byArray, int n, int n2) {
        this.writeFast(byArray, n, n2);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.len);
    }

    public String toString() {
        return new String(this.buf, 0, this.len);
    }

    public String toString(String string) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.len, string);
    }

    public byte[] toByteArray() {
        if (this.len == 0) {
            return ZERO_LENGTH_BYTE_ARRAY;
        }
        byte[] byArray = new byte[this.len];
        System.arraycopy(this.buf, 0, byArray, 0, this.len);
        return byArray;
    }

    public final void writeFast(int n) {
        if (this.len + 1 > this.buf.length) {
            this.bump(1);
        }
        this.buf[this.len++] = (byte)n;
    }

    public final void writeFast(byte[] byArray) {
        int n = this.len + byArray.length - this.buf.length;
        if (n > 0) {
            this.bump(n);
        }
        System.arraycopy(byArray, 0, this.buf, this.len, byArray.length);
        this.len += byArray.length;
    }

    public final void writeFast(byte[] byArray, int n, int n2) {
        int n3 = this.len + n2 - this.buf.length;
        if (n3 > 0) {
            this.bump(n3);
        }
        System.arraycopy(byArray, n, this.buf, this.len, n2);
        this.len += n2;
    }

    public byte[] getBufferBytes() {
        return this.buf;
    }

    public int getBufferOffset() {
        return 0;
    }

    public int getBufferLength() {
        return this.len;
    }

    public void makeSpace(int n) {
        int n2 = this.len + n - this.buf.length;
        if (n2 > 0) {
            this.bump(n2);
        }
    }

    public void addSize(int n) {
        this.len += n;
    }

    private void bump(int n) {
        int n2 = this.bumpLen > 0 ? this.bumpLen : this.buf.length;
        byte[] byArray = new byte[this.buf.length + n + n2];
        System.arraycopy(this.buf, 0, byArray, 0, this.len);
        this.buf = byArray;
    }
}

