/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.model;

import com.sleepycat.asm.AnnotationVisitor;
import com.sleepycat.asm.Attribute;
import com.sleepycat.asm.ClassAdapter;
import com.sleepycat.asm.ClassVisitor;
import com.sleepycat.asm.FieldVisitor;
import com.sleepycat.asm.Label;
import com.sleepycat.asm.MethodVisitor;
import com.sleepycat.asm.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BytecodeEnhancer
extends ClassAdapter {
    private static final NotPersistentException NOT_PERSISTENT = new NotPersistentException();
    private static final Map<String, Integer> PRIMITIVE_WRAPPERS = new HashMap<String, Integer>();
    private String className;
    private String superclassName;
    private boolean isPersistent;
    private boolean isAbstract;
    private boolean hasDefaultConstructor;
    private boolean hasPersistentSuperclass;
    private boolean isCompositeKey;
    private FieldInfo priKeyField;
    private List<FieldInfo> secKeyFields = new ArrayList<FieldInfo>();
    private List<FieldInfo> nonKeyFields = new ArrayList<FieldInfo>();
    private String staticBlockMethod;

    BytecodeEnhancer(ClassVisitor classVisitor) {
        super(classVisitor);
    }

    @Override
    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        this.className = string;
        this.superclassName = string3;
        if (BytecodeEnhancer.containsString(stringArray, "com/sleepycat/persist/impl/Enhanced")) {
            throw this.abort();
        }
        stringArray = BytecodeEnhancer.appendString(stringArray, "com/sleepycat/persist/impl/Enhanced");
        this.isAbstract = (n2 & 0x400) != 0;
        this.hasPersistentSuperclass = string3 != null && !string3.equals("java/lang/Object");
        super.visit(n, n2, string, string2, string3, stringArray);
    }

    @Override
    public void visitSource(String string, String string2) {
        super.visitSource(string, string2);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        if (string.equals("Lcom/sleepycat/persist/model/Entity;") || string.equals("Lcom/sleepycat/persist/model/Persistent;")) {
            this.isPersistent = true;
        }
        return super.visitAnnotation(string, bl);
    }

    @Override
    public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
        if (!this.isPersistent) {
            throw this.abort();
        }
        FieldVisitor fieldVisitor = super.visitField(n, string, string2, string3, object);
        if ((n & 8) == 0) {
            FieldInfo fieldInfo = new FieldInfo(fieldVisitor, string, string2, (n & 0x80) != 0);
            this.nonKeyFields.add(fieldInfo);
            fieldVisitor = fieldInfo;
        }
        return fieldVisitor;
    }

    @Override
    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        if (!this.isPersistent) {
            throw this.abort();
        }
        if ("<init>".equals(string) && "()V".equals(string2)) {
            this.hasDefaultConstructor = true;
        }
        if ("<clinit>".equals(string)) {
            if (this.staticBlockMethod != null) {
                throw new IllegalStateException();
            }
            this.staticBlockMethod = "bdbExistingStaticBlock";
            return this.cv.visitMethod(10, this.staticBlockMethod, "()V", null, null);
        }
        return super.visitMethod(n, string, string2, string3, stringArray);
    }

    @Override
    public void visitEnd() {
        if (!this.isPersistent || !this.hasDefaultConstructor) {
            throw this.abort();
        }
        this.sortFields();
        this.genBdbNewInstance();
        this.genBdbNewArray();
        this.genBdbIsPriKeyFieldNullOrZero();
        this.genBdbWritePriKeyField();
        this.genBdbReadPriKeyField();
        this.genBdbWriteSecKeyFields();
        this.genBdbReadSecKeyFields();
        this.genBdbWriteNonKeyFields();
        this.genBdbReadNonKeyFields();
        this.genBdbWriteCompositeKeyFields();
        this.genBdbReadCompositeKeyFields();
        this.genBdbGetField();
        this.genBdbSetField();
        this.genStaticBlock();
        super.visitEnd();
    }

    private void sortFields() {
        if (this.nonKeyFields.size() == 0) {
            return;
        }
        this.isCompositeKey = true;
        for (FieldInfo fieldInfo : this.nonKeyFields) {
            if (fieldInfo.order != null) continue;
            this.isCompositeKey = false;
        }
        if (this.isCompositeKey) {
            Collections.sort(this.nonKeyFields, new Comparator<FieldInfo>(){

                @Override
                public int compare(FieldInfo fieldInfo, FieldInfo fieldInfo2) {
                    return fieldInfo.order.value - fieldInfo2.order.value;
                }
            });
        } else {
            int n = 0;
            while (n < this.nonKeyFields.size()) {
                FieldInfo fieldInfo;
                fieldInfo = this.nonKeyFields.get(n);
                if (fieldInfo.isTransient) {
                    this.nonKeyFields.remove(n);
                    continue;
                }
                if (fieldInfo.isPriKey) {
                    if (this.priKeyField != null) continue;
                    this.priKeyField = fieldInfo;
                    this.nonKeyFields.remove(n);
                    continue;
                }
                if (fieldInfo.isSecKey) {
                    this.secKeyFields.add(fieldInfo);
                    this.nonKeyFields.remove(n);
                    continue;
                }
                ++n;
            }
            Comparator<FieldInfo> comparator = new Comparator<FieldInfo>(){

                @Override
                public int compare(FieldInfo fieldInfo, FieldInfo fieldInfo2) {
                    return fieldInfo.name.compareTo(fieldInfo2.name);
                }
            };
            Collections.sort(this.secKeyFields, comparator);
            Collections.sort(this.nonKeyFields, comparator);
        }
    }

    private void genStaticBlock() {
        MethodVisitor methodVisitor = this.cv.visitMethod(8, "<clinit>", "()V", null, null);
        methodVisitor.visitCode();
        if (this.staticBlockMethod != null) {
            methodVisitor.visitMethodInsn(184, this.className, this.staticBlockMethod, "()V");
        }
        methodVisitor.visitLdcInsn(this.className.replace('/', '.'));
        if (this.isAbstract) {
            methodVisitor.visitInsn(1);
        } else {
            methodVisitor.visitTypeInsn(187, this.className);
            methodVisitor.visitInsn(89);
            methodVisitor.visitMethodInsn(183, this.className, "<init>", "()V");
        }
        methodVisitor.visitMethodInsn(184, "com/sleepycat/persist/impl/EnhancedAccessor", "registerClass", "(Ljava/lang/String;Lcom/sleepycat/persist/impl/Enhanced;)V");
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(3, 0);
        methodVisitor.visitEnd();
    }

    private void genBdbNewInstance() {
        MethodVisitor methodVisitor = this.cv.visitMethod(1, "bdbNewInstance", "()Ljava/lang/Object;", null, null);
        methodVisitor.visitCode();
        if (this.isAbstract) {
            methodVisitor.visitInsn(1);
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(1, 1);
        } else {
            methodVisitor.visitTypeInsn(187, this.className);
            methodVisitor.visitInsn(89);
            methodVisitor.visitMethodInsn(183, this.className, "<init>", "()V");
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(2, 1);
        }
        methodVisitor.visitEnd();
    }

    private void genBdbNewArray() {
        MethodVisitor methodVisitor = this.cv.visitMethod(1, "bdbNewArray", "(I)Ljava/lang/Object;", null, null);
        methodVisitor.visitCode();
        if (this.isAbstract) {
            methodVisitor.visitInsn(1);
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(1, 2);
        } else {
            methodVisitor.visitVarInsn(21, 1);
            methodVisitor.visitTypeInsn(189, this.className);
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(1, 2);
            methodVisitor.visitEnd();
        }
    }

    private void genBdbIsPriKeyFieldNullOrZero() {
        MethodVisitor methodVisitor = this.cv.visitMethod(1, "bdbIsPriKeyFieldNullOrZero", "()Z", null, null);
        methodVisitor.visitCode();
        if (this.priKeyField != null) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.className, this.priKeyField.name, this.priKeyField.type.getDescriptor());
            Label label = new Label();
            if (BytecodeEnhancer.isRefType(this.priKeyField.type)) {
                methodVisitor.visitJumpInsn(199, label);
            } else {
                BytecodeEnhancer.genBeforeCompareToZero(methodVisitor, this.priKeyField.type);
                methodVisitor.visitJumpInsn(154, label);
            }
            methodVisitor.visitInsn(4);
            Label label2 = new Label();
            methodVisitor.visitJumpInsn(167, label2);
            methodVisitor.visitLabel(label);
            methodVisitor.visitInsn(3);
            methodVisitor.visitLabel(label2);
        } else if (this.hasPersistentSuperclass) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(183, this.superclassName, "bdbIsPriKeyFieldNullOrZero", "()Z");
        } else {
            methodVisitor.visitInsn(3);
        }
        methodVisitor.visitInsn(172);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
    }

    private void genBdbWritePriKeyField() {
        MethodVisitor methodVisitor = this.cv.visitMethod(1, "bdbWritePriKeyField", "(Lcom/sleepycat/persist/impl/EntityOutput;Lcom/sleepycat/persist/impl/Format;)V", null, null);
        methodVisitor.visitCode();
        if (this.priKeyField != null) {
            if (!this.genWriteSimpleKeyField(methodVisitor, this.priKeyField)) {
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, this.className, this.priKeyField.name, this.priKeyField.type.getDescriptor());
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityOutput", "writeKeyObject", "(Ljava/lang/Object;Lcom/sleepycat/persist/impl/Format;)V");
            }
        } else if (this.hasPersistentSuperclass) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitMethodInsn(183, this.superclassName, "bdbWritePriKeyField", "(Lcom/sleepycat/persist/impl/EntityOutput;Lcom/sleepycat/persist/impl/Format;)V");
        }
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(3, 3);
        methodVisitor.visitEnd();
    }

    private void genBdbReadPriKeyField() {
        MethodVisitor methodVisitor = this.cv.visitMethod(1, "bdbReadPriKeyField", "(Lcom/sleepycat/persist/impl/EntityInput;Lcom/sleepycat/persist/impl/Format;)V", null, null);
        methodVisitor.visitCode();
        if (this.priKeyField != null) {
            if (!this.genReadSimpleKeyField(methodVisitor, this.priKeyField)) {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityInput", "readKeyObject", "(Lcom/sleepycat/persist/impl/Format;)Ljava/lang/Object;");
                methodVisitor.visitTypeInsn(192, BytecodeEnhancer.getTypeInstName(this.priKeyField.type));
                methodVisitor.visitFieldInsn(181, this.className, this.priKeyField.name, this.priKeyField.type.getDescriptor());
            }
        } else if (this.hasPersistentSuperclass) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitMethodInsn(183, this.superclassName, "bdbReadPriKeyField", "(Lcom/sleepycat/persist/impl/EntityInput;Lcom/sleepycat/persist/impl/Format;)V");
        }
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(3, 3);
        methodVisitor.visitEnd();
    }

    private void genBdbWriteSecKeyFields() {
        MethodVisitor methodVisitor = this.cv.visitMethod(1, "bdbWriteSecKeyFields", "(Lcom/sleepycat/persist/impl/EntityOutput;)V", null, null);
        methodVisitor.visitCode();
        if (this.priKeyField != null && BytecodeEnhancer.isRefType(this.priKeyField.type)) {
            this.genRegisterPrimaryKey(methodVisitor, false);
        }
        if (this.hasPersistentSuperclass) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitMethodInsn(183, this.superclassName, "bdbWriteSecKeyFields", "(Lcom/sleepycat/persist/impl/EntityOutput;)V");
        }
        for (FieldInfo fieldInfo : this.secKeyFields) {
            this.genWriteField(methodVisitor, fieldInfo);
        }
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(2, 2);
        methodVisitor.visitEnd();
    }

    private void genBdbReadSecKeyFields() {
        MethodVisitor methodVisitor = this.cv.visitMethod(1, "bdbReadSecKeyFields", "(Lcom/sleepycat/persist/impl/EntityInput;III)V", null, null);
        methodVisitor.visitCode();
        if (this.priKeyField != null && BytecodeEnhancer.isRefType(this.priKeyField.type)) {
            this.genRegisterPrimaryKey(methodVisitor, true);
        }
        this.genReadSuperKeyFields(methodVisitor, true);
        this.genReadFieldSwitch(methodVisitor, this.secKeyFields);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(5, 5);
        methodVisitor.visitEnd();
    }

    private void genRegisterPrimaryKey(MethodVisitor methodVisitor, boolean bl) {
        String string = bl ? "com/sleepycat/persist/impl/EntityInput" : "com/sleepycat/persist/impl/EntityOutput";
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, this.className, this.priKeyField.name, this.priKeyField.type.getDescriptor());
        methodVisitor.visitMethodInsn(185, string, "registerPriKeyObject", "(Ljava/lang/Object;)V");
    }

    private void genBdbWriteNonKeyFields() {
        MethodVisitor methodVisitor = this.cv.visitMethod(1, "bdbWriteNonKeyFields", "(Lcom/sleepycat/persist/impl/EntityOutput;)V", null, null);
        methodVisitor.visitCode();
        if (!this.isCompositeKey) {
            if (this.hasPersistentSuperclass) {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitMethodInsn(183, this.superclassName, "bdbWriteNonKeyFields", "(Lcom/sleepycat/persist/impl/EntityOutput;)V");
            }
            for (FieldInfo fieldInfo : this.nonKeyFields) {
                this.genWriteField(methodVisitor, fieldInfo);
            }
        }
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(2, 2);
        methodVisitor.visitEnd();
    }

    private void genBdbReadNonKeyFields() {
        MethodVisitor methodVisitor = this.cv.visitMethod(1, "bdbReadNonKeyFields", "(Lcom/sleepycat/persist/impl/EntityInput;III)V", null, null);
        methodVisitor.visitCode();
        if (!this.isCompositeKey) {
            this.genReadSuperKeyFields(methodVisitor, false);
            this.genReadFieldSwitch(methodVisitor, this.nonKeyFields);
        }
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(5, 5);
        methodVisitor.visitEnd();
    }

    private void genBdbWriteCompositeKeyFields() {
        MethodVisitor methodVisitor = this.cv.visitMethod(1, "bdbWriteCompositeKeyFields", "(Lcom/sleepycat/persist/impl/EntityOutput;[Lcom/sleepycat/persist/impl/Format;)V", null, null);
        methodVisitor.visitCode();
        if (this.isCompositeKey) {
            for (int i = 0; i < this.nonKeyFields.size(); ++i) {
                FieldInfo fieldInfo = this.nonKeyFields.get(i);
                if (this.genWriteSimpleKeyField(methodVisitor, fieldInfo)) continue;
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, this.className, fieldInfo.name, fieldInfo.type.getDescriptor());
                methodVisitor.visitVarInsn(25, 2);
                if (i <= 127) {
                    methodVisitor.visitIntInsn(16, i);
                } else {
                    methodVisitor.visitLdcInsn(new Integer(i));
                }
                methodVisitor.visitInsn(50);
                methodVisitor.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityOutput", "writeKeyObject", "(Ljava/lang/Object;Lcom/sleepycat/persist/impl/Format;)V");
            }
        }
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(3, 3);
        methodVisitor.visitEnd();
    }

    private void genBdbReadCompositeKeyFields() {
        MethodVisitor methodVisitor = this.cv.visitMethod(1, "bdbReadCompositeKeyFields", "(Lcom/sleepycat/persist/impl/EntityInput;[Lcom/sleepycat/persist/impl/Format;)V", null, null);
        methodVisitor.visitCode();
        if (this.isCompositeKey) {
            for (int i = 0; i < this.nonKeyFields.size(); ++i) {
                FieldInfo fieldInfo = this.nonKeyFields.get(i);
                if (this.genReadSimpleKeyField(methodVisitor, fieldInfo)) continue;
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitVarInsn(25, 2);
                if (i <= 127) {
                    methodVisitor.visitIntInsn(16, i);
                } else {
                    methodVisitor.visitLdcInsn(new Integer(i));
                }
                methodVisitor.visitInsn(50);
                methodVisitor.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityInput", "readKeyObject", "(Lcom/sleepycat/persist/impl/Format;)Ljava/lang/Object;");
                methodVisitor.visitTypeInsn(192, BytecodeEnhancer.getTypeInstName(fieldInfo.type));
                methodVisitor.visitFieldInsn(181, this.className, fieldInfo.name, fieldInfo.type.getDescriptor());
            }
        }
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(5, 5);
        methodVisitor.visitEnd();
    }

    private void genWriteField(MethodVisitor methodVisitor, FieldInfo fieldInfo) {
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, this.className, fieldInfo.name, fieldInfo.type.getDescriptor());
        int n = fieldInfo.type.getSort();
        if (n == 10 || n == 9) {
            methodVisitor.visitInsn(1);
            methodVisitor.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityOutput", "writeObject", "(Ljava/lang/Object;Lcom/sleepycat/persist/impl/Format;)V");
        } else {
            this.genWritePrimitive(methodVisitor, n);
        }
    }

    private boolean genWriteSimpleKeyField(MethodVisitor methodVisitor, FieldInfo fieldInfo) {
        if (this.genWritePrimitiveField(methodVisitor, fieldInfo)) {
            return true;
        }
        String string = fieldInfo.type.getClassName();
        if (!BytecodeEnhancer.isSimpleRefType(string)) {
            return false;
        }
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, this.className, fieldInfo.name, fieldInfo.type.getDescriptor());
        Integer n = PRIMITIVE_WRAPPERS.get(string);
        if (n != null) {
            this.genUnwrapPrimitive(methodVisitor, n);
            this.genWritePrimitive(methodVisitor, n);
        } else if (string.equals(Date.class.getName())) {
            methodVisitor.visitMethodInsn(182, "java/util/Date", "getTime", "()J");
            this.genWritePrimitive(methodVisitor, 7);
        } else if (string.equals(String.class.getName())) {
            methodVisitor.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityOutput", "writeString", "(Ljava/lang/String;)Lcom/sleepycat/bind/tuple/TupleOutput;");
            methodVisitor.visitInsn(87);
        } else if (string.equals(BigInteger.class.getName())) {
            methodVisitor.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityOutput", "writeBigInteger", "(Ljava/math/BigInteger;)Lcom/sleepycat/bind/tuple/TupleOutput;");
            methodVisitor.visitInsn(87);
        } else {
            throw new IllegalStateException(string);
        }
        return true;
    }

    private boolean genWritePrimitiveField(MethodVisitor methodVisitor, FieldInfo fieldInfo) {
        int n = fieldInfo.type.getSort();
        if (n == 10 || n == 9) {
            return false;
        }
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, this.className, fieldInfo.name, fieldInfo.type.getDescriptor());
        this.genWritePrimitive(methodVisitor, n);
        return true;
    }

    private void genReadSuperKeyFields(MethodVisitor methodVisitor, boolean bl) {
        if (this.hasPersistentSuperclass) {
            Label label = new Label();
            methodVisitor.visitVarInsn(21, 4);
            methodVisitor.visitJumpInsn(153, label);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(21, 2);
            methodVisitor.visitVarInsn(21, 3);
            methodVisitor.visitVarInsn(21, 4);
            methodVisitor.visitInsn(4);
            methodVisitor.visitInsn(100);
            String string = bl ? "bdbReadSecKeyFields" : "bdbReadNonKeyFields";
            methodVisitor.visitMethodInsn(183, this.superclassName, string, "(Lcom/sleepycat/persist/impl/EntityInput;III)V");
            methodVisitor.visitLabel(label);
        }
    }

    private void genReadFieldSwitch(MethodVisitor methodVisitor, List<FieldInfo> list) {
        int n = list.size();
        if (n > 0) {
            int n2;
            methodVisitor.visitVarInsn(21, 4);
            Label label = new Label();
            methodVisitor.visitJumpInsn(157, label);
            Label[] labelArray = new Label[n];
            for (n2 = 0; n2 < n; ++n2) {
                labelArray[n2] = new Label();
            }
            methodVisitor.visitVarInsn(21, 2);
            methodVisitor.visitTableSwitchInsn(0, n - 1, label, labelArray);
            for (n2 = 0; n2 < n; ++n2) {
                FieldInfo fieldInfo = list.get(n2);
                methodVisitor.visitLabel(labelArray[n2]);
                this.genReadField(methodVisitor, fieldInfo);
                if (n2 >= n - 1) continue;
                Label label2 = labelArray[n2 + 1];
                methodVisitor.visitVarInsn(21, 3);
                if (n2 == 0) {
                    methodVisitor.visitJumpInsn(154, label2);
                } else {
                    switch (n2) {
                        case 1: {
                            methodVisitor.visitInsn(4);
                            break;
                        }
                        case 2: {
                            methodVisitor.visitInsn(5);
                            break;
                        }
                        case 3: {
                            methodVisitor.visitInsn(6);
                            break;
                        }
                        case 4: {
                            methodVisitor.visitInsn(7);
                            break;
                        }
                        case 5: {
                            methodVisitor.visitInsn(8);
                            break;
                        }
                        default: {
                            methodVisitor.visitIntInsn(16, n2);
                        }
                    }
                    methodVisitor.visitJumpInsn(160, label2);
                }
                methodVisitor.visitJumpInsn(167, label);
            }
            methodVisitor.visitLabel(label);
        }
    }

    private void genReadField(MethodVisitor methodVisitor, FieldInfo fieldInfo) {
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        if (BytecodeEnhancer.isRefType(fieldInfo.type)) {
            methodVisitor.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityInput", "readObject", "()Ljava/lang/Object;");
            methodVisitor.visitTypeInsn(192, BytecodeEnhancer.getTypeInstName(fieldInfo.type));
        } else {
            this.genReadPrimitive(methodVisitor, fieldInfo.type.getSort());
        }
        methodVisitor.visitFieldInsn(181, this.className, fieldInfo.name, fieldInfo.type.getDescriptor());
    }

    private boolean genReadSimpleKeyField(MethodVisitor methodVisitor, FieldInfo fieldInfo) {
        if (this.genReadPrimitiveField(methodVisitor, fieldInfo)) {
            return true;
        }
        String string = fieldInfo.type.getClassName();
        if (!BytecodeEnhancer.isSimpleRefType(string)) {
            return false;
        }
        Integer n = PRIMITIVE_WRAPPERS.get(string);
        if (n != null) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            this.genReadPrimitive(methodVisitor, n);
            this.genWrapPrimitive(methodVisitor, n);
        } else if (string.equals(Date.class.getName())) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitTypeInsn(187, "java/util/Date");
            methodVisitor.visitInsn(89);
            methodVisitor.visitVarInsn(25, 1);
            this.genReadPrimitive(methodVisitor, 7);
            methodVisitor.visitMethodInsn(183, "java/util/Date", "<init>", "(J)V");
        } else if (string.equals(String.class.getName())) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityInput", "readString", "()Ljava/lang/String;");
        } else if (string.equals(BigInteger.class.getName())) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityInput", "readBigInteger", "()Ljava/math/BigInteger;");
        } else {
            throw new IllegalStateException(string);
        }
        methodVisitor.visitFieldInsn(181, this.className, fieldInfo.name, fieldInfo.type.getDescriptor());
        return true;
    }

    private boolean genReadPrimitiveField(MethodVisitor methodVisitor, FieldInfo fieldInfo) {
        int n = fieldInfo.type.getSort();
        if (n == 10 || n == 9) {
            return false;
        }
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        this.genReadPrimitive(methodVisitor, n);
        methodVisitor.visitFieldInsn(181, this.className, fieldInfo.name, fieldInfo.type.getDescriptor());
        return true;
    }

    private void genBdbGetField() {
        MethodVisitor methodVisitor = this.cv.visitMethod(1, "bdbGetField", "(Ljava/lang/Object;IIZ)Ljava/lang/Object;", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(21, 3);
        Label label = new Label();
        methodVisitor.visitJumpInsn(158, label);
        Label label2 = new Label();
        if (this.hasPersistentSuperclass) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(21, 2);
            methodVisitor.visitVarInsn(21, 3);
            methodVisitor.visitInsn(4);
            methodVisitor.visitInsn(100);
            methodVisitor.visitVarInsn(21, 4);
            methodVisitor.visitMethodInsn(183, this.className, "bdbGetField", "(Ljava/lang/Object;IIZ)Ljava/lang/Object;");
            methodVisitor.visitInsn(176);
        } else {
            methodVisitor.visitJumpInsn(167, label2);
        }
        methodVisitor.visitLabel(label);
        methodVisitor.visitVarInsn(21, 4);
        Label label3 = new Label();
        methodVisitor.visitJumpInsn(153, label3);
        this.genGetFieldSwitch(methodVisitor, this.secKeyFields, label2);
        methodVisitor.visitLabel(label3);
        this.genGetFieldSwitch(methodVisitor, this.nonKeyFields, label2);
        methodVisitor.visitLabel(label2);
        methodVisitor.visitInsn(1);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(1, 5);
        methodVisitor.visitEnd();
    }

    private void genGetFieldSwitch(MethodVisitor methodVisitor, List<FieldInfo> list, Label label) {
        int n;
        int n2 = list.size();
        if (n2 == 0) {
            methodVisitor.visitJumpInsn(167, label);
            return;
        }
        Label[] labelArray = new Label[n2];
        for (n = 0; n < n2; ++n) {
            labelArray[n] = new Label();
        }
        methodVisitor.visitVarInsn(21, 2);
        methodVisitor.visitTableSwitchInsn(0, n2 - 1, label, labelArray);
        for (n = 0; n < n2; ++n) {
            FieldInfo fieldInfo = list.get(n);
            methodVisitor.visitLabel(labelArray[n]);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.className, fieldInfo.name, fieldInfo.type.getDescriptor());
            if (!BytecodeEnhancer.isRefType(fieldInfo.type)) {
                this.genWrapPrimitive(methodVisitor, fieldInfo.type.getSort());
            }
            methodVisitor.visitInsn(176);
        }
    }

    private void genBdbSetField() {
        MethodVisitor methodVisitor = this.cv.visitMethod(1, "bdbSetField", "(Ljava/lang/Object;IIZLjava/lang/Object;)V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(21, 3);
        Label label = new Label();
        methodVisitor.visitJumpInsn(158, label);
        if (this.hasPersistentSuperclass) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(21, 2);
            methodVisitor.visitVarInsn(21, 3);
            methodVisitor.visitInsn(4);
            methodVisitor.visitInsn(100);
            methodVisitor.visitVarInsn(21, 4);
            methodVisitor.visitVarInsn(25, 5);
            methodVisitor.visitMethodInsn(183, this.className, "bdbSetField", "(Ljava/lang/Object;IIZLjava/lang/Object;)V");
        }
        methodVisitor.visitInsn(177);
        methodVisitor.visitLabel(label);
        methodVisitor.visitVarInsn(21, 4);
        Label label2 = new Label();
        methodVisitor.visitJumpInsn(153, label2);
        Label label3 = new Label();
        this.genSetFieldSwitch(methodVisitor, this.secKeyFields, label3);
        methodVisitor.visitLabel(label2);
        this.genSetFieldSwitch(methodVisitor, this.nonKeyFields, label3);
        methodVisitor.visitLabel(label3);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(2, 6);
        methodVisitor.visitEnd();
    }

    private void genSetFieldSwitch(MethodVisitor methodVisitor, List<FieldInfo> list, Label label) {
        int n;
        int n2 = list.size();
        if (n2 == 0) {
            methodVisitor.visitJumpInsn(167, label);
            return;
        }
        Label[] labelArray = new Label[n2];
        for (n = 0; n < n2; ++n) {
            labelArray[n] = new Label();
        }
        methodVisitor.visitVarInsn(21, 2);
        methodVisitor.visitTableSwitchInsn(0, n2 - 1, label, labelArray);
        for (n = 0; n < n2; ++n) {
            FieldInfo fieldInfo = list.get(n);
            methodVisitor.visitLabel(labelArray[n]);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 5);
            if (BytecodeEnhancer.isRefType(fieldInfo.type)) {
                methodVisitor.visitTypeInsn(192, BytecodeEnhancer.getTypeInstName(fieldInfo.type));
            } else {
                int n3 = fieldInfo.type.getSort();
                methodVisitor.visitTypeInsn(192, BytecodeEnhancer.getPrimitiveWrapperClass(n3).replace('.', '/'));
                this.genUnwrapPrimitive(methodVisitor, n3);
            }
            methodVisitor.visitFieldInsn(181, this.className, fieldInfo.name, fieldInfo.type.getDescriptor());
            methodVisitor.visitInsn(177);
        }
    }

    private void genWritePrimitive(MethodVisitor methodVisitor, int n) {
        switch (n) {
            case 1: {
                methodVisitor.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityOutput", "writeBoolean", "(Z)Lcom/sleepycat/bind/tuple/TupleOutput;");
                break;
            }
            case 2: {
                methodVisitor.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityOutput", "writeChar", "(I)Lcom/sleepycat/bind/tuple/TupleOutput;");
                break;
            }
            case 3: {
                methodVisitor.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityOutput", "writeByte", "(I)Lcom/sleepycat/bind/tuple/TupleOutput;");
                break;
            }
            case 4: {
                methodVisitor.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityOutput", "writeShort", "(I)Lcom/sleepycat/bind/tuple/TupleOutput;");
                break;
            }
            case 5: {
                methodVisitor.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityOutput", "writeInt", "(I)Lcom/sleepycat/bind/tuple/TupleOutput;");
                break;
            }
            case 7: {
                methodVisitor.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityOutput", "writeLong", "(J)Lcom/sleepycat/bind/tuple/TupleOutput;");
                break;
            }
            case 6: {
                methodVisitor.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityOutput", "writeSortedFloat", "(F)Lcom/sleepycat/bind/tuple/TupleOutput;");
                break;
            }
            case 8: {
                methodVisitor.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityOutput", "writeSortedDouble", "(D)Lcom/sleepycat/bind/tuple/TupleOutput;");
                break;
            }
            default: {
                throw new IllegalStateException(String.valueOf(n));
            }
        }
        methodVisitor.visitInsn(87);
    }

    private void genReadPrimitive(MethodVisitor methodVisitor, int n) {
        switch (n) {
            case 1: {
                methodVisitor.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityInput", "readBoolean", "()Z");
                break;
            }
            case 2: {
                methodVisitor.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityInput", "readChar", "()C");
                break;
            }
            case 3: {
                methodVisitor.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityInput", "readByte", "()B");
                break;
            }
            case 4: {
                methodVisitor.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityInput", "readShort", "()S");
                break;
            }
            case 5: {
                methodVisitor.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityInput", "readInt", "()I");
                break;
            }
            case 7: {
                methodVisitor.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityInput", "readLong", "()J");
                break;
            }
            case 6: {
                methodVisitor.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityInput", "readSortedFloat", "()F");
                break;
            }
            case 8: {
                methodVisitor.visitMethodInsn(185, "com/sleepycat/persist/impl/EntityInput", "readSortedDouble", "()D");
                break;
            }
            default: {
                throw new IllegalStateException(String.valueOf(n));
            }
        }
    }

    private void genWrapPrimitive(MethodVisitor methodVisitor, int n) {
        switch (n) {
            case 1: {
                methodVisitor.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                break;
            }
            case 2: {
                methodVisitor.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
                break;
            }
            case 3: {
                methodVisitor.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
                break;
            }
            case 4: {
                methodVisitor.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
                break;
            }
            case 5: {
                methodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                break;
            }
            case 7: {
                methodVisitor.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
                break;
            }
            case 6: {
                methodVisitor.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
                break;
            }
            case 8: {
                methodVisitor.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
                break;
            }
            default: {
                throw new IllegalStateException(String.valueOf(n));
            }
        }
    }

    private void genUnwrapPrimitive(MethodVisitor methodVisitor, int n) {
        switch (n) {
            case 1: {
                methodVisitor.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
                break;
            }
            case 2: {
                methodVisitor.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
                break;
            }
            case 3: {
                methodVisitor.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
                break;
            }
            case 4: {
                methodVisitor.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
                break;
            }
            case 5: {
                methodVisitor.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
                break;
            }
            case 7: {
                methodVisitor.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
                break;
            }
            case 6: {
                methodVisitor.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
                break;
            }
            case 8: {
                methodVisitor.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
                break;
            }
            default: {
                throw new IllegalStateException(String.valueOf(n));
            }
        }
    }

    private static String getTypeInstName(Type type) {
        if (type.getSort() == 10) {
            return type.getInternalName();
        }
        if (type.getSort() == 9) {
            return type.getDescriptor();
        }
        throw new IllegalStateException();
    }

    private static void genBeforeCompareToZero(MethodVisitor methodVisitor, Type type) {
        switch (type.getSort()) {
            case 7: {
                methodVisitor.visitInsn(9);
                methodVisitor.visitInsn(148);
                break;
            }
            case 6: {
                methodVisitor.visitInsn(11);
                methodVisitor.visitInsn(149);
                break;
            }
            case 8: {
                methodVisitor.visitInsn(14);
                methodVisitor.visitInsn(151);
            }
        }
    }

    static boolean isSimpleRefType(String string) {
        return PRIMITIVE_WRAPPERS.containsKey(string) || string.equals(BigInteger.class.getName()) || string.equals(Date.class.getName()) || string.equals(String.class.getName());
    }

    static String getPrimitiveWrapperClass(int n) {
        for (Map.Entry<String, Integer> entry : PRIMITIVE_WRAPPERS.entrySet()) {
            if (entry.getValue() != n) continue;
            return entry.getKey();
        }
        throw new IllegalStateException(String.valueOf(n));
    }

    private static boolean isRefType(Type type) {
        int n = type.getSort();
        return n == 10 || n == 9;
    }

    private static boolean containsString(String[] stringArray, String string) {
        if (stringArray != null) {
            for (String string2 : stringArray) {
                if (!string.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    private static String[] appendString(String[] stringArray, String string) {
        if (stringArray != null) {
            int n = stringArray.length;
            String[] stringArray2 = new String[n + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
            stringArray2[n] = string;
            return stringArray2;
        }
        return new String[]{string};
    }

    private NotPersistentException abort() {
        return NOT_PERSISTENT;
    }

    static {
        PRIMITIVE_WRAPPERS.put(Boolean.class.getName(), 1);
        PRIMITIVE_WRAPPERS.put(Character.class.getName(), 2);
        PRIMITIVE_WRAPPERS.put(Byte.class.getName(), 3);
        PRIMITIVE_WRAPPERS.put(Short.class.getName(), 4);
        PRIMITIVE_WRAPPERS.put(Integer.class.getName(), 5);
        PRIMITIVE_WRAPPERS.put(Long.class.getName(), 7);
        PRIMITIVE_WRAPPERS.put(Float.class.getName(), 6);
        PRIMITIVE_WRAPPERS.put(Double.class.getName(), 8);
    }

    private static abstract class AnnotationInfo
    implements AnnotationVisitor {
        AnnotationVisitor parent;

        AnnotationInfo(AnnotationVisitor annotationVisitor) {
            this.parent = annotationVisitor;
        }

        public void visit(String string, Object object) {
            this.parent.visit(string, object);
        }

        public AnnotationVisitor visitAnnotation(String string, String string2) {
            return this.parent.visitAnnotation(string, string2);
        }

        public AnnotationVisitor visitArray(String string) {
            return this.parent.visitArray(string);
        }

        public void visitEnum(String string, String string2, String string3) {
            this.parent.visitEnum(string, string2, string3);
        }

        public void visitEnd() {
            this.parent.visitEnd();
        }
    }

    private static class OrderInfo
    extends AnnotationInfo {
        int value;

        OrderInfo(AnnotationVisitor annotationVisitor) {
            super(annotationVisitor);
        }

        public void visit(String string, Object object) {
            if (string.equals("value")) {
                this.value = (Integer)object;
            }
            this.parent.visit(string, object);
        }
    }

    private static class FieldInfo
    implements FieldVisitor {
        FieldVisitor parent;
        String name;
        Type type;
        OrderInfo order;
        boolean isPriKey;
        boolean isSecKey;
        boolean isTransient;

        FieldInfo(FieldVisitor fieldVisitor, String string, String string2, boolean bl) {
            this.parent = fieldVisitor;
            this.name = string;
            this.isTransient = bl;
            this.type = Type.getType(string2);
        }

        public AnnotationVisitor visitAnnotation(String string, boolean bl) {
            AnnotationVisitor annotationVisitor = this.parent.visitAnnotation(string, bl);
            if (string.equals("Lcom/sleepycat/persist/model/KeyField;")) {
                this.order = new OrderInfo(annotationVisitor);
                annotationVisitor = this.order;
            } else if (string.equals("Lcom/sleepycat/persist/model/PrimaryKey;")) {
                this.isPriKey = true;
            } else if (string.equals("Lcom/sleepycat/persist/model/SecondaryKey;")) {
                this.isSecKey = true;
            } else if (string.equals("Lcom/sleepycat/persist/model/NotPersistent;")) {
                this.isTransient = true;
            } else if (string.equals("Lcom/sleepycat/persist/model/NotTransient;")) {
                this.isTransient = false;
            }
            return annotationVisitor;
        }

        public void visitAttribute(Attribute attribute) {
            this.parent.visitAttribute(attribute);
        }

        public void visitEnd() {
            this.parent.visitEnd();
        }

        public String toString() {
            String string = this.isPriKey ? "PrimaryKey" : (this.isSecKey ? "SecondaryKey" : (this.order != null ? "CompositeKeyField " + this.order.value : "NonKeyField"));
            return "[" + string + ' ' + this.name + ' ' + this.type + ']';
        }
    }

    static class NotPersistentException
    extends RuntimeException {
        NotPersistentException() {
        }
    }
}

